/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.sql.statement.tcl;

import java.util.Arrays;
import java.util.Collection;
import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.constant.SQLType;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.AbstractSQLStatement;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngine;
import org.apache.shardingsphere.core.parse.old.lexer.token.DefaultKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.Keyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.TokenType;

public class TCLStatement
extends AbstractSQLStatement {
    private static final Collection<Keyword> STATEMENT_PREFIX = Arrays.asList(DefaultKeyword.COMMIT, DefaultKeyword.ROLLBACK, DefaultKeyword.SAVEPOINT, DefaultKeyword.BEGIN);

    public TCLStatement() {
        super(SQLType.TCL);
    }

    public static boolean isTCL(TokenType tokenType) {
        return STATEMENT_PREFIX.contains(tokenType);
    }

    public static boolean isTCLUnsafe(DatabaseType databaseType, TokenType tokenType, LexerEngine lexerEngine) {
        if (DefaultKeyword.SET.equals(tokenType) || DatabaseType.SQLServer.equals((Object)databaseType) && DefaultKeyword.IF.equals(tokenType)) {
            lexerEngine.skipUntil(DefaultKeyword.TRANSACTION, DefaultKeyword.AUTOCOMMIT, DefaultKeyword.IMPLICIT_TRANSACTIONS);
            if (!lexerEngine.isEnd()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return "TCLStatement(super=" + super.toString() + ")";
    }
}

