/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.sql.token;

import org.apache.shardingsphere.core.parse.antlr.constant.QuoteCharacter;
import org.apache.shardingsphere.core.parse.antlr.sql.token.SQLToken;
import org.apache.shardingsphere.core.parse.util.SQLUtil;

public final class TableToken
extends SQLToken {
    private final String tableName;
    private final QuoteCharacter quoteCharacter;
    private final int schemaNameLength;

    public TableToken(int startIndex, String tableName, QuoteCharacter quoteCharacter, int schemaNameLength) {
        super(startIndex);
        this.tableName = SQLUtil.getExactlyValue(tableName);
        this.quoteCharacter = quoteCharacter;
        this.schemaNameLength = schemaNameLength;
    }

    public int getLength() {
        return this.schemaNameLength + this.tableName.length() + this.quoteCharacter.getStartDelimiter().length() + this.quoteCharacter.getEndDelimiter().length();
    }

    @Override
    public String toString() {
        return "TableToken(tableName=" + this.getTableName() + ", quoteCharacter=" + (Object)((Object)this.getQuoteCharacter()) + ", schemaNameLength=" + this.schemaNameLength + ")";
    }

    public String getTableName() {
        return this.tableName;
    }

    public QuoteCharacter getQuoteCharacter() {
        return this.quoteCharacter;
    }
}

