/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.hook;

import java.util.Collection;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.hook.ParsingHook;
import org.apache.shardingsphere.core.spi.NewInstanceServiceLoader;

public final class SPIParsingHook
implements ParsingHook {
    private final Collection<ParsingHook> parsingHooks = NewInstanceServiceLoader.newServiceInstances(ParsingHook.class);

    @Override
    public void start(String sql) {
        for (ParsingHook each : this.parsingHooks) {
            each.start(sql);
        }
    }

    @Override
    public void finishSuccess(SQLStatement sqlStatement, ShardingTableMetaData shardingTableMetaData) {
        for (ParsingHook each : this.parsingHooks) {
            each.finishSuccess(sqlStatement, shardingTableMetaData);
        }
    }

    @Override
    public void finishFailure(Exception cause) {
        for (ParsingHook each : this.parsingHooks) {
            each.finishFailure(cause);
        }
    }

    static {
        NewInstanceServiceLoader.register(ParsingHook.class);
    }
}

