/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.lexer;

import com.google.common.collect.Sets;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.old.lexer.Lexer;
import org.apache.shardingsphere.core.parse.old.lexer.dialect.h2.H2Lexer;
import org.apache.shardingsphere.core.parse.old.lexer.dialect.mysql.MySQLLexer;
import org.apache.shardingsphere.core.parse.old.lexer.dialect.oracle.OracleLexer;
import org.apache.shardingsphere.core.parse.old.lexer.dialect.postgresql.PostgreSQLLexer;
import org.apache.shardingsphere.core.parse.old.lexer.dialect.sqlserver.SQLServerLexer;
import org.apache.shardingsphere.core.parse.old.lexer.token.Assist;
import org.apache.shardingsphere.core.parse.old.lexer.token.Symbol;
import org.apache.shardingsphere.core.parse.old.lexer.token.Token;
import org.apache.shardingsphere.core.parse.old.lexer.token.TokenType;
import org.apache.shardingsphere.core.parse.old.parser.exception.SQLParsingException;
import org.apache.shardingsphere.core.parse.old.parser.exception.SQLParsingUnsupportedException;

public final class LexerEngine {
    private final Lexer lexer;

    public String getInput() {
        return this.lexer.getInput();
    }

    public void nextToken() {
        this.lexer.nextToken();
    }

    public boolean isEnd() {
        return Assist.END == this.lexer.getCurrentToken().getType();
    }

    public Token getCurrentToken() {
        return this.lexer.getCurrentToken();
    }

    public String skipParentheses(SQLStatement sqlStatement) {
        StringBuilder result = new StringBuilder("");
        int count = 0;
        if (Symbol.LEFT_PAREN == this.lexer.getCurrentToken().getType()) {
            int beginPosition = this.lexer.getCurrentToken().getEndPosition();
            result.append(Symbol.LEFT_PAREN.getLiterals());
            this.lexer.nextToken();
            while (true) {
                if (this.equalAny(Symbol.QUESTION)) {
                    sqlStatement.increaseParametersIndex();
                }
                if (Assist.END == this.lexer.getCurrentToken().getType() || Symbol.RIGHT_PAREN == this.lexer.getCurrentToken().getType() && 0 == count) break;
                if (Symbol.LEFT_PAREN == this.lexer.getCurrentToken().getType()) {
                    ++count;
                } else if (Symbol.RIGHT_PAREN == this.lexer.getCurrentToken().getType()) {
                    --count;
                }
                this.lexer.nextToken();
            }
            result.append(this.lexer.getInput().substring(beginPosition, this.lexer.getCurrentToken().getEndPosition()));
            this.lexer.nextToken();
        }
        return result.toString();
    }

    public void accept(TokenType tokenType) {
        if (this.lexer.getCurrentToken().getType() != tokenType) {
            throw new SQLParsingException(this.lexer, tokenType);
        }
        this.lexer.nextToken();
    }

    public boolean equalAny(TokenType ... tokenTypes) {
        for (TokenType each : tokenTypes) {
            if (each != this.lexer.getCurrentToken().getType()) continue;
            return true;
        }
        return false;
    }

    public boolean skipIfEqual(TokenType ... tokenTypes) {
        if (this.equalAny(tokenTypes)) {
            this.lexer.nextToken();
            return true;
        }
        return false;
    }

    public void skipAll(TokenType ... tokenTypes) {
        HashSet tokenTypeSet = Sets.newHashSet((Object[])tokenTypes);
        while (tokenTypeSet.contains(this.lexer.getCurrentToken().getType())) {
            this.lexer.nextToken();
        }
    }

    public void skipUntil(TokenType ... tokenTypes) {
        HashSet tokenTypeSet = Sets.newHashSet((Object[])tokenTypes);
        tokenTypeSet.add(Assist.END);
        while (!tokenTypeSet.contains(this.lexer.getCurrentToken().getType())) {
            this.lexer.nextToken();
        }
    }

    public void unsupportedIfEqual(TokenType ... tokenTypes) {
        if (this.equalAny(tokenTypes)) {
            throw new SQLParsingUnsupportedException(this.lexer.getCurrentToken().getType());
        }
    }

    public void unsupportedIfNotSkip(TokenType ... tokenTypes) {
        if (!this.skipIfEqual(tokenTypes)) {
            throw new SQLParsingUnsupportedException(this.lexer.getCurrentToken().getType());
        }
    }

    public DatabaseType getDatabaseType() {
        if (this.lexer instanceof H2Lexer) {
            return DatabaseType.H2;
        }
        if (this.lexer instanceof MySQLLexer) {
            return DatabaseType.MySQL;
        }
        if (this.lexer instanceof OracleLexer) {
            return DatabaseType.Oracle;
        }
        if (this.lexer instanceof SQLServerLexer) {
            return DatabaseType.SQLServer;
        }
        if (this.lexer instanceof PostgreSQLLexer) {
            return DatabaseType.PostgreSQL;
        }
        throw new UnsupportedOperationException(String.format("Cannot support lexer class: %s", this.lexer.getClass().getCanonicalName()));
    }

    @ConstructorProperties(value={"lexer"})
    public LexerEngine(Lexer lexer) {
        this.lexer = lexer;
    }
}

