/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.lexer;

import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngine;
import org.apache.shardingsphere.core.parse.old.lexer.dialect.h2.H2Lexer;
import org.apache.shardingsphere.core.parse.old.lexer.dialect.mysql.MySQLLexer;
import org.apache.shardingsphere.core.parse.old.lexer.dialect.oracle.OracleLexer;
import org.apache.shardingsphere.core.parse.old.lexer.dialect.postgresql.PostgreSQLLexer;
import org.apache.shardingsphere.core.parse.old.lexer.dialect.sqlserver.SQLServerLexer;

public final class LexerEngineFactory {
    public static LexerEngine newInstance(DatabaseType dbType, String sql) {
        switch (dbType) {
            case H2: {
                return new LexerEngine(new H2Lexer(sql));
            }
            case MySQL: {
                return new LexerEngine(new MySQLLexer(sql));
            }
            case Oracle: {
                return new LexerEngine(new OracleLexer(sql));
            }
            case SQLServer: {
                return new LexerEngine(new SQLServerLexer(sql));
            }
            case PostgreSQL: {
                return new LexerEngine(new PostgreSQLLexer(sql));
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", dbType));
    }

    private LexerEngineFactory() {
    }
}

