/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.lexer.analyzer;

import java.beans.ConstructorProperties;
import org.apache.shardingsphere.core.parse.old.lexer.analyzer.CharType;
import org.apache.shardingsphere.core.parse.old.lexer.analyzer.Dictionary;
import org.apache.shardingsphere.core.parse.old.lexer.analyzer.UnterminatedCharException;
import org.apache.shardingsphere.core.parse.old.lexer.token.DefaultKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.Literals;
import org.apache.shardingsphere.core.parse.old.lexer.token.Symbol;
import org.apache.shardingsphere.core.parse.old.lexer.token.Token;
import org.apache.shardingsphere.core.parse.old.lexer.token.TokenType;

public final class Tokenizer {
    private static final int MYSQL_SPECIAL_COMMENT_BEGIN_SYMBOL_LENGTH = 1;
    private static final int COMMENT_BEGIN_SYMBOL_LENGTH = 2;
    private static final int HINT_BEGIN_SYMBOL_LENGTH = 3;
    private static final int COMMENT_AND_HINT_END_SYMBOL_LENGTH = 2;
    private static final int HEX_BEGIN_SYMBOL_LENGTH = 2;
    private final String input;
    private final Dictionary dictionary;
    private final int offset;

    public int skipWhitespace() {
        int length = 0;
        while (CharType.isWhitespace(this.charAt(this.offset + length))) {
            ++length;
        }
        return this.offset + length;
    }

    public int skipComment() {
        char next;
        char current = this.charAt(this.offset);
        if (this.isSingleLineCommentBegin(current, next = this.charAt(this.offset + 1))) {
            return this.skipSingleLineComment(2);
        }
        if ('#' == current) {
            return this.skipSingleLineComment(1);
        }
        if (this.isMultipleLineCommentBegin(current, next)) {
            return this.skipMultiLineComment();
        }
        return this.offset;
    }

    private boolean isSingleLineCommentBegin(char ch, char next) {
        return '/' == ch && '/' == next || '-' == ch && '-' == next;
    }

    private int skipSingleLineComment(int commentSymbolLength) {
        int length = commentSymbolLength;
        while (!CharType.isEndOfInput(this.charAt(this.offset + length)) && '\n' != this.charAt(this.offset + length)) {
            ++length;
        }
        return this.offset + length + 1;
    }

    private boolean isMultipleLineCommentBegin(char ch, char next) {
        return '/' == ch && '*' == next;
    }

    private int skipMultiLineComment() {
        return this.untilCommentAndHintTerminateSign(2);
    }

    public int skipHint() {
        return this.untilCommentAndHintTerminateSign(3);
    }

    private int untilCommentAndHintTerminateSign(int beginSymbolLength) {
        int length = beginSymbolLength;
        while (!this.isMultipleLineCommentEnd(this.charAt(this.offset + length), this.charAt(this.offset + length + 1))) {
            if (CharType.isEndOfInput(this.charAt(this.offset + length))) {
                throw new UnterminatedCharException("*/");
            }
            ++length;
        }
        return this.offset + length + 2;
    }

    private boolean isMultipleLineCommentEnd(char ch, char next) {
        return '*' == ch && '/' == next;
    }

    public Token scanVariable() {
        int length = 1;
        if ('@' == this.charAt(this.offset + 1)) {
            ++length;
        }
        while (this.isVariableChar(this.charAt(this.offset + length))) {
            ++length;
        }
        return new Token(Literals.VARIABLE, this.input.substring(this.offset, this.offset + length), this.offset + length);
    }

    private boolean isVariableChar(char ch) {
        return this.isIdentifierChar(ch) || '.' == ch;
    }

    public Token scanIdentifier() {
        if ('`' == this.charAt(this.offset)) {
            int length = this.getLengthUntilTerminatedChar('`');
            return new Token(Literals.IDENTIFIER, this.input.substring(this.offset, this.offset + length), this.offset + length);
        }
        if ('\"' == this.charAt(this.offset)) {
            int length = this.getLengthUntilTerminatedChar('\"');
            return new Token(Literals.IDENTIFIER, this.input.substring(this.offset, this.offset + length), this.offset + length);
        }
        if ('[' == this.charAt(this.offset)) {
            int length = this.getLengthUntilTerminatedChar(']');
            return new Token(Literals.IDENTIFIER, this.input.substring(this.offset, this.offset + length), this.offset + length);
        }
        int length = 0;
        while (this.isIdentifierChar(this.charAt(this.offset + length))) {
            ++length;
        }
        String literals = this.input.substring(this.offset, this.offset + length);
        if (this.isAmbiguousIdentifier(literals)) {
            return new Token(this.processAmbiguousIdentifier(this.offset + length, literals), literals, this.offset + length);
        }
        return new Token(this.dictionary.findTokenType(literals, Literals.IDENTIFIER), literals, this.offset + length);
    }

    private int getLengthUntilTerminatedChar(char terminatedChar) {
        int length = 1;
        while (terminatedChar != this.charAt(this.offset + length) || this.hasEscapeChar(terminatedChar, this.offset + length)) {
            if (this.offset + length >= this.input.length()) {
                throw new UnterminatedCharException(terminatedChar);
            }
            if (this.hasEscapeChar(terminatedChar, this.offset + length)) {
                ++length;
            }
            ++length;
        }
        return length + 1;
    }

    private boolean hasEscapeChar(char charIdentifier, int offset) {
        return charIdentifier == this.charAt(offset) && charIdentifier == this.charAt(offset + 1);
    }

    private boolean isIdentifierChar(char ch) {
        return CharType.isAlphabet(ch) || CharType.isDigital(ch) || '_' == ch || '$' == ch || '#' == ch;
    }

    private boolean isAmbiguousIdentifier(String literals) {
        return DefaultKeyword.ORDER.name().equalsIgnoreCase(literals) || DefaultKeyword.GROUP.name().equalsIgnoreCase(literals);
    }

    private TokenType processAmbiguousIdentifier(int offset, String literals) {
        int i = 0;
        while (CharType.isWhitespace(this.charAt(offset + i))) {
            ++i;
        }
        if (DefaultKeyword.BY.name().equalsIgnoreCase(String.valueOf(new char[]{this.charAt(offset + i), this.charAt(offset + i + 1)}))) {
            return this.dictionary.findTokenType(literals);
        }
        return Literals.IDENTIFIER;
    }

    public Token scanHexDecimal() {
        int length = 2;
        if ('-' == this.charAt(this.offset + length)) {
            ++length;
        }
        while (this.isHex(this.charAt(this.offset + length))) {
            ++length;
        }
        return new Token(Literals.HEX, this.input.substring(this.offset, this.offset + length), this.offset + length);
    }

    private boolean isHex(char ch) {
        return ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f' || CharType.isDigital(ch);
    }

    public Token scanNumber() {
        int length = 0;
        if ('-' == this.charAt(this.offset + length)) {
            ++length;
        }
        length += this.getDigitalLength(this.offset + length);
        boolean isFloat = false;
        if ('.' == this.charAt(this.offset + length)) {
            isFloat = true;
            ++length;
            length += this.getDigitalLength(this.offset + length);
        }
        if (this.isScientificNotation(this.offset + length)) {
            isFloat = true;
            if ('+' == this.charAt(this.offset + ++length) || '-' == this.charAt(this.offset + length)) {
                ++length;
            }
            length += this.getDigitalLength(this.offset + length);
        }
        if (this.isBinaryNumber(this.offset + length)) {
            isFloat = true;
            ++length;
        }
        return new Token(isFloat ? Literals.FLOAT : Literals.INT, this.input.substring(this.offset, this.offset + length), this.offset + length);
    }

    private int getDigitalLength(int offset) {
        int result = 0;
        while (CharType.isDigital(this.charAt(offset + result))) {
            ++result;
        }
        return result;
    }

    private boolean isScientificNotation(int offset) {
        char current = this.charAt(offset);
        return 'e' == current || 'E' == current;
    }

    private boolean isBinaryNumber(int offset) {
        char current = this.charAt(offset);
        return 'f' == current || 'F' == current || 'd' == current || 'D' == current;
    }

    public Token scanChars() {
        return this.scanChars(this.charAt(this.offset));
    }

    private Token scanChars(char terminatedChar) {
        int length = this.getLengthUntilTerminatedChar(terminatedChar);
        return new Token(Literals.CHARS, this.input.substring(this.offset + 1, this.offset + length - 1), this.offset + length);
    }

    public Token scanSymbol() {
        Symbol symbol;
        int length = 0;
        while (CharType.isSymbol(this.charAt(this.offset + length))) {
            ++length;
        }
        String literals = this.input.substring(this.offset, this.offset + length);
        while (null == (symbol = Symbol.literalsOf(literals))) {
            literals = this.input.substring(this.offset, this.offset + --length);
        }
        return new Token(symbol, literals, this.offset + length);
    }

    private char charAt(int index) {
        return index >= this.input.length() ? (char)'\u001a' : this.input.charAt(index);
    }

    @ConstructorProperties(value={"input", "dictionary", "offset"})
    public Tokenizer(String input, Dictionary dictionary, int offset) {
        this.input = input;
        this.dictionary = dictionary;
        this.offset = offset;
    }
}

