/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.clause;

import com.google.common.base.Optional;
import org.apache.shardingsphere.core.constant.OrderDirection;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.SelectStatement;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngine;
import org.apache.shardingsphere.core.parse.old.lexer.token.DefaultKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.Keyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.Symbol;
import org.apache.shardingsphere.core.parse.old.parser.clause.SQLClauseParser;
import org.apache.shardingsphere.core.parse.old.parser.clause.expression.BasicExpressionParser;
import org.apache.shardingsphere.core.parse.old.parser.context.orderby.OrderItem;
import org.apache.shardingsphere.core.parse.old.parser.dialect.ExpressionParserFactory;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLIdentifierExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLIgnoreExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLNumberExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLPropertyExpression;
import org.apache.shardingsphere.core.parse.util.SQLUtil;

public abstract class GroupByClauseParser
implements SQLClauseParser {
    private final LexerEngine lexerEngine;
    private final BasicExpressionParser basicExpressionParser;

    public GroupByClauseParser(LexerEngine lexerEngine) {
        this.lexerEngine = lexerEngine;
        this.basicExpressionParser = ExpressionParserFactory.createBasicExpressionParser(lexerEngine);
    }

    public final void parse(SelectStatement selectStatement) {
        if (!this.lexerEngine.skipIfEqual(DefaultKeyword.GROUP)) {
            return;
        }
        this.lexerEngine.accept(DefaultKeyword.BY);
        while (true) {
            this.addGroupByItem(this.basicExpressionParser.parse(selectStatement), selectStatement);
            if (!this.lexerEngine.equalAny(Symbol.COMMA)) break;
            this.lexerEngine.nextToken();
        }
        this.lexerEngine.skipAll(this.getSkippedKeywordAfterGroupBy());
        selectStatement.setGroupByLastIndex(this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length() - 1);
    }

    private void addGroupByItem(SQLExpression sqlExpression, SelectStatement selectStatement) {
        OrderItem orderItem;
        this.lexerEngine.unsupportedIfEqual(this.getUnsupportedKeywordBeforeGroupByItem());
        OrderDirection orderDirection = OrderDirection.ASC;
        if (this.lexerEngine.equalAny(DefaultKeyword.ASC)) {
            this.lexerEngine.nextToken();
        } else if (this.lexerEngine.skipIfEqual(DefaultKeyword.DESC)) {
            orderDirection = OrderDirection.DESC;
        }
        if (sqlExpression instanceof SQLPropertyExpression) {
            SQLPropertyExpression sqlPropertyExpression = (SQLPropertyExpression)sqlExpression;
            orderItem = new OrderItem(SQLUtil.getExactlyValue(sqlPropertyExpression.getOwner().getName()), SQLUtil.getExactlyValue(sqlPropertyExpression.getName()), orderDirection, OrderDirection.ASC);
            Optional<String> alias = selectStatement.getAlias(SQLUtil.getExactlyValue(sqlPropertyExpression.getOwner().getName() + "." + SQLUtil.getExactlyValue(sqlPropertyExpression.getName())));
            if (alias.isPresent()) {
                orderItem.setAlias((String)alias.get());
            }
        } else if (sqlExpression instanceof SQLIdentifierExpression) {
            SQLIdentifierExpression sqlIdentifierExpression = (SQLIdentifierExpression)sqlExpression;
            orderItem = new OrderItem(SQLUtil.getExactlyValue(sqlIdentifierExpression.getName()), orderDirection, OrderDirection.ASC);
            Optional<String> alias = selectStatement.getAlias(SQLUtil.getExactlyValue(sqlIdentifierExpression.getName()));
            if (alias.isPresent()) {
                orderItem.setAlias((String)alias.get());
            }
        } else if (sqlExpression instanceof SQLIgnoreExpression) {
            SQLIgnoreExpression sqlIgnoreExpression = (SQLIgnoreExpression)sqlExpression;
            orderItem = new OrderItem(sqlIgnoreExpression.getExpression(), orderDirection, OrderDirection.ASC);
            Optional<String> alias = selectStatement.getAlias(sqlIgnoreExpression.getExpression());
            if (alias.isPresent()) {
                orderItem.setAlias((String)alias.get());
            }
        } else if (sqlExpression instanceof SQLNumberExpression) {
            orderItem = new OrderItem(((SQLNumberExpression)sqlExpression).getNumber().intValue(), orderDirection, orderDirection);
        } else {
            return;
        }
        selectStatement.getGroupByItems().add(orderItem);
    }

    protected abstract Keyword[] getUnsupportedKeywordBeforeGroupByItem();

    protected abstract Keyword[] getSkippedKeywordAfterGroupBy();
}

