/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.clause;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngine;
import org.apache.shardingsphere.core.parse.old.lexer.token.Assist;
import org.apache.shardingsphere.core.parse.old.lexer.token.Symbol;
import org.apache.shardingsphere.core.parse.old.parser.clause.SQLClauseParser;
import org.apache.shardingsphere.core.parse.old.parser.clause.expression.BasicExpressionParser;
import org.apache.shardingsphere.core.parse.old.parser.dialect.ExpressionParserFactory;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLIdentifierExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLIgnoreExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLPropertyExpression;
import org.apache.shardingsphere.core.parse.util.SQLUtil;

public final class InsertColumnsClauseParser
implements SQLClauseParser {
    private final LexerEngine lexerEngine;
    private final BasicExpressionParser basicExpressionParser;

    public InsertColumnsClauseParser(LexerEngine lexerEngine) {
        this.lexerEngine = lexerEngine;
        this.basicExpressionParser = ExpressionParserFactory.createBasicExpressionParser(lexerEngine);
    }

    public void parse(InsertStatement insertStatement, ShardingTableMetaData shardingTableMetaData) {
        String tableName = insertStatement.getTables().getSingleTableName();
        insertStatement.getColumnNames().addAll(this.lexerEngine.equalAny(Symbol.LEFT_PAREN) ? this.parseWithColumn(insertStatement) : this.parseWithoutColumn(shardingTableMetaData, tableName));
    }

    private Collection<String> parseWithColumn(InsertStatement insertStatement) {
        LinkedList<String> result = new LinkedList<String>();
        do {
            this.lexerEngine.nextToken();
            SQLExpression sqlExpression = this.basicExpressionParser.parse(insertStatement);
            String columnName = null;
            if (sqlExpression instanceof SQLPropertyExpression) {
                columnName = SQLUtil.getExactlyValue(((SQLPropertyExpression)sqlExpression).getName());
            }
            if (sqlExpression instanceof SQLIdentifierExpression) {
                columnName = SQLUtil.getExactlyValue(((SQLIdentifierExpression)sqlExpression).getName());
            }
            if (sqlExpression instanceof SQLIgnoreExpression) {
                columnName = SQLUtil.getExactlyValue(((SQLIgnoreExpression)sqlExpression).getExpression());
            }
            Preconditions.checkNotNull((Object)columnName);
            result.add(columnName);
        } while (!this.lexerEngine.equalAny(Symbol.RIGHT_PAREN) && !this.lexerEngine.equalAny(Assist.END));
        this.lexerEngine.nextToken();
        return result;
    }

    private Collection<String> parseWithoutColumn(ShardingTableMetaData shardingTableMetaData, String tableName) {
        LinkedList<String> result = new LinkedList<String>();
        if (shardingTableMetaData.containsTable(tableName)) {
            result.addAll(shardingTableMetaData.getAllColumnNames(tableName));
        }
        return result;
    }
}

