/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.clause;

import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngine;
import org.apache.shardingsphere.core.parse.old.lexer.token.DefaultKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.Keyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.Symbol;
import org.apache.shardingsphere.core.parse.old.parser.clause.SQLClauseParser;
import org.apache.shardingsphere.core.parse.old.parser.clause.expression.BasicExpressionParser;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.Column;
import org.apache.shardingsphere.core.parse.old.parser.dialect.ExpressionParserFactory;
import org.apache.shardingsphere.core.parse.old.parser.exception.SQLParsingException;
import org.apache.shardingsphere.core.parse.util.SQLUtil;
import org.apache.shardingsphere.core.rule.ShardingRule;

public abstract class InsertDuplicateKeyUpdateClauseParser
implements SQLClauseParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;
    private final BasicExpressionParser basicExpressionParser;

    public InsertDuplicateKeyUpdateClauseParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
        this.basicExpressionParser = ExpressionParserFactory.createBasicExpressionParser(lexerEngine);
    }

    public void parse(InsertStatement insertStatement) {
        if (!this.lexerEngine.skipIfEqual(this.getCustomizedInsertKeywords())) {
            return;
        }
        this.lexerEngine.accept(DefaultKeyword.DUPLICATE);
        this.lexerEngine.accept(DefaultKeyword.KEY);
        this.lexerEngine.accept(DefaultKeyword.UPDATE);
        do {
            Column column;
            if (this.shardingRule.isShardingColumn((column = new Column(SQLUtil.getExactlyValue(this.lexerEngine.getCurrentToken().getLiterals()), insertStatement.getTables().getSingleTableName())).getName(), column.getTableName())) {
                throw new SQLParsingException("INSERT INTO .... ON DUPLICATE KEY UPDATE can not support on sharding column, token is '%s', literals is '%s'.", this.lexerEngine.getCurrentToken().getType(), this.lexerEngine.getCurrentToken().getLiterals());
            }
            this.basicExpressionParser.parse(insertStatement);
            this.lexerEngine.accept(Symbol.EQ);
            if (this.lexerEngine.skipIfEqual(DefaultKeyword.VALUES)) {
                this.lexerEngine.accept(Symbol.LEFT_PAREN);
                this.basicExpressionParser.parse(insertStatement);
                this.lexerEngine.accept(Symbol.RIGHT_PAREN);
                continue;
            }
            this.lexerEngine.nextToken();
        } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
    }

    protected abstract Keyword[] getCustomizedInsertKeywords();
}

