/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.clause;

import java.beans.ConstructorProperties;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngine;
import org.apache.shardingsphere.core.parse.old.lexer.token.DefaultKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.Keyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.Symbol;
import org.apache.shardingsphere.core.parse.old.parser.clause.SQLClauseParser;
import org.apache.shardingsphere.core.parse.old.parser.clause.TableReferencesClauseParser;

public abstract class InsertIntoClauseParser
implements SQLClauseParser {
    private final LexerEngine lexerEngine;
    private final TableReferencesClauseParser tableReferencesClauseParser;

    public void parse(InsertStatement insertStatement) {
        this.lexerEngine.unsupportedIfEqual(this.getUnsupportedKeywordsBeforeInto());
        this.lexerEngine.skipUntil(DefaultKeyword.INTO);
        this.lexerEngine.nextToken();
        this.tableReferencesClauseParser.parse(insertStatement, true);
        this.skipBetweenTableAndValues(insertStatement);
    }

    protected abstract Keyword[] getUnsupportedKeywordsBeforeInto();

    private void skipBetweenTableAndValues(InsertStatement insertStatement) {
        while (this.lexerEngine.skipIfEqual(this.getSkippedKeywordsBetweenTableAndValues())) {
            this.lexerEngine.nextToken();
            if (!this.lexerEngine.equalAny(Symbol.LEFT_PAREN)) continue;
            this.lexerEngine.skipParentheses(insertStatement);
        }
    }

    protected abstract Keyword[] getSkippedKeywordsBetweenTableAndValues();

    @ConstructorProperties(value={"lexerEngine", "tableReferencesClauseParser"})
    public InsertIntoClauseParser(LexerEngine lexerEngine, TableReferencesClauseParser tableReferencesClauseParser) {
        this.lexerEngine = lexerEngine;
        this.tableReferencesClauseParser = tableReferencesClauseParser;
    }
}

