/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.clause;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.token.InsertValuesToken;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngine;
import org.apache.shardingsphere.core.parse.old.lexer.token.DefaultKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.Keyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.Symbol;
import org.apache.shardingsphere.core.parse.old.parser.clause.SQLClauseParser;
import org.apache.shardingsphere.core.parse.old.parser.clause.expression.BasicExpressionParser;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.AndCondition;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.Column;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.Condition;
import org.apache.shardingsphere.core.parse.old.parser.context.insertvalue.InsertValue;
import org.apache.shardingsphere.core.parse.old.parser.dialect.ExpressionParserFactory;
import org.apache.shardingsphere.core.parse.old.parser.exception.SQLParsingException;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLNumberExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLPlaceholderExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLTextExpression;
import org.apache.shardingsphere.core.rule.ShardingRule;

public abstract class InsertValuesClauseParser
implements SQLClauseParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;
    private final BasicExpressionParser basicExpressionParser;

    public InsertValuesClauseParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
        this.basicExpressionParser = ExpressionParserFactory.createBasicExpressionParser(lexerEngine);
    }

    public void parse(InsertStatement insertStatement) {
        LinkedList<Keyword> valueKeywords = new LinkedList<Keyword>();
        valueKeywords.add(DefaultKeyword.VALUES);
        valueKeywords.addAll(Arrays.asList(this.getSynonymousKeywordsForValues()));
        if (this.lexerEngine.skipIfEqual(valueKeywords.toArray(new Keyword[valueKeywords.size()]))) {
            this.parseValues(insertStatement);
        }
    }

    protected abstract Keyword[] getSynonymousKeywordsForValues();

    private void parseValues(InsertStatement insertStatement) {
        Optional<InsertValuesToken> insertValuesToken = insertStatement.findSQLToken(InsertValuesToken.class);
        Preconditions.checkState((boolean)insertValuesToken.isPresent());
        insertStatement.getSQLTokens().remove(insertValuesToken.get());
        insertStatement.addSQLToken(new InsertValuesToken(((InsertValuesToken)insertValuesToken.get()).getStartIndex()));
        do {
            this.lexerEngine.accept(Symbol.LEFT_PAREN);
            LinkedList<SQLExpression> sqlExpressions = new LinkedList<SQLExpression>();
            int count = 0;
            do {
                sqlExpressions.add(this.basicExpressionParser.parse(insertStatement));
                this.skipsDoubleColon();
                ++count;
            } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
            ArrayList<String> columnNames = new ArrayList<String>(insertStatement.getColumnNames());
            Optional generateKeyColumnName = this.shardingRule.findGenerateKeyColumnName(insertStatement.getTables().getSingleTableName());
            if (generateKeyColumnName.isPresent() && count != insertStatement.getColumnNames().size()) {
                columnNames.remove(generateKeyColumnName.get());
            }
            count = 0;
            AndCondition andCondition = new AndCondition();
            String tableName = insertStatement.getTables().getSingleTableName();
            for (String each : columnNames) {
                SQLExpression sqlExpression = (SQLExpression)sqlExpressions.get(count);
                if (this.shardingRule.isShardingColumn(each, tableName)) {
                    if (!(sqlExpression instanceof SQLNumberExpression || sqlExpression instanceof SQLTextExpression || sqlExpression instanceof SQLPlaceholderExpression)) {
                        throw new SQLParsingException("INSERT INTO can not support complex expression value on sharding column '%s'.", each);
                    }
                    andCondition.getConditions().add(new Condition(new Column(each, tableName), sqlExpression));
                }
                ++count;
            }
            this.lexerEngine.accept(Symbol.RIGHT_PAREN);
            InsertValue insertValue = new InsertValue(sqlExpressions);
            insertStatement.getValues().add(insertValue);
            insertStatement.getRouteConditions().getOrCondition().getAndConditions().add(andCondition);
        } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
    }

    private void skipsDoubleColon() {
        if (this.lexerEngine.skipIfEqual(Symbol.DOUBLE_COLON)) {
            this.lexerEngine.nextToken();
        }
    }
}

