/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.clause;

import com.google.common.base.Optional;
import java.util.LinkedList;
import org.apache.shardingsphere.core.constant.OrderDirection;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.SelectStatement;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngine;
import org.apache.shardingsphere.core.parse.old.lexer.dialect.oracle.OracleKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.DefaultKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.Symbol;
import org.apache.shardingsphere.core.parse.old.parser.clause.SQLClauseParser;
import org.apache.shardingsphere.core.parse.old.parser.clause.expression.BasicExpressionParser;
import org.apache.shardingsphere.core.parse.old.parser.context.orderby.OrderItem;
import org.apache.shardingsphere.core.parse.old.parser.dialect.ExpressionParserFactory;
import org.apache.shardingsphere.core.parse.old.parser.exception.SQLParsingException;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLIdentifierExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLIgnoreExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLNumberExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLPlaceholderExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLPropertyExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLTextExpression;
import org.apache.shardingsphere.core.parse.util.SQLUtil;

public abstract class OrderByClauseParser
implements SQLClauseParser {
    private final LexerEngine lexerEngine;
    private final BasicExpressionParser basicExpressionParser;

    public OrderByClauseParser(LexerEngine lexerEngine) {
        this.lexerEngine = lexerEngine;
        this.basicExpressionParser = ExpressionParserFactory.createBasicExpressionParser(lexerEngine);
    }

    public final void parse(SelectStatement selectStatement) {
        if (!this.lexerEngine.skipIfEqual(DefaultKeyword.ORDER)) {
            return;
        }
        LinkedList<Object> result = new LinkedList<Object>();
        this.lexerEngine.skipIfEqual(OracleKeyword.SIBLINGS);
        this.lexerEngine.accept(DefaultKeyword.BY);
        do {
            Optional<OrderItem> orderItem;
            if (!(orderItem = this.parseSelectOrderByItem(selectStatement)).isPresent()) continue;
            result.add(orderItem.get());
        } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
        selectStatement.getOrderByItems().addAll(result);
    }

    private Optional<OrderItem> parseSelectOrderByItem(SelectStatement selectStatement) {
        SQLExpression sqlExpression = this.basicExpressionParser.parse(selectStatement);
        OrderDirection orderDirection = OrderDirection.ASC;
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.ASC)) {
            orderDirection = OrderDirection.ASC;
        } else if (this.lexerEngine.skipIfEqual(DefaultKeyword.DESC)) {
            orderDirection = OrderDirection.DESC;
        }
        if (sqlExpression instanceof SQLTextExpression) {
            return Optional.of((Object)new OrderItem(SQLUtil.getExactlyValue(((SQLTextExpression)sqlExpression).getText()), orderDirection, this.getNullOrderDirection()));
        }
        if (sqlExpression instanceof SQLNumberExpression) {
            return Optional.of((Object)new OrderItem(((SQLNumberExpression)sqlExpression).getNumber().intValue(), orderDirection, this.getNullOrderDirection()));
        }
        if (sqlExpression instanceof SQLIdentifierExpression) {
            OrderItem result = new OrderItem(SQLUtil.getExactlyValue(((SQLIdentifierExpression)sqlExpression).getName()), orderDirection, this.getNullOrderDirection());
            Optional<String> alias = selectStatement.getAlias(SQLUtil.getExactlyValue(((SQLIdentifierExpression)sqlExpression).getName()));
            if (alias.isPresent()) {
                result.setAlias((String)alias.get());
            }
            return Optional.of((Object)result);
        }
        if (sqlExpression instanceof SQLPropertyExpression) {
            SQLPropertyExpression sqlPropertyExpression = (SQLPropertyExpression)sqlExpression;
            OrderItem result = new OrderItem(SQLUtil.getExactlyValue(sqlPropertyExpression.getOwner().getName()), SQLUtil.getExactlyValue(sqlPropertyExpression.getName()), orderDirection, this.getNullOrderDirection());
            Optional<String> alias = selectStatement.getAlias(SQLUtil.getExactlyValue(sqlPropertyExpression.getOwner().getName()) + "." + SQLUtil.getExactlyValue(sqlPropertyExpression.getName()));
            if (alias.isPresent()) {
                result.setAlias((String)alias.get());
            }
            return Optional.of((Object)result);
        }
        if (sqlExpression instanceof SQLIgnoreExpression) {
            SQLIgnoreExpression sqlIgnoreExpression = (SQLIgnoreExpression)sqlExpression;
            OrderItem result = new OrderItem(sqlIgnoreExpression.getExpression(), orderDirection, this.getNullOrderDirection());
            Optional<String> alias = selectStatement.getAlias(sqlIgnoreExpression.getExpression());
            if (alias.isPresent()) {
                result.setAlias((String)alias.get());
            }
            return Optional.of((Object)result);
        }
        if (sqlExpression instanceof SQLPlaceholderExpression) {
            return Optional.absent();
        }
        throw new SQLParsingException(this.lexerEngine);
    }

    protected abstract OrderDirection getNullOrderDirection();

    public LexerEngine getLexerEngine() {
        return this.lexerEngine;
    }
}

