/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.clause;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.core.constant.AggregationType;
import org.apache.shardingsphere.core.parse.antlr.constant.QuoteCharacter;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.SelectStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.token.AggregationDistinctToken;
import org.apache.shardingsphere.core.parse.antlr.sql.token.TableToken;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngine;
import org.apache.shardingsphere.core.parse.old.lexer.token.DefaultKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.Keyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.Symbol;
import org.apache.shardingsphere.core.parse.old.parser.clause.SQLClauseParser;
import org.apache.shardingsphere.core.parse.old.parser.clause.expression.AliasExpressionParser;
import org.apache.shardingsphere.core.parse.old.parser.constant.DerivedAlias;
import org.apache.shardingsphere.core.parse.old.parser.context.selectitem.AggregationDistinctSelectItem;
import org.apache.shardingsphere.core.parse.old.parser.context.selectitem.AggregationSelectItem;
import org.apache.shardingsphere.core.parse.old.parser.context.selectitem.CommonSelectItem;
import org.apache.shardingsphere.core.parse.old.parser.context.selectitem.DistinctSelectItem;
import org.apache.shardingsphere.core.parse.old.parser.context.selectitem.SelectItem;
import org.apache.shardingsphere.core.parse.old.parser.context.selectitem.StarSelectItem;
import org.apache.shardingsphere.core.parse.old.parser.dialect.ExpressionParserFactory;
import org.apache.shardingsphere.core.parse.util.SQLUtil;
import org.apache.shardingsphere.core.rule.ShardingRule;

public abstract class SelectListClauseParser
implements SQLClauseParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;
    private final AliasExpressionParser aliasExpressionParser;

    public SelectListClauseParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
        this.aliasExpressionParser = ExpressionParserFactory.createAliasExpressionParser(lexerEngine);
    }

    public void parse(SelectStatement selectStatement, List<SelectItem> items) {
        do {
            selectStatement.getItems().addAll(this.parseSelectItems(selectStatement));
        } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
        selectStatement.setSelectListStopIndex(this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length());
        items.addAll(selectStatement.getItems());
    }

    private Collection<SelectItem> parseSelectItems(SelectStatement selectStatement) {
        this.lexerEngine.skipIfEqual(this.getSkippedKeywordsBeforeSelectItem());
        Collection<SelectItem> result = this.getSelectItems(selectStatement);
        this.reviseDistinctSelectItems(selectStatement, result);
        return result;
    }

    private Collection<SelectItem> getSelectItems(SelectStatement selectStatement) {
        LinkedList<SelectItem> result = new LinkedList<SelectItem>();
        if (this.isRowNumberSelectItem()) {
            result.add(this.parseRowNumberSelectItem(selectStatement));
        } else if (this.isDistinctSelectItem()) {
            result.add(this.parseDistinctSelectItem(selectStatement));
            this.addStarSelectItem(result);
            this.parseRestSelectItem(selectStatement);
        } else if (this.isStarSelectItem()) {
            selectStatement.setContainStar(true);
            result.add(this.parseStarSelectItem());
        } else if (this.isAggregationSelectItem()) {
            result.add(this.parseAggregationSelectItem(selectStatement));
            this.parseRestSelectItem(selectStatement);
        } else {
            result.add(this.parseCommonOrStarSelectItem(selectStatement));
        }
        return result;
    }

    private void addStarSelectItem(Collection<SelectItem> result) {
        if (this.isStarSelectItem()) {
            result.add(this.parseStarSelectItem());
        }
    }

    private void reviseDistinctSelectItems(SelectStatement selectStatement, Collection<SelectItem> selectItems) {
        for (SelectItem each : selectItems) {
            if (!selectStatement.getDistinctSelectItem().isPresent() || each instanceof StarSelectItem) continue;
            ((DistinctSelectItem)selectStatement.getDistinctSelectItem().get()).getDistinctColumnNames().add(each.getAlias().isPresent() ? (String)each.getAlias().get() : each.getExpression());
        }
    }

    protected abstract Keyword[] getSkippedKeywordsBeforeSelectItem();

    protected abstract boolean isRowNumberSelectItem();

    protected abstract SelectItem parseRowNumberSelectItem(SelectStatement var1);

    private boolean isDistinctSelectItem() {
        return this.lexerEngine.equalAny(DefaultKeyword.DISTINCT);
    }

    private SelectItem parseDistinctSelectItem(SelectStatement selectStatement) {
        this.lexerEngine.nextToken();
        String distinctColumnName = this.lexerEngine.getCurrentToken().getLiterals();
        if (Symbol.STAR == this.lexerEngine.getCurrentToken().getType()) {
            return new DistinctSelectItem(Collections.emptySet(), this.aliasExpressionParser.parseSelectItemAlias());
        }
        this.lexerEngine.nextToken();
        LinkedHashSet<String> distinctColumnNames = new LinkedHashSet<String>();
        distinctColumnNames.add(SQLUtil.getExactlyValue(distinctColumnName + this.parseRestSelectItem(selectStatement)));
        return new DistinctSelectItem(distinctColumnNames, this.aliasExpressionParser.parseSelectItemAlias());
    }

    private boolean isStarSelectItem() {
        return Symbol.STAR.getLiterals().equals(SQLUtil.getExactlyValue(this.lexerEngine.getCurrentToken().getLiterals()));
    }

    private SelectItem parseStarSelectItem() {
        this.lexerEngine.nextToken();
        this.aliasExpressionParser.parseSelectItemAlias();
        return new StarSelectItem();
    }

    private SelectItem parseStarSelectItem(String owner) {
        this.lexerEngine.nextToken();
        this.aliasExpressionParser.parseSelectItemAlias();
        return new StarSelectItem(owner);
    }

    private SelectItem parseCommonOrStarSelectItem(SelectStatement selectStatement) {
        String literals = this.lexerEngine.getCurrentToken().getLiterals();
        int position = this.lexerEngine.getCurrentToken().getEndPosition() - literals.length();
        StringBuilder result = new StringBuilder();
        result.append(literals);
        this.lexerEngine.nextToken();
        if (this.lexerEngine.equalAny(Symbol.LEFT_PAREN)) {
            result.append(this.lexerEngine.skipParentheses(selectStatement));
        } else if (this.lexerEngine.equalAny(Symbol.DOT)) {
            String tableName = SQLUtil.getExactlyValue(literals);
            if (this.shardingRule.findTableRule(tableName).isPresent() || this.shardingRule.isBroadcastTable(tableName) || this.shardingRule.findBindingTableRule(tableName).isPresent()) {
                selectStatement.addSQLToken(new TableToken(position, literals, QuoteCharacter.getQuoteCharacter(literals), 0));
            }
            result.append(this.lexerEngine.getCurrentToken().getLiterals());
            this.lexerEngine.nextToken();
            if (this.lexerEngine.equalAny(Symbol.STAR)) {
                return this.parseStarSelectItem(literals);
            }
            result.append(this.lexerEngine.getCurrentToken().getLiterals());
            this.lexerEngine.nextToken();
        }
        return new CommonSelectItem(SQLUtil.getExactlyValue(result + this.parseRestSelectItem(selectStatement)), this.aliasExpressionParser.parseSelectItemAlias());
    }

    private boolean isAggregationSelectItem() {
        return this.lexerEngine.equalAny(DefaultKeyword.MAX, DefaultKeyword.MIN, DefaultKeyword.SUM, DefaultKeyword.AVG, DefaultKeyword.COUNT);
    }

    private SelectItem parseAggregationSelectItem(SelectStatement selectStatement) {
        AggregationType aggregationType = AggregationType.valueOf((String)this.lexerEngine.getCurrentToken().getLiterals().toUpperCase());
        int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length();
        int endPosition = this.lexerEngine.getCurrentToken().getEndPosition();
        this.lexerEngine.nextToken();
        String innerExpression = this.lexerEngine.skipParentheses(selectStatement);
        return this.isAggregationDistinctSelectItem(innerExpression) ? this.getAggregationDistinctSelectItem(selectStatement, aggregationType, beginPosition, endPosition += innerExpression.length(), innerExpression) : new AggregationSelectItem(aggregationType, innerExpression, this.aliasExpressionParser.parseSelectItemAlias());
    }

    private SelectItem getAggregationDistinctSelectItem(SelectStatement selectStatement, AggregationType aggregationType, int beginPosition, int endPosition, String innerExpression) {
        Optional alias = this.aliasExpressionParser.parseSelectItemAlias().isPresent() ? this.aliasExpressionParser.parseSelectItemAlias() : Optional.of((Object)DerivedAlias.AGGREGATION_DISTINCT_DERIVED.getDerivedAlias(selectStatement.getAggregationDistinctSelectItems().size()));
        AggregationDistinctSelectItem result = new AggregationDistinctSelectItem(aggregationType, innerExpression, (Optional<String>)alias, this.getDistinctColumnName(innerExpression));
        selectStatement.getSQLTokens().add(new AggregationDistinctToken(beginPosition, endPosition - 1, result.getDistinctColumnName(), (Optional<String>)alias));
        return result;
    }

    private boolean isAggregationDistinctSelectItem(String innerExpression) {
        String pattern = "\\(\\s*DISTINCT\\s+.*\\)";
        return Pattern.matches(pattern, innerExpression.toUpperCase());
    }

    private String getDistinctColumnName(String innerExpression) {
        Pattern pattern = Pattern.compile("\\(\\s*DISTINCT\\s+(\\S+)\\s*\\)", 2);
        Matcher matcher = pattern.matcher(innerExpression);
        String result = "";
        if (matcher.find()) {
            result = matcher.group(1);
        }
        return result;
    }

    private String parseRestSelectItem(SelectStatement selectStatement) {
        StringBuilder result = new StringBuilder();
        while (this.lexerEngine.equalAny(Symbol.getOperators())) {
            result.append(this.lexerEngine.getCurrentToken().getLiterals());
            this.lexerEngine.nextToken();
            SelectItem selectItem = this.parseCommonOrStarSelectItem(selectStatement);
            result.append(selectItem.getExpression());
        }
        return result.toString();
    }

    public ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    public LexerEngine getLexerEngine() {
        return this.lexerEngine;
    }

    public AliasExpressionParser getAliasExpressionParser() {
        return this.aliasExpressionParser;
    }
}

