/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.clause;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.shardingsphere.core.parse.antlr.constant.QuoteCharacter;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.token.IndexToken;
import org.apache.shardingsphere.core.parse.antlr.sql.token.InsertValuesToken;
import org.apache.shardingsphere.core.parse.antlr.sql.token.TableToken;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngine;
import org.apache.shardingsphere.core.parse.old.lexer.dialect.mysql.MySQLKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.DefaultKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.Keyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.Symbol;
import org.apache.shardingsphere.core.parse.old.lexer.token.TokenType;
import org.apache.shardingsphere.core.parse.old.parser.clause.SQLClauseParser;
import org.apache.shardingsphere.core.parse.old.parser.clause.expression.AliasExpressionParser;
import org.apache.shardingsphere.core.parse.old.parser.clause.expression.BasicExpressionParser;
import org.apache.shardingsphere.core.parse.old.parser.context.table.Table;
import org.apache.shardingsphere.core.parse.old.parser.dialect.ExpressionParserFactory;
import org.apache.shardingsphere.core.parse.old.parser.exception.SQLParsingUnsupportedException;
import org.apache.shardingsphere.core.parse.util.SQLUtil;
import org.apache.shardingsphere.core.rule.ShardingRule;

public class TableReferencesClauseParser
implements SQLClauseParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;
    private final AliasExpressionParser aliasExpressionParser;
    private final BasicExpressionParser basicExpressionParser;

    public TableReferencesClauseParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
        this.aliasExpressionParser = ExpressionParserFactory.createAliasExpressionParser(lexerEngine);
        this.basicExpressionParser = ExpressionParserFactory.createBasicExpressionParser(lexerEngine);
    }

    public final void parse(SQLStatement sqlStatement, boolean isSingleTableOnly) {
        do {
            this.parseTableReference(sqlStatement, isSingleTableOnly);
        } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
    }

    protected void parseTableReference(SQLStatement sqlStatement, boolean isSingleTableOnly) {
        this.parseTableFactor(sqlStatement, isSingleTableOnly);
    }

    protected final void parseTableFactor(SQLStatement sqlStatement, boolean isSingleTableOnly) {
        String tableName;
        int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length();
        String literals = this.lexerEngine.getCurrentToken().getLiterals();
        int skippedSchemaNameLength = 0;
        this.lexerEngine.nextToken();
        if (sqlStatement instanceof InsertStatement) {
            sqlStatement.addSQLToken(new InsertValuesToken(this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length()));
        }
        if (this.lexerEngine.skipIfEqual(Symbol.DOT)) {
            skippedSchemaNameLength = literals.length() + Symbol.DOT.getLiterals().length();
            literals = this.lexerEngine.getCurrentToken().getLiterals();
            this.lexerEngine.nextToken();
        }
        if (Strings.isNullOrEmpty((String)(tableName = SQLUtil.getExactlyValue(literals)))) {
            return;
        }
        if (isSingleTableOnly || this.shardingRule.findTableRule(tableName).isPresent() || this.shardingRule.isBroadcastTable(tableName) || this.shardingRule.findBindingTableRule(tableName).isPresent() || this.shardingRule.getShardingDataSourceNames().getDataSourceNames().contains(this.shardingRule.getShardingDataSourceNames().getDefaultDataSourceName())) {
            sqlStatement.addSQLToken(new TableToken(beginPosition, tableName, QuoteCharacter.getQuoteCharacter(literals), skippedSchemaNameLength));
            sqlStatement.getTables().add(new Table(tableName, (String)this.aliasExpressionParser.parseTableAlias(sqlStatement, true, tableName).orNull()));
        } else {
            this.aliasExpressionParser.parseTableAlias();
        }
        this.parseForceIndex(tableName, sqlStatement);
        this.parseJoinTable(sqlStatement);
        if (isSingleTableOnly && !sqlStatement.getTables().isSingleTable()) {
            throw new SQLParsingUnsupportedException("Cannot support Multiple-Table.");
        }
    }

    private void parseForceIndex(String tableName, SQLStatement sqlStatement) {
        boolean skipIfForce;
        boolean bl = skipIfForce = this.lexerEngine.skipIfEqual(MySQLKeyword.FORCE) && this.lexerEngine.skipIfEqual(DefaultKeyword.INDEX);
        if (skipIfForce) {
            this.lexerEngine.accept(Symbol.LEFT_PAREN);
            do {
                this.lexerEngine.skipIfEqual(Symbol.COMMA);
                String literals = this.lexerEngine.getCurrentToken().getLiterals();
                Preconditions.checkState((!Symbol.RIGHT_PAREN.getLiterals().equals(literals) ? 1 : 0) != 0, (Object)"There is an error in the vicinity of the force index syntax.");
                if (literals.equals(this.shardingRule.getTableRule(tableName).getLogicIndex())) {
                    int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - literals.length();
                    sqlStatement.addSQLToken(new IndexToken(beginPosition, this.lexerEngine.getCurrentToken().getEndPosition() - 1, tableName));
                }
                this.lexerEngine.nextToken();
            } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
            this.lexerEngine.accept(Symbol.RIGHT_PAREN);
        }
    }

    private void parseJoinTable(SQLStatement sqlStatement) {
        while (this.parseJoinType()) {
            if (this.lexerEngine.equalAny(Symbol.LEFT_PAREN)) {
                throw new SQLParsingUnsupportedException("Cannot support subquery for join table.");
            }
            this.parseTableFactor(sqlStatement, false);
            this.parseJoinCondition(sqlStatement);
        }
    }

    private boolean parseJoinType() {
        LinkedList<Keyword> joinTypeKeywords = new LinkedList<Keyword>();
        joinTypeKeywords.addAll(Arrays.asList(DefaultKeyword.INNER, DefaultKeyword.OUTER, DefaultKeyword.LEFT, DefaultKeyword.RIGHT, DefaultKeyword.FULL, DefaultKeyword.CROSS, DefaultKeyword.NATURAL, DefaultKeyword.JOIN));
        joinTypeKeywords.addAll(Arrays.asList(this.getKeywordsForJoinType()));
        TokenType[] joinTypeKeywordArrays = joinTypeKeywords.toArray(new Keyword[joinTypeKeywords.size()]);
        if (!this.lexerEngine.equalAny(joinTypeKeywordArrays)) {
            return false;
        }
        this.lexerEngine.skipAll(joinTypeKeywordArrays);
        return true;
    }

    protected Keyword[] getKeywordsForJoinType() {
        return new Keyword[0];
    }

    private void parseJoinCondition(SQLStatement sqlStatement) {
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.ON)) {
            do {
                this.basicExpressionParser.parse(sqlStatement);
                this.lexerEngine.accept(Symbol.EQ);
                this.basicExpressionParser.parse(sqlStatement);
            } while (this.lexerEngine.skipIfEqual(DefaultKeyword.AND));
        } else if (this.lexerEngine.skipIfEqual(DefaultKeyword.USING)) {
            this.lexerEngine.skipParentheses(sqlStatement);
        }
    }

    public final void parseSingleTableWithoutAlias(SQLStatement sqlStatement) {
        int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length();
        String literals = this.lexerEngine.getCurrentToken().getLiterals();
        int skippedSchemaNameLength = 0;
        this.lexerEngine.nextToken();
        if (this.lexerEngine.skipIfEqual(Symbol.DOT)) {
            skippedSchemaNameLength = literals.length() + Symbol.DOT.getLiterals().length();
            literals = this.lexerEngine.getCurrentToken().getLiterals();
            this.lexerEngine.nextToken();
        }
        sqlStatement.addSQLToken(new TableToken(beginPosition, literals, QuoteCharacter.getQuoteCharacter(literals), skippedSchemaNameLength));
        sqlStatement.getTables().add(new Table(SQLUtil.getExactlyValue(literals), null));
    }

    public LexerEngine getLexerEngine() {
        return this.lexerEngine;
    }
}

