/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.clause;

import org.apache.shardingsphere.core.parse.antlr.constant.QuoteCharacter;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.DMLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.token.TableToken;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngine;
import org.apache.shardingsphere.core.parse.old.lexer.token.DefaultKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.Symbol;
import org.apache.shardingsphere.core.parse.old.parser.clause.SQLClauseParser;
import org.apache.shardingsphere.core.parse.old.parser.clause.expression.BasicExpressionParser;
import org.apache.shardingsphere.core.parse.old.parser.dialect.ExpressionParserFactory;
import org.apache.shardingsphere.core.parse.util.SQLUtil;

public final class UpdateSetItemsClauseParser
implements SQLClauseParser {
    private final LexerEngine lexerEngine;
    private final BasicExpressionParser basicExpressionParser;

    public UpdateSetItemsClauseParser(LexerEngine lexerEngine) {
        this.lexerEngine = lexerEngine;
        this.basicExpressionParser = ExpressionParserFactory.createBasicExpressionParser(lexerEngine);
    }

    public void parse(DMLStatement updateStatement) {
        this.lexerEngine.accept(DefaultKeyword.SET);
        do {
            this.parseSetItem(updateStatement);
        } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
    }

    private void parseSetItem(DMLStatement updateStatement) {
        this.parseSetColumn(updateStatement);
        this.lexerEngine.skipIfEqual(Symbol.EQ, Symbol.COLON_EQ);
        this.parseSetValue(updateStatement);
        this.skipsDoubleColon();
    }

    private void parseSetColumn(DMLStatement updateStatement) {
        if (this.lexerEngine.equalAny(Symbol.LEFT_PAREN)) {
            this.lexerEngine.skipParentheses(updateStatement);
            return;
        }
        int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition();
        String literals = this.lexerEngine.getCurrentToken().getLiterals();
        this.lexerEngine.nextToken();
        if (this.lexerEngine.skipIfEqual(Symbol.DOT)) {
            if (updateStatement.getTables().getSingleTableName().equalsIgnoreCase(SQLUtil.getExactlyValue(literals))) {
                updateStatement.addSQLToken(new TableToken(beginPosition - literals.length(), literals, QuoteCharacter.getQuoteCharacter(literals), 0));
            }
            this.lexerEngine.nextToken();
        }
    }

    private void parseSetValue(DMLStatement updateStatement) {
        this.basicExpressionParser.parse(updateStatement);
    }

    private void skipsDoubleColon() {
        if (this.lexerEngine.skipIfEqual(Symbol.DOUBLE_COLON)) {
            this.lexerEngine.nextToken();
        }
    }
}

