/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.clause.expression;

import java.beans.ConstructorProperties;
import org.apache.shardingsphere.core.parse.antlr.constant.QuoteCharacter;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.token.TableToken;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngine;
import org.apache.shardingsphere.core.parse.old.lexer.token.Literals;
import org.apache.shardingsphere.core.parse.old.lexer.token.Symbol;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLIdentifierExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLIgnoreExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLNumberExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLPlaceholderExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLPropertyExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLTextExpression;
import org.apache.shardingsphere.core.parse.util.SQLUtil;
import org.apache.shardingsphere.core.util.NumberUtil;

public final class BasicExpressionParser {
    private final LexerEngine lexerEngine;

    public SQLExpression parse(SQLStatement sqlStatement) {
        int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition();
        SQLExpression result = this.parseExpression(sqlStatement);
        if (result instanceof SQLPropertyExpression) {
            this.setTableToken(sqlStatement, beginPosition, (SQLPropertyExpression)result);
        }
        return result;
    }

    private SQLExpression parseExpression(SQLStatement sqlStatement) {
        String literals = this.lexerEngine.getCurrentToken().getLiterals();
        int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - literals.length();
        SQLExpression expression = this.getExpression(literals, sqlStatement);
        this.lexerEngine.nextToken();
        if (this.lexerEngine.skipIfEqual(Symbol.DOT)) {
            String property = this.lexerEngine.getCurrentToken().getLiterals();
            this.lexerEngine.nextToken();
            return this.skipIfCompositeExpression(sqlStatement) ? new SQLIgnoreExpression(this.lexerEngine.getInput().substring(beginPosition, this.lexerEngine.getCurrentToken().getEndPosition())) : new SQLPropertyExpression(new SQLIdentifierExpression(literals), property);
        }
        if (this.lexerEngine.equalAny(Symbol.LEFT_PAREN)) {
            this.lexerEngine.skipParentheses(sqlStatement);
            this.skipRestCompositeExpression(sqlStatement);
            return new SQLIgnoreExpression(this.lexerEngine.getInput().substring(beginPosition, this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length()).trim());
        }
        return this.skipIfCompositeExpression(sqlStatement) ? new SQLIgnoreExpression(this.lexerEngine.getInput().substring(beginPosition, this.lexerEngine.getCurrentToken().getEndPosition())) : expression;
    }

    private SQLExpression getExpression(String literals, SQLStatement sqlStatement) {
        if (this.lexerEngine.equalAny(Symbol.QUESTION)) {
            sqlStatement.increaseParametersIndex();
            return new SQLPlaceholderExpression(sqlStatement.getParametersIndex() - 1);
        }
        if (this.lexerEngine.equalAny(Literals.CHARS)) {
            return new SQLTextExpression(literals);
        }
        if (this.lexerEngine.equalAny(Literals.INT)) {
            return new SQLNumberExpression(NumberUtil.getExactlyNumber((String)literals, (int)10));
        }
        if (this.lexerEngine.equalAny(Literals.FLOAT)) {
            return new SQLNumberExpression(Double.parseDouble(literals));
        }
        if (this.lexerEngine.equalAny(Literals.HEX)) {
            return new SQLNumberExpression(NumberUtil.getExactlyNumber((String)literals, (int)16));
        }
        if (this.lexerEngine.equalAny(Literals.IDENTIFIER)) {
            return new SQLIdentifierExpression(SQLUtil.getExactlyValue(literals));
        }
        return new SQLIgnoreExpression(literals);
    }

    private boolean skipIfCompositeExpression(SQLStatement sqlStatement) {
        if (this.lexerEngine.equalAny(Symbol.PLUS, Symbol.SUB, Symbol.STAR, Symbol.SLASH, Symbol.PERCENT, Symbol.AMP, Symbol.BAR, Symbol.DOUBLE_AMP, Symbol.DOUBLE_BAR, Symbol.CARET, Symbol.DOT, Symbol.LEFT_PAREN)) {
            this.lexerEngine.skipParentheses(sqlStatement);
            this.skipRestCompositeExpression(sqlStatement);
            return true;
        }
        if ((Literals.INT == this.lexerEngine.getCurrentToken().getType() || Literals.FLOAT == this.lexerEngine.getCurrentToken().getType()) && this.lexerEngine.getCurrentToken().getLiterals().startsWith("-")) {
            this.lexerEngine.nextToken();
            return true;
        }
        return false;
    }

    private void skipRestCompositeExpression(SQLStatement sqlStatement) {
        while (this.lexerEngine.skipIfEqual(Symbol.PLUS, Symbol.SUB, Symbol.STAR, Symbol.SLASH, Symbol.PERCENT, Symbol.AMP, Symbol.BAR, Symbol.DOUBLE_AMP, Symbol.DOUBLE_BAR, Symbol.CARET, Symbol.DOT)) {
            if (this.lexerEngine.equalAny(Symbol.QUESTION)) {
                sqlStatement.increaseParametersIndex();
            }
            this.lexerEngine.nextToken();
            this.lexerEngine.skipParentheses(sqlStatement);
        }
    }

    private void setTableToken(SQLStatement sqlStatement, int beginPosition, SQLPropertyExpression propertyExpr) {
        String owner = propertyExpr.getOwner().getName();
        if (sqlStatement.getTables().getTableNames().contains(SQLUtil.getExactlyValue(propertyExpr.getOwner().getName()))) {
            sqlStatement.addSQLToken(new TableToken(beginPosition - owner.length(), owner, QuoteCharacter.getQuoteCharacter(owner), 0));
        }
    }

    @ConstructorProperties(value={"lexerEngine"})
    public BasicExpressionParser(LexerEngine lexerEngine) {
        this.lexerEngine = lexerEngine;
    }
}

