/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.context.condition;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.core.parse.old.parser.clause.condition.NullCondition;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.Column;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.Condition;

public final class AndCondition {
    private final List<Condition> conditions = new LinkedList<Condition>();

    public Map<Column, List<Condition>> getConditionsMap() {
        LinkedHashMap<Column, List<Condition>> result = new LinkedHashMap<Column, List<Condition>>(this.conditions.size(), 1.0f);
        for (Condition each : this.conditions) {
            if (!result.containsKey(each.getColumn())) {
                result.put(each.getColumn(), new LinkedList());
            }
            ((List)result.get(each.getColumn())).add(each);
        }
        return result;
    }

    public AndCondition optimize() {
        AndCondition result = new AndCondition();
        for (Condition each : this.conditions) {
            if (!Condition.class.equals(each.getClass())) continue;
            result.getConditions().add(each);
        }
        if (result.getConditions().isEmpty()) {
            result.getConditions().add(new NullCondition());
        }
        return result;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public String toString() {
        return "AndCondition(conditions=" + this.getConditions() + ")";
    }
}

