/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.context.condition;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.core.parse.old.parser.clause.condition.NullCondition;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.AndCondition;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.Column;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.Condition;

public final class OrCondition {
    private final List<AndCondition> andConditions = new ArrayList<AndCondition>();

    public OrCondition(Condition condition) {
        this.add(condition);
    }

    public void add(Condition condition) {
        if (this.andConditions.isEmpty()) {
            this.andConditions.add(new AndCondition());
        }
        this.andConditions.get(0).getConditions().add(condition);
    }

    public OrCondition optimize() {
        for (AndCondition each : this.andConditions) {
            if (!(each.getConditions().get(0) instanceof NullCondition)) continue;
            OrCondition result = new OrCondition();
            result.add(new NullCondition());
            return result;
        }
        return this;
    }

    public List<Condition> findConditions(final Column column) {
        LinkedList<Condition> result = new LinkedList<Condition>();
        for (AndCondition each : this.andConditions) {
            result.addAll(Collections2.filter(each.getConditions(), (Predicate)new Predicate<Condition>(){

                public boolean apply(Condition input) {
                    return input.getColumn().equals(column);
                }
            }));
        }
        return result;
    }

    public OrCondition() {
    }

    public List<AndCondition> getAndConditions() {
        return this.andConditions;
    }

    public String toString() {
        return "OrCondition(andConditions=" + this.getAndConditions() + ")";
    }
}

