/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.context.selectitem;

import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import org.apache.shardingsphere.core.constant.AggregationType;
import org.apache.shardingsphere.core.parse.old.parser.context.selectitem.SelectItem;
import org.apache.shardingsphere.core.parse.util.SQLUtil;

public class AggregationSelectItem
implements SelectItem {
    private final AggregationType type;
    private final String innerExpression;
    private final Optional<String> alias;
    private final List<AggregationSelectItem> derivedAggregationSelectItems = new ArrayList<AggregationSelectItem>(2);
    private int index = -1;

    @Override
    public String getExpression() {
        return SQLUtil.getExactlyValue(this.type.name() + this.innerExpression);
    }

    public String getColumnLabel() {
        return this.alias.isPresent() ? (String)this.alias.get() : this.getExpression();
    }

    @ConstructorProperties(value={"type", "innerExpression", "alias"})
    public AggregationSelectItem(AggregationType type, String innerExpression, Optional<String> alias) {
        this.type = type;
        this.innerExpression = innerExpression;
        this.alias = alias;
    }

    public AggregationType getType() {
        return this.type;
    }

    public String getInnerExpression() {
        return this.innerExpression;
    }

    @Override
    public Optional<String> getAlias() {
        return this.alias;
    }

    public List<AggregationSelectItem> getDerivedAggregationSelectItems() {
        return this.derivedAggregationSelectItems;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AggregationSelectItem)) {
            return false;
        }
        AggregationSelectItem other = (AggregationSelectItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AggregationType this$type = this.getType();
        AggregationType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$innerExpression = this.getInnerExpression();
        String other$innerExpression = other.getInnerExpression();
        if (this$innerExpression == null ? other$innerExpression != null : !this$innerExpression.equals(other$innerExpression)) {
            return false;
        }
        Optional<String> this$alias = this.getAlias();
        Optional<String> other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        List<AggregationSelectItem> this$derivedAggregationSelectItems = this.getDerivedAggregationSelectItems();
        List<AggregationSelectItem> other$derivedAggregationSelectItems = other.getDerivedAggregationSelectItems();
        if (this$derivedAggregationSelectItems == null ? other$derivedAggregationSelectItems != null : !((Object)this$derivedAggregationSelectItems).equals(other$derivedAggregationSelectItems)) {
            return false;
        }
        return this.getIndex() == other.getIndex();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AggregationSelectItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AggregationType $type = this.getType();
        result = result * 59 + ($type == null ? 0 : $type.hashCode());
        String $innerExpression = this.getInnerExpression();
        result = result * 59 + ($innerExpression == null ? 0 : $innerExpression.hashCode());
        Optional<String> $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 0 : $alias.hashCode());
        List<AggregationSelectItem> $derivedAggregationSelectItems = this.getDerivedAggregationSelectItems();
        result = result * 59 + ($derivedAggregationSelectItems == null ? 0 : ((Object)$derivedAggregationSelectItems).hashCode());
        result = result * 59 + this.getIndex();
        return result;
    }

    public String toString() {
        return "AggregationSelectItem(type=" + this.getType() + ", innerExpression=" + this.getInnerExpression() + ", alias=" + this.getAlias() + ", derivedAggregationSelectItems=" + this.getDerivedAggregationSelectItems() + ", index=" + this.getIndex() + ")";
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

