/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.context.selectitem;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.shardingsphere.core.parse.old.lexer.token.DefaultKeyword;
import org.apache.shardingsphere.core.parse.old.parser.context.selectitem.SelectItem;
import org.apache.shardingsphere.core.parse.util.SQLUtil;

public final class DistinctSelectItem
implements SelectItem {
    private final Set<String> distinctColumnNames;
    private final Optional<String> alias;

    @Override
    public String getExpression() {
        return this.isSingleColumnWithAlias() ? SQLUtil.getExactlyValue(DefaultKeyword.DISTINCT.name() + " " + this.distinctColumnNames.iterator().next() + "AS" + (String)this.alias.get()) : SQLUtil.getExactlyValue(DefaultKeyword.DISTINCT + " " + Joiner.on((String)", ").join(this.distinctColumnNames));
    }

    public Collection<String> getDistinctColumnLabels() {
        return this.isSingleColumnWithAlias() ? Collections.singletonList(this.alias.get()) : this.distinctColumnNames;
    }

    private boolean isSingleColumnWithAlias() {
        return 1 == this.distinctColumnNames.size() && this.alias.isPresent();
    }

    @ConstructorProperties(value={"distinctColumnNames", "alias"})
    public DistinctSelectItem(Set<String> distinctColumnNames, Optional<String> alias) {
        this.distinctColumnNames = distinctColumnNames;
        this.alias = alias;
    }

    public Set<String> getDistinctColumnNames() {
        return this.distinctColumnNames;
    }

    @Override
    public Optional<String> getAlias() {
        return this.alias;
    }
}

