/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.context.table;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import org.apache.shardingsphere.core.parse.old.parser.context.table.Table;

public final class Tables {
    private final List<Table> tables = new ArrayList<Table>();

    public void add(Table table) {
        this.tables.add(table);
    }

    public boolean isEmpty() {
        return this.tables.isEmpty();
    }

    public boolean isSameTable() {
        TreeSet<String> tableNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (Table each : this.tables) {
            tableNames.add(each.getName());
        }
        return 1 == tableNames.size();
    }

    public boolean isSingleTable() {
        return 1 == this.tables.size();
    }

    public String getSingleTableName() {
        Preconditions.checkArgument((!this.isEmpty() ? 1 : 0) != 0);
        return this.tables.get(0).getName();
    }

    public Collection<String> getTableNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.tables.size(), 1.0f);
        for (Table each : this.tables) {
            result.add(each.getName());
        }
        return result;
    }

    public Optional<Table> find(String tableNameOrAlias) {
        Optional<Table> tableFromName = this.findTableFromName(tableNameOrAlias);
        return tableFromName.isPresent() ? tableFromName : this.findTableFromAlias(tableNameOrAlias);
    }

    private Optional<Table> findTableFromName(String name) {
        for (Table each : this.tables) {
            if (!each.getName().equals(name)) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    private Optional<Table> findTableFromAlias(String alias) {
        for (Table each : this.tables) {
            if (!each.getAlias().isPresent() || !((String)each.getAlias().get()).equalsIgnoreCase(alias)) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    public String toString() {
        return "Tables(tables=" + this.tables + ")";
    }
}

