/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.dialect;

import org.apache.shardingsphere.core.parse.old.lexer.LexerEngine;
import org.apache.shardingsphere.core.parse.old.parser.clause.expression.AliasExpressionParser;
import org.apache.shardingsphere.core.parse.old.parser.clause.expression.BasicExpressionParser;
import org.apache.shardingsphere.core.parse.old.parser.dialect.mysql.clause.expression.MySQLAliasExpressionParser;
import org.apache.shardingsphere.core.parse.old.parser.dialect.oracle.clause.expression.OracleAliasExpressionParser;
import org.apache.shardingsphere.core.parse.old.parser.dialect.postgresql.clause.expression.PostgreSQLAliasExpressionParser;
import org.apache.shardingsphere.core.parse.old.parser.dialect.sqlserver.clause.expression.SQLServerAliasExpressionParser;

public final class ExpressionParserFactory {
    public static AliasExpressionParser createAliasExpressionParser(LexerEngine lexerEngine) {
        switch (lexerEngine.getDatabaseType()) {
            case H2: {
                return new MySQLAliasExpressionParser(lexerEngine);
            }
            case MySQL: {
                return new MySQLAliasExpressionParser(lexerEngine);
            }
            case Oracle: {
                return new OracleAliasExpressionParser(lexerEngine);
            }
            case SQLServer: {
                return new SQLServerAliasExpressionParser(lexerEngine);
            }
            case PostgreSQL: {
                return new PostgreSQLAliasExpressionParser(lexerEngine);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database type: %s", lexerEngine.getDatabaseType()));
    }

    public static BasicExpressionParser createBasicExpressionParser(LexerEngine lexerEngine) {
        return new BasicExpressionParser(lexerEngine);
    }

    private ExpressionParserFactory() {
    }
}

