/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.dialect.mysql.clause;

import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngine;
import org.apache.shardingsphere.core.parse.old.lexer.dialect.mysql.MySQLKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.DefaultKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.Keyword;
import org.apache.shardingsphere.core.parse.old.parser.clause.TableReferencesClauseParser;
import org.apache.shardingsphere.core.rule.ShardingRule;

public final class MySQLTableReferencesClauseParser
extends TableReferencesClauseParser {
    public MySQLTableReferencesClauseParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        super(shardingRule, lexerEngine);
    }

    @Override
    protected void parseTableReference(SQLStatement sqlStatement, boolean isSingleTableOnly) {
        this.parseTableFactor(sqlStatement, isSingleTableOnly);
        this.parsePartition();
        this.parseIndexHint(sqlStatement);
    }

    private void parsePartition() {
        this.getLexerEngine().unsupportedIfEqual(MySQLKeyword.PARTITION);
    }

    private void parseIndexHint(SQLStatement sqlStatement) {
        if (this.getLexerEngine().skipIfEqual(DefaultKeyword.USE, MySQLKeyword.IGNORE, MySQLKeyword.FORCE)) {
            this.getLexerEngine().skipAll(DefaultKeyword.INDEX, DefaultKeyword.KEY, DefaultKeyword.FOR, DefaultKeyword.JOIN, DefaultKeyword.ORDER, DefaultKeyword.GROUP, DefaultKeyword.BY);
            this.getLexerEngine().skipParentheses(sqlStatement);
        }
    }

    @Override
    protected Keyword[] getKeywordsForJoinType() {
        return new Keyword[]{MySQLKeyword.STRAIGHT_JOIN};
    }
}

