/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.dialect.mysql.sql;

import java.beans.ConstructorProperties;
import org.apache.shardingsphere.core.parse.antlr.constant.QuoteCharacter;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dal.DALStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.token.RemoveToken;
import org.apache.shardingsphere.core.parse.antlr.sql.token.SchemaToken;
import org.apache.shardingsphere.core.parse.antlr.sql.token.TableToken;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngine;
import org.apache.shardingsphere.core.parse.old.lexer.dialect.mysql.MySQLKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.DefaultKeyword;
import org.apache.shardingsphere.core.parse.old.parser.clause.TableReferencesClauseParser;
import org.apache.shardingsphere.core.parse.old.parser.context.table.Table;
import org.apache.shardingsphere.core.parse.old.parser.dialect.mysql.statement.ShowColumnsStatement;
import org.apache.shardingsphere.core.parse.old.parser.dialect.mysql.statement.ShowCreateTableStatement;
import org.apache.shardingsphere.core.parse.old.parser.dialect.mysql.statement.ShowDatabasesStatement;
import org.apache.shardingsphere.core.parse.old.parser.dialect.mysql.statement.ShowIndexStatement;
import org.apache.shardingsphere.core.parse.old.parser.dialect.mysql.statement.ShowOtherStatement;
import org.apache.shardingsphere.core.parse.old.parser.dialect.mysql.statement.ShowTableStatusStatement;
import org.apache.shardingsphere.core.parse.old.parser.dialect.mysql.statement.ShowTablesStatement;
import org.apache.shardingsphere.core.parse.old.parser.sql.dal.show.AbstractShowParser;
import org.apache.shardingsphere.core.parse.util.SQLUtil;
import org.apache.shardingsphere.core.rule.ShardingRule;

public final class MySQLShowParser
extends AbstractShowParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;
    private final TableReferencesClauseParser tableReferencesClauseParser;

    public MySQLShowParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
        this.tableReferencesClauseParser = new TableReferencesClauseParser(shardingRule, lexerEngine);
    }

    @Override
    public DALStatement parse() {
        this.lexerEngine.nextToken();
        this.lexerEngine.skipIfEqual(DefaultKeyword.FULL);
        if (this.lexerEngine.equalAny(MySQLKeyword.DATABASES)) {
            return this.showDatabases();
        }
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.TABLE, MySQLKeyword.STATUS)) {
            return this.parseShowTableStatus();
        }
        if (this.lexerEngine.skipIfEqual(MySQLKeyword.TABLES)) {
            return this.parseShowTables();
        }
        if (this.lexerEngine.skipIfEqual(MySQLKeyword.COLUMNS, MySQLKeyword.FIELDS)) {
            return this.parseShowColumnsFields();
        }
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.CREATE) && this.lexerEngine.skipIfEqual(DefaultKeyword.TABLE)) {
            return this.parseShowCreateTable();
        }
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.INDEX, MySQLKeyword.INDEXES, MySQLKeyword.KEYS)) {
            return this.parseShowIndex();
        }
        return new ShowOtherStatement();
    }

    private DALStatement showDatabases() {
        return new ShowDatabasesStatement();
    }

    private DALStatement parseShowTableStatus() {
        ShowTableStatusStatement result = new ShowTableStatusStatement();
        this.lexerEngine.nextToken();
        if (this.lexerEngine.equalAny(DefaultKeyword.FROM, DefaultKeyword.IN)) {
            int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length();
            this.lexerEngine.nextToken();
            result.addSQLToken(new RemoveToken(beginPosition, this.lexerEngine.getCurrentToken().getEndPosition()));
            this.lexerEngine.nextToken();
        }
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.LIKE)) {
            this.parseLike(result);
        }
        return result;
    }

    private DALStatement parseShowTables() {
        ShowTablesStatement result = new ShowTablesStatement();
        if (this.lexerEngine.equalAny(DefaultKeyword.FROM, DefaultKeyword.IN)) {
            int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length();
            this.lexerEngine.nextToken();
            result.addSQLToken(new RemoveToken(beginPosition, this.lexerEngine.getCurrentToken().getEndPosition()));
            this.lexerEngine.nextToken();
        }
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.LIKE)) {
            this.parseLike(result);
        }
        return result;
    }

    private DALStatement parseShowColumnsFields() {
        ShowColumnsStatement result = new ShowColumnsStatement();
        this.lexerEngine.skipIfEqual(DefaultKeyword.FROM, DefaultKeyword.IN);
        this.tableReferencesClauseParser.parseSingleTableWithoutAlias(result);
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.FROM, DefaultKeyword.IN)) {
            int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length();
            result.addSQLToken(new SchemaToken(beginPosition, this.lexerEngine.getCurrentToken().getEndPosition() - 1, result.getTables().getSingleTableName()));
        }
        return result;
    }

    private DALStatement parseShowCreateTable() {
        ShowCreateTableStatement result = new ShowCreateTableStatement();
        this.tableReferencesClauseParser.parseSingleTableWithoutAlias(result);
        return result;
    }

    private DALStatement parseShowIndex() {
        ShowIndexStatement result = new ShowIndexStatement();
        this.lexerEngine.skipIfEqual(DefaultKeyword.FROM, DefaultKeyword.IN);
        this.tableReferencesClauseParser.parseSingleTableWithoutAlias(result);
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.FROM, DefaultKeyword.IN)) {
            int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length();
            result.addSQLToken(new SchemaToken(beginPosition, this.lexerEngine.getCurrentToken().getEndPosition() - 1, result.getTables().getSingleTableName()));
        }
        return result;
    }

    private void parseLike(DALStatement dalStatement) {
        int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length() - 1;
        String literals = this.lexerEngine.getCurrentToken().getLiterals();
        if (this.shardingRule.findTableRule(literals).isPresent() || this.shardingRule.isBroadcastTable(literals)) {
            dalStatement.addSQLToken(new TableToken(beginPosition, literals, QuoteCharacter.getQuoteCharacter(literals), 0));
            dalStatement.getTables().add(new Table(SQLUtil.getExactlyValue(literals), null));
        }
    }

    @ConstructorProperties(value={"shardingRule", "lexerEngine", "tableReferencesClauseParser"})
    public MySQLShowParser(ShardingRule shardingRule, LexerEngine lexerEngine, TableReferencesClauseParser tableReferencesClauseParser) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
        this.tableReferencesClauseParser = tableReferencesClauseParser;
    }
}

