/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.dialect.oracle.clause;

import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.SelectStatement;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngine;
import org.apache.shardingsphere.core.parse.old.lexer.dialect.oracle.OracleKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.DefaultKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.Symbol;
import org.apache.shardingsphere.core.parse.old.parser.clause.SQLClauseParser;
import org.apache.shardingsphere.core.parse.old.parser.clause.expression.BasicExpressionParser;
import org.apache.shardingsphere.core.parse.old.parser.dialect.ExpressionParserFactory;

public final class OracleForClauseParser
implements SQLClauseParser {
    private final LexerEngine lexerEngine;
    private final BasicExpressionParser basicExpressionParser;

    public OracleForClauseParser(LexerEngine lexerEngine) {
        this.lexerEngine = lexerEngine;
        this.basicExpressionParser = ExpressionParserFactory.createBasicExpressionParser(lexerEngine);
    }

    public void parse(SelectStatement selectStatement) {
        if (!this.lexerEngine.skipIfEqual(DefaultKeyword.FOR)) {
            return;
        }
        this.lexerEngine.accept(DefaultKeyword.UPDATE);
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.OF)) {
            do {
                this.basicExpressionParser.parse(selectStatement);
            } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
        }
        if (this.lexerEngine.equalAny(OracleKeyword.NOWAIT, OracleKeyword.WAIT)) {
            this.lexerEngine.nextToken();
        } else if (this.lexerEngine.skipIfEqual(OracleKeyword.SKIP)) {
            this.lexerEngine.accept(OracleKeyword.LOCKED);
        }
    }
}

