/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.dialect.oracle.sql;

import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.SelectStatement;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngine;
import org.apache.shardingsphere.core.parse.old.parser.dialect.oracle.clause.OracleForClauseParser;
import org.apache.shardingsphere.core.parse.old.parser.dialect.oracle.clause.OracleHierarchicalQueryClauseParser;
import org.apache.shardingsphere.core.parse.old.parser.dialect.oracle.clause.OracleModelClauseParser;
import org.apache.shardingsphere.core.parse.old.parser.dialect.oracle.clause.facade.OracleSelectClauseParserFacade;
import org.apache.shardingsphere.core.parse.old.parser.sql.dml.select.AbstractSelectParser;
import org.apache.shardingsphere.core.rule.ShardingRule;

public final class OracleSelectParser
extends AbstractSelectParser {
    private final OracleHierarchicalQueryClauseParser hierarchicalQueryClauseParser;
    private final OracleModelClauseParser modelClauseParser;
    private final OracleForClauseParser forClauseParser;

    public OracleSelectParser(ShardingRule shardingRule, LexerEngine lexerEngine, ShardingTableMetaData shardingTableMetaData) {
        super(shardingRule, lexerEngine, new OracleSelectClauseParserFacade(shardingRule, lexerEngine), shardingTableMetaData);
        this.hierarchicalQueryClauseParser = new OracleHierarchicalQueryClauseParser(lexerEngine);
        this.modelClauseParser = new OracleModelClauseParser(lexerEngine);
        this.forClauseParser = new OracleForClauseParser(lexerEngine);
    }

    @Override
    protected void parseInternal(SelectStatement selectStatement) {
        this.parseSelectList(selectStatement, this.getItems());
        this.parseFrom(selectStatement);
        this.parseWhere(this.getShardingRule(), selectStatement, this.getItems());
        this.parseHierarchicalQueryClause();
        this.parseGroupBy(selectStatement);
        this.parseHaving();
        this.parseModelClause();
        this.parseOrderBy(selectStatement);
        this.parseFor(selectStatement);
        this.parseSelectRest();
    }

    private void parseHierarchicalQueryClause() {
        this.hierarchicalQueryClauseParser.parse();
    }

    private void parseModelClause() {
        this.modelClauseParser.parse();
    }

    private void parseFor(SelectStatement selectStatement) {
        this.forClauseParser.parse(selectStatement);
    }
}

