/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.dialect.sqlserver.clause;

import java.beans.ConstructorProperties;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.SelectStatement;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngine;
import org.apache.shardingsphere.core.parse.old.lexer.dialect.sqlserver.SQLServerKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.DefaultKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.Literals;
import org.apache.shardingsphere.core.parse.old.lexer.token.Symbol;
import org.apache.shardingsphere.core.parse.old.parser.clause.SQLClauseParser;
import org.apache.shardingsphere.core.parse.old.parser.context.limit.Limit;
import org.apache.shardingsphere.core.parse.old.parser.context.limit.LimitValue;
import org.apache.shardingsphere.core.parse.old.parser.exception.SQLParsingException;

public final class SQLServerOffsetClauseParser
implements SQLClauseParser {
    private final LexerEngine lexerEngine;

    public void parse(SelectStatement selectStatement) {
        if (!this.lexerEngine.skipIfEqual(SQLServerKeyword.OFFSET)) {
            return;
        }
        int offsetValue = -1;
        int offsetIndex = -1;
        if (this.lexerEngine.equalAny(Literals.INT)) {
            offsetValue = Integer.parseInt(this.lexerEngine.getCurrentToken().getLiterals());
        } else if (this.lexerEngine.equalAny(Symbol.QUESTION)) {
            offsetIndex = selectStatement.getParametersIndex();
            selectStatement.increaseParametersIndex();
        } else {
            throw new SQLParsingException(this.lexerEngine);
        }
        this.lexerEngine.nextToken();
        Limit limit = new Limit();
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.FETCH)) {
            this.lexerEngine.nextToken();
            int rowCountValue = -1;
            int rowCountIndex = -1;
            this.lexerEngine.nextToken();
            if (this.lexerEngine.equalAny(Literals.INT)) {
                rowCountValue = Integer.parseInt(this.lexerEngine.getCurrentToken().getLiterals());
            } else if (this.lexerEngine.equalAny(Symbol.QUESTION)) {
                rowCountIndex = selectStatement.getParametersIndex();
                selectStatement.increaseParametersIndex();
            } else {
                throw new SQLParsingException(this.lexerEngine);
            }
            this.lexerEngine.nextToken();
            this.lexerEngine.nextToken();
            limit.setRowCount(new LimitValue(rowCountValue, rowCountIndex, false));
            limit.setOffset(new LimitValue(offsetValue, offsetIndex, true));
        } else {
            limit.setOffset(new LimitValue(offsetValue, offsetIndex, true));
        }
        selectStatement.setLimit(limit);
    }

    @ConstructorProperties(value={"lexerEngine"})
    public SQLServerOffsetClauseParser(LexerEngine lexerEngine) {
        this.lexerEngine = lexerEngine;
    }
}

