/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.dialect.sqlserver.clause;

import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.SelectStatement;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngine;
import org.apache.shardingsphere.core.parse.old.lexer.dialect.sqlserver.SQLServerKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.DefaultKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.Keyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.Symbol;
import org.apache.shardingsphere.core.parse.old.parser.clause.OrderByClauseParser;
import org.apache.shardingsphere.core.parse.old.parser.clause.SelectListClauseParser;
import org.apache.shardingsphere.core.parse.old.parser.context.selectitem.CommonSelectItem;
import org.apache.shardingsphere.core.parse.old.parser.context.selectitem.SelectItem;
import org.apache.shardingsphere.core.parse.old.parser.dialect.sqlserver.clause.SQLServerOrderByClauseParser;
import org.apache.shardingsphere.core.rule.ShardingRule;

public final class SQLServerSelectListClauseParser
extends SelectListClauseParser {
    private final OrderByClauseParser orderByClauseParser;

    public SQLServerSelectListClauseParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        super(shardingRule, lexerEngine);
        this.orderByClauseParser = new SQLServerOrderByClauseParser(lexerEngine);
    }

    @Override
    protected Keyword[] getSkippedKeywordsBeforeSelectItem() {
        return new Keyword[0];
    }

    @Override
    protected boolean isRowNumberSelectItem() {
        return this.getLexerEngine().skipIfEqual(SQLServerKeyword.ROW_NUMBER);
    }

    @Override
    protected SelectItem parseRowNumberSelectItem(SelectStatement selectStatement) {
        this.getLexerEngine().skipParentheses(selectStatement);
        this.getLexerEngine().accept(DefaultKeyword.OVER);
        this.getLexerEngine().accept(Symbol.LEFT_PAREN);
        this.getLexerEngine().unsupportedIfEqual(SQLServerKeyword.PARTITION);
        this.orderByClauseParser.parse(selectStatement);
        this.getLexerEngine().accept(Symbol.RIGHT_PAREN);
        return new CommonSelectItem(SQLServerKeyword.ROW_NUMBER.name(), this.getAliasExpressionParser().parseSelectItemAlias());
    }
}

