/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.dialect.sqlserver.clause;

import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngine;
import org.apache.shardingsphere.core.parse.old.lexer.dialect.sqlserver.SQLServerKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.DefaultKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.Keyword;
import org.apache.shardingsphere.core.parse.old.parser.clause.TableReferencesClauseParser;
import org.apache.shardingsphere.core.rule.ShardingRule;

public final class SQLServerTableReferencesClauseParser
extends TableReferencesClauseParser {
    public SQLServerTableReferencesClauseParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        super(shardingRule, lexerEngine);
    }

    @Override
    protected void parseTableReference(SQLStatement sqlStatement, boolean isSingleTableOnly) {
        this.parseTableFactor(sqlStatement, isSingleTableOnly);
        this.parseTableSampleClause();
        this.parseTableHint(sqlStatement);
    }

    private void parseTableSampleClause() {
        this.getLexerEngine().unsupportedIfEqual(SQLServerKeyword.TABLESAMPLE);
    }

    private void parseTableHint(SQLStatement sqlStatement) {
        if (this.getLexerEngine().skipIfEqual(DefaultKeyword.WITH)) {
            this.getLexerEngine().skipParentheses(sqlStatement);
        }
    }

    @Override
    protected Keyword[] getKeywordsForJoinType() {
        return new Keyword[]{SQLServerKeyword.APPLY, SQLServerKeyword.REDUCE, SQLServerKeyword.REPLICATE, SQLServerKeyword.REDISTRIBUTE};
    }
}

