/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.sql;

import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.parse.antlr.AntlrParsingEngine;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dal.DALStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dcl.DCLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.ddl.DDLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.DMLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.DQLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.tcl.TCLStatement;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngine;
import org.apache.shardingsphere.core.parse.old.lexer.dialect.mysql.MySQLKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.dialect.postgresql.PostgreSQLKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.DefaultKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.Keyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.TokenType;
import org.apache.shardingsphere.core.parse.old.parser.exception.SQLParsingUnsupportedException;
import org.apache.shardingsphere.core.parse.old.parser.sql.SQLParser;
import org.apache.shardingsphere.core.parse.old.parser.sql.dal.describe.DescribeParserFactory;
import org.apache.shardingsphere.core.parse.old.parser.sql.dal.set.SetParserFactory;
import org.apache.shardingsphere.core.parse.old.parser.sql.dal.show.ShowParserFactory;
import org.apache.shardingsphere.core.parse.old.parser.sql.dal.use.UseParserFactory;
import org.apache.shardingsphere.core.parse.old.parser.sql.dml.delete.DeleteParserFactory;
import org.apache.shardingsphere.core.parse.old.parser.sql.dml.insert.InsertParserFactory;
import org.apache.shardingsphere.core.parse.old.parser.sql.dml.select.SelectParserFactory;
import org.apache.shardingsphere.core.parse.old.parser.sql.dml.update.UpdateParserFactory;
import org.apache.shardingsphere.core.rule.BaseRule;
import org.apache.shardingsphere.core.rule.EncryptRule;
import org.apache.shardingsphere.core.rule.ShardingRule;

public final class SQLParserFactory {
    public static SQLParser newInstance(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine, ShardingTableMetaData shardingTableMetaData, String sql) {
        lexerEngine.nextToken();
        TokenType tokenType = lexerEngine.getCurrentToken().getType();
        if (DQLStatement.isDQL(tokenType)) {
            if (DatabaseType.MySQL == dbType || DatabaseType.H2 == dbType) {
                return new AntlrParsingEngine(dbType, sql, (BaseRule)shardingRule, shardingTableMetaData);
            }
            return SQLParserFactory.getDQLParser(dbType, shardingRule, lexerEngine, shardingTableMetaData);
        }
        if (DMLStatement.isDML(tokenType)) {
            if (DatabaseType.MySQL == dbType || DatabaseType.H2 == dbType) {
                return new AntlrParsingEngine(dbType, sql, (BaseRule)shardingRule, shardingTableMetaData);
            }
            return SQLParserFactory.getDMLParser(dbType, tokenType, shardingRule, lexerEngine, shardingTableMetaData);
        }
        if (MySQLKeyword.REPLACE == tokenType && (DatabaseType.MySQL == dbType || DatabaseType.H2 == dbType)) {
            return new AntlrParsingEngine(dbType, sql, (BaseRule)shardingRule, shardingTableMetaData);
        }
        if (TCLStatement.isTCL(tokenType)) {
            return new AntlrParsingEngine(dbType, sql, (BaseRule)shardingRule, shardingTableMetaData);
        }
        if (DALStatement.isDAL(tokenType)) {
            if (DatabaseType.PostgreSQL == dbType && PostgreSQLKeyword.SHOW == tokenType) {
                return new AntlrParsingEngine(dbType, sql, (BaseRule)shardingRule, shardingTableMetaData);
            }
            return SQLParserFactory.getDALParser(dbType, (Keyword)tokenType, shardingRule, lexerEngine);
        }
        lexerEngine.nextToken();
        TokenType secondaryTokenType = lexerEngine.getCurrentToken().getType();
        if (DCLStatement.isDCL(tokenType, secondaryTokenType)) {
            return new AntlrParsingEngine(dbType, sql, (BaseRule)shardingRule, shardingTableMetaData);
        }
        if (DDLStatement.isDDL(tokenType, secondaryTokenType)) {
            return new AntlrParsingEngine(dbType, sql, (BaseRule)shardingRule, shardingTableMetaData);
        }
        if (TCLStatement.isTCLUnsafe(dbType, tokenType, lexerEngine)) {
            return new AntlrParsingEngine(dbType, sql, (BaseRule)shardingRule, shardingTableMetaData);
        }
        if (DefaultKeyword.SET.equals(tokenType)) {
            return SetParserFactory.newInstance();
        }
        throw new SQLParsingUnsupportedException(tokenType);
    }

    public static SQLParser newInstance(DatabaseType dbType, EncryptRule encryptRule, ShardingTableMetaData shardingTableMetaData, String sql) {
        if (DatabaseType.MySQL == dbType || DatabaseType.H2 == dbType) {
            return new AntlrParsingEngine(dbType, sql, (BaseRule)encryptRule, shardingTableMetaData);
        }
        throw new SQLParsingUnsupportedException(String.format("Can not support %s", dbType));
    }

    private static SQLParser getDQLParser(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine, ShardingTableMetaData shardingTableMetaData) {
        return SelectParserFactory.newInstance(dbType, shardingRule, lexerEngine, shardingTableMetaData);
    }

    private static SQLParser getDMLParser(DatabaseType dbType, TokenType tokenType, ShardingRule shardingRule, LexerEngine lexerEngine, ShardingTableMetaData shardingTableMetaData) {
        switch ((DefaultKeyword)tokenType) {
            case INSERT: {
                return InsertParserFactory.newInstance(dbType, shardingRule, lexerEngine, shardingTableMetaData);
            }
            case UPDATE: {
                return UpdateParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
            case DELETE: {
                return DeleteParserFactory.newInstance(dbType, shardingRule, lexerEngine);
            }
        }
        throw new SQLParsingUnsupportedException(tokenType);
    }

    private static SQLParser getDALParser(DatabaseType dbType, Keyword tokenType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        if (DefaultKeyword.USE == tokenType) {
            return UseParserFactory.newInstance(dbType, shardingRule, lexerEngine);
        }
        if (DefaultKeyword.DESC == tokenType || MySQLKeyword.DESCRIBE == tokenType) {
            return DescribeParserFactory.newInstance(dbType, shardingRule, lexerEngine);
        }
        if (MySQLKeyword.SHOW == tokenType) {
            return ShowParserFactory.newInstance(dbType, shardingRule, lexerEngine);
        }
        throw new SQLParsingUnsupportedException(tokenType);
    }

    private SQLParserFactory() {
    }
}

