/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.sql.dml.delete;

import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngine;
import org.apache.shardingsphere.core.parse.old.parser.dialect.mysql.sql.MySQLDeleteParser;
import org.apache.shardingsphere.core.parse.old.parser.dialect.oracle.sql.OracleDeleteParser;
import org.apache.shardingsphere.core.parse.old.parser.dialect.postgresql.sql.PostgreSQLDeleteParser;
import org.apache.shardingsphere.core.parse.old.parser.dialect.sqlserver.sql.SQLServerDeleteParser;
import org.apache.shardingsphere.core.parse.old.parser.sql.dml.delete.AbstractDeleteParser;
import org.apache.shardingsphere.core.rule.ShardingRule;

public final class DeleteParserFactory {
    public static AbstractDeleteParser newInstance(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        switch (dbType) {
            case H2: 
            case MySQL: {
                return new MySQLDeleteParser(shardingRule, lexerEngine);
            }
            case Oracle: {
                return new OracleDeleteParser(shardingRule, lexerEngine);
            }
            case SQLServer: {
                return new SQLServerDeleteParser(shardingRule, lexerEngine);
            }
            case PostgreSQL: {
                return new PostgreSQLDeleteParser(shardingRule, lexerEngine);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", dbType));
    }

    private DeleteParserFactory() {
    }
}

