/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.sql.dml.insert;

import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngine;
import org.apache.shardingsphere.core.parse.old.parser.dialect.mysql.sql.MySQLInsertParser;
import org.apache.shardingsphere.core.parse.old.parser.dialect.oracle.sql.OracleInsertParser;
import org.apache.shardingsphere.core.parse.old.parser.dialect.postgresql.sql.PostgreSQLInsertParser;
import org.apache.shardingsphere.core.parse.old.parser.dialect.sqlserver.sql.SQLServerInsertParser;
import org.apache.shardingsphere.core.parse.old.parser.sql.dml.insert.AbstractInsertParser;
import org.apache.shardingsphere.core.rule.ShardingRule;

public final class InsertParserFactory {
    public static AbstractInsertParser newInstance(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine, ShardingTableMetaData shardingTableMetaData) {
        switch (dbType) {
            case H2: 
            case MySQL: {
                return new MySQLInsertParser(shardingRule, lexerEngine, shardingTableMetaData);
            }
            case Oracle: {
                return new OracleInsertParser(shardingRule, lexerEngine, shardingTableMetaData);
            }
            case SQLServer: {
                return new SQLServerInsertParser(shardingRule, lexerEngine, shardingTableMetaData);
            }
            case PostgreSQL: {
                return new PostgreSQLInsertParser(shardingRule, lexerEngine, shardingTableMetaData);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", dbType));
    }

    private InsertParserFactory() {
    }
}

