/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.sql.dml.select;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.core.constant.AggregationType;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.SelectStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.token.ItemsToken;
import org.apache.shardingsphere.core.parse.antlr.sql.token.OrderByToken;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngine;
import org.apache.shardingsphere.core.parse.old.lexer.token.Assist;
import org.apache.shardingsphere.core.parse.old.lexer.token.DefaultKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.Symbol;
import org.apache.shardingsphere.core.parse.old.parser.clause.facade.AbstractSelectClauseParserFacade;
import org.apache.shardingsphere.core.parse.old.parser.constant.DerivedColumn;
import org.apache.shardingsphere.core.parse.old.parser.context.orderby.OrderItem;
import org.apache.shardingsphere.core.parse.old.parser.context.selectitem.AggregationSelectItem;
import org.apache.shardingsphere.core.parse.old.parser.context.selectitem.DistinctSelectItem;
import org.apache.shardingsphere.core.parse.old.parser.context.selectitem.SelectItem;
import org.apache.shardingsphere.core.parse.old.parser.context.selectitem.StarSelectItem;
import org.apache.shardingsphere.core.parse.old.parser.context.table.Table;
import org.apache.shardingsphere.core.parse.old.parser.sql.SQLParser;
import org.apache.shardingsphere.core.rule.ShardingRule;

public abstract class AbstractSelectParser
implements SQLParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;
    private final AbstractSelectClauseParserFacade selectClauseParserFacade;
    private final List<SelectItem> items = new LinkedList<SelectItem>();
    private final ShardingTableMetaData shardingTableMetaData;

    @Override
    public final SelectStatement parse() {
        SelectStatement result = this.parseInternal();
        if (result.containsSubquery()) {
            result = result.mergeSubqueryStatement();
        }
        this.appendDerivedColumns(result);
        this.appendDerivedOrderBy(result);
        return result;
    }

    private SelectStatement parseInternal() {
        SelectStatement result = new SelectStatement();
        this.lexerEngine.nextToken();
        this.parseInternal(result);
        return result;
    }

    protected abstract void parseInternal(SelectStatement var1);

    protected final void parseSelectList(SelectStatement selectStatement, List<SelectItem> items) {
        this.selectClauseParserFacade.getSelectListClauseParser().parse(selectStatement, items);
    }

    protected final void parseFrom(SelectStatement selectStatement) {
        this.lexerEngine.unsupportedIfEqual(DefaultKeyword.INTO);
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.FROM)) {
            this.parseTable(selectStatement);
        }
    }

    private void parseTable(SelectStatement selectStatement) {
        if (this.lexerEngine.skipIfEqual(Symbol.LEFT_PAREN)) {
            selectStatement.setSubqueryStatement(this.parseInternal());
            if (this.lexerEngine.equalAny(DefaultKeyword.WHERE, Assist.END)) {
                return;
            }
        }
        this.selectClauseParserFacade.getTableReferencesClauseParser().parse(selectStatement, false);
    }

    protected final void parseWhere(ShardingRule shardingRule, SelectStatement selectStatement, List<SelectItem> items) {
        this.selectClauseParserFacade.getWhereClauseParser().parse(shardingRule, selectStatement, items);
    }

    protected final void parseGroupBy(SelectStatement selectStatement) {
        this.selectClauseParserFacade.getGroupByClauseParser().parse(selectStatement);
    }

    protected final void parseHaving() {
        this.selectClauseParserFacade.getHavingClauseParser().parse();
    }

    protected final void parseOrderBy(SelectStatement selectStatement) {
        this.selectClauseParserFacade.getOrderByClauseParser().parse(selectStatement);
    }

    protected final void parseSelectRest() {
        this.selectClauseParserFacade.getSelectRestClauseParser().parse();
    }

    private void appendDerivedColumns(SelectStatement selectStatement) {
        ItemsToken itemsToken = new ItemsToken(selectStatement.getSelectListStopIndex());
        this.appendAvgDerivedColumns(itemsToken, selectStatement);
        this.appendDerivedOrderColumns(itemsToken, selectStatement.getOrderByItems(), selectStatement);
        this.appendDerivedGroupColumns(itemsToken, selectStatement.getGroupByItems(), selectStatement);
        if (!itemsToken.getItems().isEmpty()) {
            selectStatement.addSQLToken(itemsToken);
        }
    }

    private void appendAvgDerivedColumns(ItemsToken itemsToken, SelectStatement selectStatement) {
        int derivedColumnOffset = 0;
        for (SelectItem each : selectStatement.getItems()) {
            if (!(each instanceof AggregationSelectItem) || AggregationType.AVG != ((AggregationSelectItem)each).getType()) continue;
            AggregationSelectItem avgItem = (AggregationSelectItem)each;
            String countAlias = DerivedColumn.AVG_COUNT_ALIAS.getDerivedColumnAlias(derivedColumnOffset);
            AggregationSelectItem countItem = new AggregationSelectItem(AggregationType.COUNT, avgItem.getInnerExpression(), (Optional<String>)Optional.of((Object)countAlias));
            String sumAlias = DerivedColumn.AVG_SUM_ALIAS.getDerivedColumnAlias(derivedColumnOffset);
            AggregationSelectItem sumItem = new AggregationSelectItem(AggregationType.SUM, avgItem.getInnerExpression(), (Optional<String>)Optional.of((Object)sumAlias));
            avgItem.getDerivedAggregationSelectItems().add(countItem);
            avgItem.getDerivedAggregationSelectItems().add(sumItem);
            itemsToken.getItems().add(countItem.getExpression() + " AS " + countAlias + " ");
            itemsToken.getItems().add(sumItem.getExpression() + " AS " + sumAlias + " ");
            ++derivedColumnOffset;
        }
    }

    private void appendDerivedOrderColumns(ItemsToken itemsToken, List<OrderItem> orderItems, SelectStatement selectStatement) {
        int derivedColumnOffset = 0;
        for (OrderItem each : orderItems) {
            if (this.containsItem(selectStatement, each)) continue;
            String alias = DerivedColumn.ORDER_BY_ALIAS.getDerivedColumnAlias(derivedColumnOffset++);
            each.setAlias(alias);
            itemsToken.getItems().add((String)each.getQualifiedName().get() + " AS " + alias + " ");
        }
    }

    private void appendDerivedGroupColumns(ItemsToken itemsToken, List<OrderItem> orderItems, SelectStatement selectStatement) {
        int derivedColumnOffset = 0;
        for (OrderItem each : orderItems) {
            if (this.containsItem(selectStatement, each)) continue;
            String alias = DerivedColumn.GROUP_BY_ALIAS.getDerivedColumnAlias(derivedColumnOffset++);
            each.setAlias(alias);
            itemsToken.getItems().add((String)each.getQualifiedName().get() + " AS " + alias + " ");
        }
    }

    private boolean containsItem(SelectStatement selectStatement, OrderItem orderItem) {
        return orderItem.isIndex() || this.containsItemInStarSelectItems(selectStatement, orderItem) || this.containsItemInSelectItems(selectStatement, orderItem);
    }

    private boolean containsItemInStarSelectItems(SelectStatement selectStatement, OrderItem orderItem) {
        return selectStatement.hasUnqualifiedStarSelectItem() || this.containsItemWithOwnerInStarSelectItems(selectStatement, orderItem) || this.containsItemWithoutOwnerInStarSelectItems(selectStatement, orderItem);
    }

    private boolean containsItemWithOwnerInStarSelectItems(SelectStatement selectStatement, OrderItem orderItem) {
        return orderItem.getOwner().isPresent() && selectStatement.findStarSelectItem((String)orderItem.getOwner().get()).isPresent();
    }

    private boolean containsItemWithoutOwnerInStarSelectItems(SelectStatement selectStatement, OrderItem orderItem) {
        if (!orderItem.getOwner().isPresent()) {
            for (StarSelectItem each : selectStatement.getQualifiedStarSelectItems()) {
                if (!this.isSameSelectItem(selectStatement, each, orderItem)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSameSelectItem(SelectStatement selectStatement, StarSelectItem starSelectItem, OrderItem orderItem) {
        Preconditions.checkState((boolean)starSelectItem.getOwner().isPresent());
        Preconditions.checkState((boolean)orderItem.getName().isPresent());
        Optional<Table> table = selectStatement.getTables().find((String)starSelectItem.getOwner().get());
        return table.isPresent() && this.shardingTableMetaData.containsColumn(((Table)table.get()).getName(), (String)orderItem.getName().get());
    }

    private boolean containsItemInSelectItems(SelectStatement selectStatement, OrderItem orderItem) {
        for (SelectItem each : selectStatement.getItems()) {
            if (!this.containsItemInDistinctItems(orderItem, each) && !this.isSameAlias(each, orderItem) && !this.isSameQualifiedName(each, orderItem)) continue;
            return true;
        }
        return false;
    }

    private boolean containsItemInDistinctItems(OrderItem orderItem, SelectItem selectItem) {
        if (!(selectItem instanceof DistinctSelectItem)) {
            return false;
        }
        DistinctSelectItem distinctSelectItem = (DistinctSelectItem)selectItem;
        return distinctSelectItem.getDistinctColumnLabels().contains(orderItem.getColumnLabel());
    }

    private boolean isSameAlias(SelectItem selectItem, OrderItem orderItem) {
        return selectItem.getAlias().isPresent() && orderItem.getAlias().isPresent() && ((String)selectItem.getAlias().get()).equalsIgnoreCase((String)orderItem.getAlias().get());
    }

    private boolean isSameQualifiedName(SelectItem selectItem, OrderItem orderItem) {
        return !selectItem.getAlias().isPresent() && orderItem.getQualifiedName().isPresent() && selectItem.getExpression().equalsIgnoreCase((String)orderItem.getQualifiedName().get());
    }

    private void appendDerivedOrderBy(SelectStatement selectStatement) {
        if (!selectStatement.getGroupByItems().isEmpty() && selectStatement.getOrderByItems().isEmpty()) {
            selectStatement.getOrderByItems().addAll(selectStatement.getGroupByItems());
            selectStatement.addSQLToken(new OrderByToken(selectStatement.getGroupByLastIndex() + 1));
        }
    }

    @ConstructorProperties(value={"shardingRule", "lexerEngine", "selectClauseParserFacade", "shardingTableMetaData"})
    public AbstractSelectParser(ShardingRule shardingRule, LexerEngine lexerEngine, AbstractSelectClauseParserFacade selectClauseParserFacade, ShardingTableMetaData shardingTableMetaData) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
        this.selectClauseParserFacade = selectClauseParserFacade;
        this.shardingTableMetaData = shardingTableMetaData;
    }

    protected ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    protected LexerEngine getLexerEngine() {
        return this.lexerEngine;
    }

    protected AbstractSelectClauseParserFacade getSelectClauseParserFacade() {
        return this.selectClauseParserFacade;
    }

    protected List<SelectItem> getItems() {
        return this.items;
    }

    protected ShardingTableMetaData getShardingTableMetaData() {
        return this.shardingTableMetaData;
    }
}

