/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.sql.dml.select;

import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngine;
import org.apache.shardingsphere.core.parse.old.parser.dialect.mysql.sql.MySQLSelectParser;
import org.apache.shardingsphere.core.parse.old.parser.dialect.oracle.sql.OracleSelectParser;
import org.apache.shardingsphere.core.parse.old.parser.dialect.postgresql.sql.PostgreSQLSelectParser;
import org.apache.shardingsphere.core.parse.old.parser.dialect.sqlserver.sql.SQLServerSelectParser;
import org.apache.shardingsphere.core.parse.old.parser.sql.dml.select.AbstractSelectParser;
import org.apache.shardingsphere.core.rule.ShardingRule;

public final class SelectParserFactory {
    public static AbstractSelectParser newInstance(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine, ShardingTableMetaData shardingTableMetaData) {
        switch (dbType) {
            case H2: 
            case MySQL: {
                return new MySQLSelectParser(shardingRule, lexerEngine, shardingTableMetaData);
            }
            case Oracle: {
                return new OracleSelectParser(shardingRule, lexerEngine, shardingTableMetaData);
            }
            case SQLServer: {
                return new SQLServerSelectParser(shardingRule, lexerEngine, shardingTableMetaData);
            }
            case PostgreSQL: {
                return new PostgreSQLSelectParser(shardingRule, lexerEngine, shardingTableMetaData);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", dbType));
    }

    private SelectParserFactory() {
    }
}

