/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.old.parser.sql.dml.update;

import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngine;
import org.apache.shardingsphere.core.parse.old.parser.dialect.mysql.sql.MySQLUpdateParser;
import org.apache.shardingsphere.core.parse.old.parser.dialect.oracle.sql.OracleUpdateParser;
import org.apache.shardingsphere.core.parse.old.parser.dialect.postgresql.sql.PostgreSQLUpdateParser;
import org.apache.shardingsphere.core.parse.old.parser.dialect.sqlserver.sql.SQLServerUpdateParser;
import org.apache.shardingsphere.core.parse.old.parser.sql.dml.update.AbstractUpdateParser;
import org.apache.shardingsphere.core.rule.ShardingRule;

public final class UpdateParserFactory {
    public static AbstractUpdateParser newInstance(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        switch (dbType) {
            case H2: 
            case MySQL: {
                return new MySQLUpdateParser(shardingRule, lexerEngine);
            }
            case Oracle: {
                return new OracleUpdateParser(shardingRule, lexerEngine);
            }
            case SQLServer: {
                return new SQLServerUpdateParser(shardingRule, lexerEngine);
            }
            case PostgreSQL: {
                return new PostgreSQLUpdateParser(shardingRule, lexerEngine);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", dbType));
    }

    private UpdateParserFactory() {
    }
}

