/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.util;

import com.google.common.base.CharMatcher;
import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.parse.old.lexer.dialect.mysql.MySQLKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.DefaultKeyword;

public final class SQLUtil {
    public static String getExactlyValue(String value) {
        return null == value ? null : CharMatcher.anyOf((CharSequence)"[]`'\"").removeFrom((CharSequence)value);
    }

    public static String getExactlyExpression(String value) {
        return null == value ? null : CharMatcher.anyOf((CharSequence)" ").removeFrom((CharSequence)value);
    }

    public static String getOriginalValue(String value, DatabaseType databaseType) {
        if (DatabaseType.MySQL != databaseType) {
            return value;
        }
        try {
            DefaultKeyword.valueOf(value.toUpperCase());
            return String.format("`%s`", value);
        }
        catch (IllegalArgumentException ex) {
            return SQLUtil.getOriginalValueForMySQLKeyword(value);
        }
    }

    private static String getOriginalValueForMySQLKeyword(String value) {
        try {
            MySQLKeyword.valueOf(value.toUpperCase());
            return String.format("`%s`", value);
        }
        catch (IllegalArgumentException ex) {
            return value;
        }
    }

    private SQLUtil() {
    }
}

