/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Atan2$;
import org.apache.spark.sql.catalyst.expressions.BinaryMathExpression;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(exprY, exprX) - Returns the angle in radians between the positive x-axis of a plane\n      and the point given by the coordinates (`exprX`, `exprY`), as if computed by\n      `java.lang.Math._FUNC_`.\n  ", arguments="\n    Arguments:\n      * exprY - coordinate on y-axis\n      * exprX - coordinate on x-axis\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(0, 0);\n       0.0\n  ", since="1.4.0")
@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001\u0002\r\u001a\u0001\u001aB\u0001\u0002\u000e\u0001\u0003\u0016\u0004%\t!\u000e\u0005\ts\u0001\u0011\t\u0012)A\u0005m!A!\b\u0001BK\u0002\u0013\u0005Q\u0007\u0003\u0005<\u0001\tE\t\u0015!\u00037\u0011\u0015a\u0004\u0001\"\u0001>\u0011\u0015\t\u0005\u0001\"\u0015C\u0011\u0015Q\u0005\u0001\"\u0011L\u0011\u001dI\u0006!!A\u0005\u0002iCq!\u0018\u0001\u0012\u0002\u0013\u0005a\fC\u0004j\u0001E\u0005I\u0011\u00010\t\u000f)\u0004\u0011\u0011!C!W\"9A\u000fAA\u0001\n\u0003)\bbB=\u0001\u0003\u0003%\tA\u001f\u0005\b{\u0002\t\t\u0011\"\u0011\u007f\u0011%\tY\u0001AA\u0001\n\u0003\ti\u0001C\u0005\u0002\u0018\u0001\t\t\u0011\"\u0011\u0002\u001a\u001dI\u0011QH\r\u0002\u0002#\u0005\u0011q\b\u0004\t1e\t\t\u0011#\u0001\u0002B!1AH\u0005C\u0001\u0003\u001fB\u0011\"!\u0015\u0013\u0003\u0003%)%a\u0015\t\u0013\u0005U##!A\u0005\u0002\u0006]\u0003\"CA/%\u0005\u0005I\u0011QA0\u0011%\t\tHEA\u0001\n\u0013\t\u0019HA\u0003Bi\u0006t'G\u0003\u0002\u001b7\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\taR$\u0001\u0005dCR\fG._:u\u0015\tqr$A\u0002tc2T!\u0001I\u0011\u0002\u000bM\u0004\u0018M]6\u000b\u0005\t\u001a\u0013AB1qC\u000eDWMC\u0001%\u0003\ry'oZ\u0002\u0001'\u0011\u0001qeK\u0019\u0011\u0005!JS\"A\r\n\u0005)J\"\u0001\u0006\"j]\u0006\u0014\u00180T1uQ\u0016C\bO]3tg&|g\u000e\u0005\u0002-_5\tQFC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001TFA\u0004Qe>$Wo\u0019;\u0011\u00051\u0012\u0014BA\u001a.\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011aWM\u001a;\u0016\u0003Y\u0002\"\u0001K\u001c\n\u0005aJ\"AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\na\u0001P5oSRtDc\u0001 @\u0001B\u0011\u0001\u0006\u0001\u0005\u0006i\u0015\u0001\rA\u000e\u0005\u0006u\u0015\u0001\rAN\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004\u0007\u001aC\u0005C\u0001\u0017E\u0013\t)UFA\u0002B]fDQa\u0012\u0004A\u0002\r\u000ba!\u001b8qkR\f\u0004\"B%\u0007\u0001\u0004\u0019\u0015AB5oaV$('A\u0005e_\u001e+gnQ8eKR\u0019AJU,\u0011\u00055\u0003V\"\u0001(\u000b\u0005=K\u0012aB2pI\u0016<WM\\\u0005\u0003#:\u0013\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006'\u001e\u0001\r\u0001V\u0001\u0004GRD\bCA'V\u0013\t1fJ\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000ba;\u0001\u0019\u0001'\u0002\u0005\u00154\u0018\u0001B2paf$2AP.]\u0011\u001d!\u0004\u0002%AA\u0002YBqA\u000f\u0005\u0011\u0002\u0003\u0007a'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003}S#A\u000e1,\u0003\u0005\u0004\"AY4\u000e\u0003\rT!\u0001Z3\u0002\u0013Ut7\r[3dW\u0016$'B\u00014.\u0003)\tgN\\8uCRLwN\\\u0005\u0003Q\u000e\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#\u00017\u0011\u00055\u0014X\"\u00018\u000b\u0005=\u0004\u0018\u0001\u00027b]\u001eT\u0011!]\u0001\u0005U\u00064\u0018-\u0003\u0002t]\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012A\u001e\t\u0003Y]L!\u0001_\u0017\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0005\r[\bb\u0002?\u000e\u0003\u0003\u0005\rA^\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0003}\u0004R!!\u0001\u0002\b\rk!!a\u0001\u000b\u0007\u0005\u0015Q&\u0001\u0006d_2dWm\u0019;j_:LA!!\u0003\u0002\u0004\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ty!!\u0006\u0011\u00071\n\t\"C\u0002\u0002\u00145\u0012qAQ8pY\u0016\fg\u000eC\u0004}\u001f\u0005\u0005\t\u0019A\"\u0002\r\u0015\fX/\u00197t)\u0011\ty!a\u0007\t\u000fq\u0004\u0012\u0011!a\u0001\u0007\"\u001a\u0002!a\b\u0002&\u0005\u001d\u00121FA\u0017\u0003c\t\u0019$a\u000e\u0002:A\u0019\u0001&!\t\n\u0007\u0005\r\u0012DA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005%\u0012!!+\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006&\u001a=qefc\u0003%\u001a=qebK\u0003%\f\u0011SKR,(O\\:!i\",\u0007%\u00198hY\u0016\u0004\u0013N\u001c\u0011sC\u0012L\u0017M\\:!E\u0016$x/Z3oAQDW\r\t9pg&$\u0018N^3!q6\n\u00070[:!_\u001a\u0004\u0013\r\t9mC:,'\u0002\t\u0011!A\u0001\u0002\u0013M\u001c3!i\",\u0007\u0005]8j]R\u0004s-\u001b<f]\u0002\u0012\u0017\u0010\t;iK\u0002\u001awn\u001c:eS:\fG/Z:!Q\u0001,\u0007\u0010\u001d:YA2\u0002\u0003-\u001a=qef\u0003\u0017\u0006\f\u0011bg\u0002Jg\rI2p[B,H/\u001a3!EfT\u0001\u0005\t\u0011!A\u0001\u0002'.\u0019<b]1\fgn\u001a\u0018NCRDgf\u0018$V\u001d\u000e{\u0006M\f\u0006!A\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003_\tAL\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!Kb\u0004(/\u0017\u0011.A\r|wN\u001d3j]\u0006$X\rI8oAel\u0013\r_5t\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001*\u0007\u0010\u001d:YA5\u00023m\\8sI&t\u0017\r^3!_:\u0004\u00030L1ySNT\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011QG\u0001:\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u0002D\u0006\t\u0019*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0002d\u0006\r\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u00111H\u0001\u0006c9\"d\u0006M\u0001\u0006\u0003R\fgN\r\t\u0003QI\u0019BAEA\"cA9\u0011QIA&mYrTBAA$\u0015\r\tI%L\u0001\beVtG/[7f\u0013\u0011\ti%a\u0012\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0002@\u0005AAo\\*ue&tw\rF\u0001m\u0003\u0015\t\u0007\u000f\u001d7z)\u0015q\u0014\u0011LA.\u0011\u0015!T\u00031\u00017\u0011\u0015QT\u00031\u00017\u0003\u001d)h.\u00199qYf$B!!\u0019\u0002nA)A&a\u0019\u0002h%\u0019\u0011QM\u0017\u0003\r=\u0003H/[8o!\u0015a\u0013\u0011\u000e\u001c7\u0013\r\tY'\f\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005=d#!AA\u0002y\n1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005U\u0004cA7\u0002x%\u0019\u0011\u0011\u00108\u0003\r=\u0013'.Z2u\u0001")
public class Atan2
extends BinaryMathExpression {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(Atan2 atan2) {
        return Atan2$.MODULE$.unapply(atan2);
    }

    public static Function1<Tuple2<Expression, Expression>, Atan2> tupled() {
        return Atan2$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Atan2>> curried() {
        return Atan2$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return BoxesRunTime.boxToDouble((double)package$.MODULE$.atan2(BoxesRunTime.unboxToDouble((Object)input1) + 0.0, BoxesRunTime.unboxToDouble((Object)input2) + 0.0));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & java.io.Serializable & Serializable)(c1, c2) -> new StringBuilder(36).append("java.lang.Math.atan2(").append((String)c1).append(" + 0.0, ").append((String)c2).append(" + 0.0)").toString());
    }

    public Atan2 copy(Expression left, Expression right) {
        return new Atan2(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "Atan2";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Atan2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Atan2)) return false;
        boolean bl = true;
        if (!bl) return false;
        Atan2 atan2 = (Atan2)x$1;
        Expression expression = this.left();
        Expression expression2 = atan2.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = atan2.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!atan2.canEqual(this)) return false;
        return true;
    }

    public Atan2(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        super((Function2<Object, Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double y, double x) {
                return this.apply$mcDDD$sp(y, x);
            }

            public double apply$mcDDD$sp(double y, double x) {
                return package$.MODULE$.atan2(y, x);
            }
        }, "ATAN2");
    }
}

