/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BitLength$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the bit length of string data or number of bits of binary data.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL');\n       72\n  ", since="2.3.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001\u0002\r\u001a\u0001\u001aB\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005\u0001\")A\t\u0001C\u0001\u000b\")\u0001\n\u0001C!\u0013\")\u0001\u000b\u0001C!#\")\u0001\r\u0001C)C\")q\r\u0001C!Q\")a\u000f\u0001C!o\"I\u0011\u0011\u0001\u0001\u0002\u0002\u0013\u0005\u00111\u0001\u0005\n\u0003\u000f\u0001\u0011\u0013!C\u0001\u0003\u0013A\u0011\"a\b\u0001\u0003\u0003%\t%!\t\t\u0013\u0005E\u0002!!A\u0005\u0002\u0005M\u0002\"CA\u001e\u0001\u0005\u0005I\u0011AA\u001f\u0011%\t\u0019\u0005AA\u0001\n\u0003\n)\u0005C\u0005\u0002T\u0001\t\t\u0011\"\u0001\u0002V!I\u0011q\f\u0001\u0002\u0002\u0013\u0005\u0013\u0011M\u0004\n\u0003\u007fJ\u0012\u0011!E\u0001\u0003\u00033\u0001\u0002G\r\u0002\u0002#\u0005\u00111\u0011\u0005\u0007\tJ!\t!!%\t\u0013\u0005M%#!A\u0005F\u0005U\u0005\"CAL%\u0005\u0005I\u0011QAM\u0011%\tiJEA\u0001\n\u0003\u000by\nC\u0005\u0002,J\t\t\u0011\"\u0003\u0002.\nI!)\u001b;MK:<G\u000f\u001b\u0006\u00035m\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011A$H\u0001\tG\u0006$\u0018\r\\=ti*\u0011adH\u0001\u0004gFd'B\u0001\u0011\"\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00113%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002I\u0005\u0019qN]4\u0004\u0001M1\u0001aJ\u0016/km\u0002\"\u0001K\u0015\u000e\u0003eI!AK\r\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"\u0001\u000b\u0017\n\u00055J\"AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005=\u0012dB\u0001\u00151\u0013\t\t\u0014$A\u0004qC\u000e\\\u0017mZ3\n\u0005M\"$A\u0004(vY2Le\u000e^8mKJ\fg\u000e\u001e\u0006\u0003ce\u0001\"AN\u001d\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00027y%\u0011Qh\u000e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0006G\"LG\u000eZ\u000b\u0002\u0001B\u0011\u0001&Q\u0005\u0003\u0005f\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019\u0019\u0007.\u001b7eA\u00051A(\u001b8jiz\"\"AR$\u0011\u0005!\u0002\u0001\"\u0002 \u0004\u0001\u0004\u0001\u0015\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003)\u0003\"a\u0013(\u000e\u00031S!!T\u000f\u0002\u000bQL\b/Z:\n\u0005=c%\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001S!\r\u0019&,\u0018\b\u0003)fs!!\u0016-\u000e\u0003YS!aV\u0013\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0014BA\u00198\u0013\tYFLA\u0002TKFT!!M\u001c\u0011\u0005-s\u0016BA0M\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0002cKB\u0011agY\u0005\u0003I^\u00121!\u00118z\u0011\u00151g\u00011\u0001c\u0003\u00151\u0018\r\\;f\u0003%!wnR3o\u0007>$W\rF\u0002j_R\u0004\"A[7\u000e\u0003-T!\u0001\\\r\u0002\u000f\r|G-Z4f]&\u0011an\u001b\u0002\t\u000bb\u0004(oQ8eK\")\u0001o\u0002a\u0001c\u0006\u00191\r\u001e=\u0011\u0005)\u0014\u0018BA:l\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQ!^\u0004A\u0002%\f!!\u001a<\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001y!\tIXP\u0004\u0002{wB\u0011QkN\u0005\u0003y^\na\u0001\u0015:fI\u00164\u0017B\u0001@\u0000\u0005\u0019\u0019FO]5oO*\u0011ApN\u0001\u0005G>\u0004\u0018\u0010F\u0002G\u0003\u000bAqAP\u0005\u0011\u0002\u0003\u0007\u0001)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005-!f\u0001!\u0002\u000e-\u0012\u0011q\u0002\t\u0005\u0003#\tY\"\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003%)hn\u00195fG.,GMC\u0002\u0002\u001a]\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti\"a\u0005\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003G\u0001B!!\n\u000205\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#\u0001\u0003mC:<'BAA\u0017\u0003\u0011Q\u0017M^1\n\u0007y\f9#\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u00026A\u0019a'a\u000e\n\u0007\u0005erGA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002c\u0003\u007fA\u0011\"!\u0011\u000e\u0003\u0003\u0005\r!!\u000e\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t9\u0005E\u0003\u0002J\u0005=#-\u0004\u0002\u0002L)\u0019\u0011QJ\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002R\u0005-#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u0016\u0002^A\u0019a'!\u0017\n\u0007\u0005msGA\u0004C_>dW-\u00198\t\u0011\u0005\u0005s\"!AA\u0002\t\fa!Z9vC2\u001cH\u0003BA,\u0003GB\u0001\"!\u0011\u0011\u0003\u0003\u0005\rA\u0019\u0015\u0010\u0001\u0005\u001d\u0014QNA8\u0003g\n)(!\u001f\u0002|A\u0019\u0001&!\u001b\n\u0007\u0005-\u0014DA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005E\u0014AV0G+:\u001bu\fK3yaJL\u0003%\f\u0011SKR,(O\\:!i\",\u0007EY5uA1,gn\u001a;iA=4\u0007e\u001d;sS:<\u0007\u0005Z1uC\u0002z'\u000f\t8v[\n,'\u000fI8gA\tLGo\u001d\u0011pM\u0002\u0012\u0017N\\1ss\u0002\"\u0017\r^1/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA<\u0003}R\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ*qCJ\\\u0007eU)MO%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u000e\u001a\u000bA\u0001\nQa]5oG\u0016\f#!! \u0002\u000bIr3G\f\u0019\u0002\u0013\tKG\u000fT3oORD\u0007C\u0001\u0015\u0013'\u0011\u0011\u0012QQ\u001e\u0011\r\u0005\u001d\u0015Q\u0012!G\u001b\t\tIIC\u0002\u0002\f^\nqA];oi&lW-\u0003\u0003\u0002\u0010\u0006%%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u0011\u0011\u0011Q\u0001\ti>\u001cFO]5oOR\u0011\u00111E\u0001\u0006CB\u0004H.\u001f\u000b\u0004\r\u0006m\u0005\"\u0002 \u0016\u0001\u0004\u0001\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003C\u000b9\u000b\u0005\u00037\u0003G\u0003\u0015bAASo\t1q\n\u001d;j_:D\u0001\"!+\u0017\u0003\u0003\u0005\rAR\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a,\u0011\t\u0005\u0015\u0012\u0011W\u0005\u0005\u0003g\u000b9C\u0001\u0004PE*,7\r\u001e")
public class BitLength
extends UnaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression child;

    public static Option<Expression> unapply(BitLength bitLength) {
        return BitLength$.MODULE$.unapply(bitLength);
    }

    public static <A> Function1<Expression, A> andThen(Function1<BitLength, A> function1) {
        return BitLength$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, BitLength> compose(Function1<A, Expression> function1) {
        return BitLength$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringType$.MODULE$, BinaryType$.MODULE$}))}));
    }

    @Override
    public Object nullSafeEval(Object value) {
        Integer n;
        DataType dataType = this.child().dataType();
        if (StringType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)(((UTF8String)value).numBytes() * 8));
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)(((byte[])value).length * 8));
        } else {
            throw new MatchError((Object)dataType);
        }
        return n;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        DataType dataType = this.child().dataType();
        if (StringType$.MODULE$.equals(dataType)) {
            exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(17).append("(").append((String)c).append(").numBytes() * 8").toString());
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(13).append("(").append((String)c).append(").length * 8").toString());
        } else {
            throw new MatchError((Object)dataType);
        }
        return exprCode;
    }

    @Override
    public String prettyName() {
        return "bit_length";
    }

    public BitLength copy(Expression child) {
        return new BitLength(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "BitLength";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitLength;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitLength)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitLength bitLength = (BitLength)x$1;
        Expression expression = this.child();
        Expression expression2 = bitLength.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!bitLength.canEqual(this)) return false;
        return true;
    }

    public BitLength(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

