/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.DateFormatClass$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimestampFormatterHelper;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(timestamp, fmt) - Converts `timestamp` to a value of string in the format specified by the date format `fmt`.", arguments="\n    Arguments:\n      * timestamp - A date/timestamp or string to be converted to the given format.\n      * fmt - Date/time format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid date\n              and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-04-08', 'y');\n       2016\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\t\u0015b\u0001\u0002\u0013&\u0001JB\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\t%\u0002\u0011\t\u0012)A\u0005\u001f\"A1\u000b\u0001BK\u0002\u0013\u0005a\n\u0003\u0005U\u0001\tE\t\u0015!\u0003P\u0011!)\u0006A!f\u0001\n\u00031\u0006\u0002C3\u0001\u0005#\u0005\u000b\u0011B,\t\u000b\u0019\u0004A\u0011A4\t\u000b\u0019\u0004A\u0011\u00017\t\u000b=\u0004A\u0011\t9\t\u000b]\u0004A\u0011\t=\t\u000f\u0005%\u0001\u0001\"\u0011\u0002\f!9\u0011Q\u0003\u0001\u0005R\u0005]\u0001bBA\u0014\u0001\u0011\u0005\u0013\u0011\u0006\u0005\b\u0003\u000b\u0002A\u0011IA$\u0011\u0019\tI\u0005\u0001C)\u001d\"9\u00111\n\u0001\u0005R\u00055\u0003\"CA+\u0001\u0005\u0005I\u0011AA,\u0011%\ty\u0006AI\u0001\n\u0003\t\t\u0007C\u0005\u0002x\u0001\t\n\u0011\"\u0001\u0002b!I\u0011\u0011\u0010\u0001\u0012\u0002\u0013\u0005\u00111\u0010\u0005\n\u0003\u007f\u0002\u0011\u0011!C!\u0003\u0003C\u0011\"!%\u0001\u0003\u0003%\t!a%\t\u0013\u0005m\u0005!!A\u0005\u0002\u0005u\u0005\"CAR\u0001\u0005\u0005I\u0011IAS\u0011%\t\u0019\fAA\u0001\n\u0003\t)\fC\u0005\u0002:\u0002\t\t\u0011\"\u0011\u0002<\u001eI\u0011Q]\u0013\u0002\u0002#\u0005\u0011q\u001d\u0004\tI\u0015\n\t\u0011#\u0001\u0002j\"1a\r\bC\u0001\u0003oD\u0011\"!?\u001d\u0003\u0003%)%a?\t\u0013\u0005uH$!A\u0005\u0002\u0006}\b\"\u0003B\u00049E\u0005I\u0011AA>\u0011%\u0011I\u0001HA\u0001\n\u0003\u0013Y\u0001C\u0005\u0003\u001aq\t\n\u0011\"\u0001\u0002|!I!1\u0004\u000f\u0002\u0002\u0013%!Q\u0004\u0002\u0010\t\u0006$XMR8s[\u0006$8\t\\1tg*\u0011aeJ\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002)S\u0005A1-\u0019;bYf\u001cHO\u0003\u0002+W\u0005\u00191/\u001d7\u000b\u00051j\u0013!B:qCJ\\'B\u0001\u00180\u0003\u0019\t\u0007/Y2iK*\t\u0001'A\u0002pe\u001e\u001c\u0001aE\u0004\u0001g]RT\b\u0012&\u0011\u0005Q*T\"A\u0013\n\u0005Y*#\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t!\u0004(\u0003\u0002:K\tAB+[7fgR\fW\u000e\u001d$pe6\fG\u000f^3s\u0011\u0016d\u0007/\u001a:\u0011\u0005QZ\u0014B\u0001\u001f&\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001 B\u001d\t!t(\u0003\u0002AK\u00059\u0001/Y2lC\u001e,\u0017B\u0001\"D\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!\u0001Q\u0013\u0011\u0005\u0015CU\"\u0001$\u000b\u0003\u001d\u000bQa]2bY\u0006L!!\u0013$\u0003\u000fA\u0013x\u000eZ;diB\u0011QiS\u0005\u0003\u0019\u001a\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fA\u0001\\3giV\tq\n\u0005\u00025!&\u0011\u0011+\n\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u00027fMR\u0004\u0013!\u0002:jO\"$\u0018A\u0002:jO\"$\b%\u0001\u0006uS6,'l\u001c8f\u0013\u0012,\u0012a\u0016\t\u0004\u000bbS\u0016BA-G\u0005\u0019y\u0005\u000f^5p]B\u00111L\u0019\b\u00039\u0002\u0004\"!\u0018$\u000e\u0003yS!aX\u0019\u0002\rq\u0012xn\u001c;?\u0013\t\tg)\u0001\u0004Qe\u0016$WMZ\u0005\u0003G\u0012\u0014aa\u0015;sS:<'BA1G\u0003-!\u0018.\\3[_:,\u0017\n\u001a\u0011\u0002\rqJg.\u001b;?)\u0011A\u0017N[6\u0011\u0005Q\u0002\u0001\"B'\b\u0001\u0004y\u0005\"B*\b\u0001\u0004y\u0005bB+\b!\u0003\u0005\ra\u0016\u000b\u0004Q6t\u0007\"B'\t\u0001\u0004y\u0005\"B*\t\u0001\u0004y\u0015\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003E\u0004\"A];\u000e\u0003MT!\u0001^\u0015\u0002\u000bQL\b/Z:\n\u0005Y\u001c(\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001z!\u0011Qh0a\u0001\u000f\u0005mlhBA/}\u0013\u00059\u0015B\u0001!G\u0013\ry\u0018\u0011\u0001\u0002\u0004'\u0016\f(B\u0001!G!\r\u0011\u0018QA\u0005\u0004\u0003\u000f\u0019(\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u000319\u0018\u000e\u001e5US6,'l\u001c8f)\u0011\ti!a\u0005\u0011\u0007Q\ny!C\u0002\u0002\u0012\u0015\u0012q\u0003V5nKj{g.Z!xCJ,W\t\u001f9sKN\u001c\u0018n\u001c8\t\u000bU[\u0001\u0019\u0001.\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\r\u0005e\u0011qDA\u0012!\r)\u00151D\u0005\u0004\u0003;1%aA!os\"9\u0011\u0011\u0005\u0007A\u0002\u0005e\u0011!\u0003;j[\u0016\u001cH/Y7q\u0011\u001d\t)\u0003\u0004a\u0001\u00033\taAZ8s[\u0006$\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0019\tY#a\u000e\u0002BA!\u0011QFA\u001a\u001b\t\tyCC\u0002\u00022\u0015\nqaY8eK\u001e,g.\u0003\u0003\u00026\u0005=\"\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005eR\u00021\u0001\u0002<\u0005\u00191\r\u001e=\u0011\t\u00055\u0012QH\u0005\u0005\u0003\u007f\tyC\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005\rS\u00021\u0001\u0002,\u0005\u0011QM^\u0001\u000baJ,G\u000f^=OC6,W#\u0001.\u0002\u0019\u0019|'/\\1u'R\u0014\u0018N\\4\u0002\u0013%\u001c\b+\u0019:tS:<WCAA(!\r)\u0015\u0011K\u0005\u0004\u0003'2%a\u0002\"p_2,\u0017M\\\u0001\u0005G>\u0004\u0018\u0010F\u0004i\u00033\nY&!\u0018\t\u000f5\u000b\u0002\u0013!a\u0001\u001f\"91+\u0005I\u0001\u0002\u0004y\u0005bB+\u0012!\u0003\u0005\raV\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\u0019GK\u0002P\u0003KZ#!a\u001a\u0011\t\u0005%\u00141O\u0007\u0003\u0003WRA!!\u001c\u0002p\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003c2\u0015AC1o]>$\u0018\r^5p]&!\u0011QOA6\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!! +\u0007]\u000b)'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0007\u0003B!!\"\u0002\u00106\u0011\u0011q\u0011\u0006\u0005\u0003\u0013\u000bY)\u0001\u0003mC:<'BAAG\u0003\u0011Q\u0017M^1\n\u0007\r\f9)\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u0016B\u0019Q)a&\n\u0007\u0005eeIA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u001a\u0005}\u0005\"CAQ/\u0005\u0005\t\u0019AAK\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0015\t\u0007\u0003S\u000by+!\u0007\u000e\u0005\u0005-&bAAW\r\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005E\u00161\u0016\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002P\u0005]\u0006\"CAQ3\u0005\u0005\t\u0019AA\r\u0003\u0019)\u0017/^1mgR!\u0011qJA_\u0011%\t\tKGA\u0001\u0002\u0004\tI\u0002K\f\u0001\u0003\u0003\f9-!3\u0002N\u0006=\u00171[Ak\u00033\fY.a8\u0002bB\u0019A'a1\n\u0007\u0005\u0015WEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005-\u0017\u0001^0G+:\u001bu\f\u000b;j[\u0016\u001cH/Y7qY\u00012W\u000e^\u0015![\u0001\u001auN\u001c<feR\u001c\b\u0005\u0019;j[\u0016\u001cH/Y7qA\u0002\"x\u000eI1!m\u0006dW/\u001a\u0011pM\u0002\u001aHO]5oO\u0002Jg\u000e\t;iK\u00022wN]7bi\u0002\u001a\b/Z2jM&,G\r\t2zAQDW\r\t3bi\u0016\u0004cm\u001c:nCR\u0004\u0003MZ7uA:\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\u0005E\u0017A!\u001c\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\"\u0018.\\3ti\u0006l\u0007\u000fI\u0017!\u0003\u0002\"\u0017\r^30i&lWm\u001d;b[B\u0004sN\u001d\u0011tiJLgn\u001a\u0011u_\u0002\u0012W\rI2p]Z,'\u000f^3eAQ|\u0007\u0005\u001e5fA\u001dLg/\u001a8!M>\u0014X.\u0019;/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u00012W\u000e\u001e\u0011.A\u0011\u000bG/Z\u0018uS6,\u0007EZ8s[\u0006$\b\u0005]1ui\u0016\u0014h\u000e\t;pA\u0019|G\u000e\\8x]\u0001\u001aV-\u001a\u0011=C\u0002B'/\u001a4>E!$H\u000f]:;_=\u001a\b/\u0019:l]\u0005\u0004\u0018m\u00195f]=\u0014xm\f3pGN|C.\u0019;fgR|3/\u001d7.e\u00164W\u0006Z1uKRLW.Z\u0017qCR$XM\u001d8/QRlGN\t ECR,G/[7fAA\u000bG\u000f^3s]Ndt&\u0019 !M>\u0014\bE^1mS\u0012\u0004C-\u0019;f\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0005tG\r\t;j[\u0016\u0004cm\u001c:nCR\u0004\u0003/\u0019;uKJt7O\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002X\u00069%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00143aE2T\u0006\r\u001b.aa:C\u0006I\u0014zO%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192m)\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002^\u0006qA-\u0019;fi&lWm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017EAAr\u0003\u0015\td&\u000e\u00181\u0003=!\u0015\r^3G_Jl\u0017\r^\"mCN\u001c\bC\u0001\u001b\u001d'\u0011a\u00121\u001e&\u0011\u0011\u00055\u00181_(P/\"l!!a<\u000b\u0007\u0005Eh)A\u0004sk:$\u0018.\\3\n\t\u0005U\u0018q\u001e\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001cDCAAt\u0003!!xn\u0015;sS:<GCAAB\u0003\u0015\t\u0007\u000f\u001d7z)\u001dA'\u0011\u0001B\u0002\u0005\u000bAQ!T\u0010A\u0002=CQaU\u0010A\u0002=Cq!V\u0010\u0011\u0002\u0003\u0007q+A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003\u001d)h.\u00199qYf$BA!\u0004\u0003\u0016A!Q\t\u0017B\b!\u0019)%\u0011C(P/&\u0019!1\u0003$\u0003\rQ+\b\u000f\\34\u0011!\u00119\"IA\u0001\u0002\u0004A\u0017a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\n1B]3bIJ+7o\u001c7wKR\u0011!q\u0004\t\u0005\u0003\u000b\u0013\t#\u0003\u0003\u0003$\u0005\u001d%AB(cU\u0016\u001cG\u000f")
public class DateFormatClass
extends BinaryExpression
implements TimestampFormatterHelper,
ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression left;
    private final Expression right;
    private final Option<String> timeZoneId;
    private transient Option<TimestampFormatter> formatterOption;
    private boolean resolved;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return DateFormatClass$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<String>>> unapply(DateFormatClass dateFormatClass) {
        return DateFormatClass$.MODULE$.unapply(dateFormatClass);
    }

    public static Option<String> apply$default$3() {
        return DateFormatClass$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, DateFormatClass> tupled() {
        return DateFormatClass$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, DateFormatClass>>> curried() {
        return DateFormatClass$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public final TimestampFormatter getFormatter(String fmt) {
        return TimestampFormatterHelper.getFormatter$(this, fmt);
    }

    private Option<TimestampFormatter> formatterOption$lzycompute() {
        DateFormatClass dateFormatClass = this;
        synchronized (dateFormatClass) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.formatterOption = TimestampFormatterHelper.formatterOption$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.formatterOption;
    }

    @Override
    public final Option<TimestampFormatter> formatterOption() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.formatterOption$lzycompute() : this.formatterOption;
    }

    private boolean resolved$lzycompute() {
        DateFormatClass dateFormatClass = this;
        synchronized (dateFormatClass) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private ZoneId zoneId$lzycompute() {
        DateFormatClass dateFormatClass = this;
        synchronized (dateFormatClass) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{TimestampType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object timestamp, Object format) {
        TimestampFormatter formatter = (TimestampFormatter)this.formatterOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.getFormatter(format.toString()));
        return UTF8String.fromString((String)formatter.format(BoxesRunTime.unboxToLong((Object)timestamp)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return (ExprCode)this.formatterOption().map((Function1 & Serializable & scala.Serializable)tf -> {
            String timestampFormatter = ctx.addReferenceObj("timestampFormatter", tf, ctx.addReferenceObj$default$3());
            return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(timestamp, x$1) -> new StringBuilder(32).append("UTF8String.fromString(").append(timestampFormatter).append(".format(").append((String)timestamp).append("))").toString());
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String tf = new StringOps(Predef$.MODULE$.augmentString(TimestampFormatter$.MODULE$.getClass().getName())).stripSuffix("$");
            String ldf = new StringOps(Predef$.MODULE$.augmentString(LegacyDateFormats$.MODULE$.getClass().getName())).stripSuffix("$");
            String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
            return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(timestamp, format) -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(177).append("|UTF8String.fromString(").append(tf).append("$.MODULE$.apply(\n            |  ").append((String)format).append(".toString(),\n            |  ").append(zid).append(",\n            |  ").append(ldf).append("$.MODULE$.SIMPLE_DATE_FORMAT(),\n            |  false)\n            |.format(").append((String)timestamp).append("))").toString())).stripMargin());
        });
    }

    @Override
    public String prettyName() {
        return "date_format";
    }

    @Override
    public Expression formatString() {
        return this.right();
    }

    @Override
    public boolean isParsing() {
        return false;
    }

    public DateFormatClass copy(Expression left, Expression right, Option<String> timeZoneId) {
        return new DateFormatClass(left, right, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "DateFormatClass";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Option<String> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.left();
                break;
            }
            case 1: {
                option = this.right();
                break;
            }
            case 2: {
                option = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DateFormatClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DateFormatClass)) return false;
        boolean bl = true;
        if (!bl) return false;
        DateFormatClass dateFormatClass = (DateFormatClass)x$1;
        Expression expression = this.left();
        Expression expression2 = dateFormatClass.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = dateFormatClass.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = dateFormatClass.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!dateFormatClass.canEqual(this)) return false;
        return true;
    }

    public DateFormatClass(Expression left, Expression right, Option<String> timeZoneId) {
        this.left = left;
        this.right = right;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        TimestampFormatterHelper.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public DateFormatClass(Expression left, Expression right) {
        this(left, right, (Option<String>)None$.MODULE$);
    }
}

