/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.DatePart$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(field, source) - Extracts a part of the date/timestamp or interval source.", arguments="\n    Arguments:\n      * field - selects which part of the source should be extracted, and supported string values are as same as the fields of the equivalent function `EXTRACT`.\n      * source - a date/timestamp or interval column from where `field` should be extracted\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('YEAR', TIMESTAMP '2019-08-12 01:00:00.123456');\n       2019\n      > SELECT _FUNC_('week', timestamp'2019-08-12 01:00:00.123456');\n       33\n      > SELECT _FUNC_('doy', DATE'2019-08-12');\n       224\n      > SELECT _FUNC_('SECONDS', timestamp'2019-10-01 00:00:01.000001');\n       1.000001\n      > SELECT _FUNC_('days', interval 1 year 10 months 5 days);\n       5\n      > SELECT _FUNC_('seconds', interval 5 hours 30 seconds 1 milliseconds 1 microseconds);\n       30.001001\n  ", note="\n    The _FUNC_ function is equivalent to the SQL-standard function `EXTRACT(field FROM source)`\n  ", group="datetime_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005=w!\u0002\u0010 \u0011\u0003ac!\u0002\u0018 \u0011\u0003y\u0003\"B\u001d\u0002\t\u0003Q\u0004\"B\u001e\u0002\t\u0003a\u0004\"B,\u0002\t\u0003A\u0006b\u0002/\u0002\u0003\u0003%\t)\u0018\u0005\n\u0003c\u000b\u0011\u0011!CA\u0003gC\u0011\"!2\u0002\u0003\u0003%I!a2\u0007\t9z\u0002i\u0018\u0005\t5\"\u0011)\u001a!C\u0001S\"A!\u000e\u0003B\tB\u0003%Q\b\u0003\u0005O\u0011\tU\r\u0011\"\u0001j\u0011!Y\u0007B!E!\u0002\u0013i\u0004\u0002\u00037\t\u0005+\u0007I\u0011A5\t\u00115D!\u0011#Q\u0001\nuBQ!\u000f\u0005\u0005\u00029DQ!\u000f\u0005\u0005\u0002IDQ!\u001e\u0005\u0005BYDq!a\u0002\t\t\u0003\nI\u0001C\u0004\u0002\u0012!!\t%a\u0005\t\u0013\u0005U\u0001\"!A\u0005\u0002\u0005]\u0001\"CA\u0010\u0011E\u0005I\u0011AA\u0011\u0011%\t9\u0004CI\u0001\n\u0003\t\t\u0003C\u0005\u0002:!\t\n\u0011\"\u0001\u0002\"!I\u00111\b\u0005\u0002\u0002\u0013\u0005\u0013Q\b\u0005\n\u0003\u001bB\u0011\u0011!C\u0001\u0003\u001fB\u0011\"a\u0016\t\u0003\u0003%\t!!\u0017\t\u0013\u0005}\u0003\"!A\u0005B\u0005\u0005\u0004\"CA7\u0011\u0005\u0005I\u0011AA8\u0011%\tI\bCA\u0001\n\u0003\nY(\u0001\u0005ECR,\u0007+\u0019:u\u0015\t\u0001\u0013%A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0012$\u0003!\u0019\u0017\r^1msN$(B\u0001\u0013&\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003M\u001d\nQa\u001d9be.T!\u0001K\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0013aA8sO\u000e\u0001\u0001CA\u0017\u0002\u001b\u0005y\"\u0001\u0003#bi\u0016\u0004\u0016M\u001d;\u0014\u0007\u0005\u0001d\u0007\u0005\u00022i5\t!GC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$G\u0001\u0004B]f\u0014VM\u001a\t\u0003c]J!\u0001\u000f\u001a\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u0005a\u0013!\u00059beN,W\t\u001f;sC\u000e$h)[3mIR!Q\bQ'P!\tic(\u0003\u0002@?\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u000b\u0005\u001b\u0001\u0019\u0001\"\u0002\u0019\u0015DHO]1di\u001aKW\r\u001c3\u0011\u0005\rSeB\u0001#I!\t)%'D\u0001G\u0015\t95&\u0001\u0004=e>|GOP\u0005\u0003\u0013J\na\u0001\u0015:fI\u00164\u0017BA&M\u0005\u0019\u0019FO]5oO*\u0011\u0011J\r\u0005\u0006\u001d\u000e\u0001\r!P\u0001\u0007g>,(oY3\t\rA\u001bA\u00111\u0001R\u0003=)'O]8s\u0011\u0006tG\r\\3Gk:\u001c\u0007cA\u0019S)&\u00111K\r\u0002\ty\tLh.Y7f}A\u0011\u0011'V\u0005\u0003-J\u0012qAT8uQ&tw-\u0001\tu_\u0016\u000bX/\u001b<bY\u0016tG/\u0012=qeR\u0019Q(W.\t\u000bi#\u0001\u0019A\u001f\u0002\u000b\u0019LW\r\u001c3\t\u000b9#\u0001\u0019A\u001f\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fy\u000bY+!,\u00020B\u0011Q\u0006C\n\u0006\u0011\u0001\u001cgM\u000e\t\u0003[\u0005L!AY\u0010\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"!\f3\n\u0005\u0015|\"A\u0005*v]RLW.\u001a*fa2\f7-Z1cY\u0016\u0004\"!M4\n\u0005!\u0014$a\u0002)s_\u0012,8\r^\u000b\u0002{\u00051a-[3mI\u0002\nqa]8ve\u000e,\u0007%A\u0003dQ&dG-\u0001\u0004dQ&dG\r\t\u000b\u0005=>\u0004\u0018\u000fC\u0003[\u001f\u0001\u0007Q\bC\u0003O\u001f\u0001\u0007Q\bC\u0003m\u001f\u0001\u0007Q\bF\u0002_gRDQA\u0017\tA\u0002uBQA\u0014\tA\u0002u\nQB\u001a7bi\u0006\u0013x-^7f]R\u001cX#A<\u0011\tal\u0018\u0011\u0001\b\u0003snt!!\u0012>\n\u0003MJ!\u0001 \u001a\u0002\u000fA\f7m[1hK&\u0011ap \u0002\t\u0013R,'/\u0019;pe*\u0011AP\r\t\u0004c\u0005\r\u0011bAA\u0003e\t\u0019\u0011I\\=\u0002\u001b\u0015D\bO]:SKBd\u0017mY3e+\t\tY\u0001\u0005\u0003y\u0003\u001bi\u0014bAA\b\u007f\n\u00191+Z9\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001C\u0003\u0011\u0019w\u000e]=\u0015\u000fy\u000bI\"a\u0007\u0002\u001e!9!\f\u0006I\u0001\u0002\u0004i\u0004b\u0002(\u0015!\u0003\u0005\r!\u0010\u0005\bYR\u0001\n\u00111\u0001>\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\t+\u0007u\n)c\u000b\u0002\u0002(A!\u0011\u0011FA\u001a\u001b\t\tYC\u0003\u0003\u0002.\u0005=\u0012!C;oG\",7m[3e\u0015\r\t\tDM\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u001b\u0003W\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u007f\u0001B!!\u0011\u0002L5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%\u0001\u0003mC:<'BAA%\u0003\u0011Q\u0017M^1\n\u0007-\u000b\u0019%\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002RA\u0019\u0011'a\u0015\n\u0007\u0005U#GA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0002\u0005m\u0003\"CA/5\u0005\u0005\t\u0019AA)\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\r\t\u0007\u0003K\nY'!\u0001\u000e\u0005\u0005\u001d$bAA5e\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0007y\f9'\u0001\u0005dC:,\u0015/^1m)\u0011\t\t(a\u001e\u0011\u0007E\n\u0019(C\u0002\u0002vI\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002^q\t\t\u00111\u0001\u0002\u0002\u00051Q-];bYN$B!!\u001d\u0002~!I\u0011QL\u000f\u0002\u0002\u0003\u0007\u0011\u0011\u0001\u0015\u001c\u0011\u0005\u0005\u0015qQAE\u0003\u001b\u000by)a%\u0002\u0016\u0006e\u00151TAP\u0003C\u000b)+a*\u0011\u00075\n\u0019)C\u0002\u0002\u0006~\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\f\u0006\tvLR+O\u0007~Cc-[3mI2\u00023o\\;sG\u0016L\u0003%\f\u0011FqR\u0014\u0018m\u0019;tA\u0005\u0004\u0003/\u0019:uA=4\u0007\u0005\u001e5fA\u0011\fG/Z\u0018uS6,7\u000f^1na\u0002z'\u000fI5oi\u0016\u0014h/\u00197!g>,(oY3/\u0003%\t'oZ;nK:$8/\t\u0002\u0002\u0012\u0006\u0011\tC\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!M&,G\u000e\u001a\u0011.AM,G.Z2ug\u0002:\b.[2iAA\f'\u000f\u001e\u0011pM\u0002\"\b.\u001a\u0011t_V\u00148-\u001a\u0011tQ>,H\u000e\u001a\u0011cK\u0002*\u0007\u0010\u001e:bGR,G\r\f\u0011b]\u0012\u00043/\u001e9q_J$X\r\u001a\u0011tiJLgn\u001a\u0011wC2,Xm\u001d\u0011be\u0016\u0004\u0013m\u001d\u0011tC6,\u0007%Y:!i\",\u0007EZ5fY\u0012\u001c\be\u001c4!i\",\u0007%Z9vSZ\fG.\u001a8uA\u0019,hn\u0019;j_:\u0004\u0003-\u0012-U%\u0006\u001bE\u000b\u0019\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+AM|WO]2fA5\u0002\u0013\r\t3bi\u0016|C/[7fgR\fW\u000e\u001d\u0011pe\u0002Jg\u000e^3sm\u0006d\u0007eY8mk6t\u0007E\u001a:p[\u0002:\b.\u001a:fA\u00014\u0017.\u001a7eA\u0002\u001a\bn\\;mI\u0002\u0012W\rI3yiJ\f7\r^3e\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005]\u0015\u0001\"\u0001\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dJV)\u0011*(Y\u0001\"\u0016*T#T)\u0006k\u0005\u000bI\u00143aEJT\u0006\r\u001d.cI\u0002\u0003'\r\u001e1ai\u0002\u0004GL\u00193gQ*dgJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0014'\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O],Wm[\u0014-AQLW.Z:uC6\u0004xE\r\u00192s5\u0002\u0004(L\u00193AA\n$\b\r\u0019;aAr\u0013GM\u001a5kY:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00114g)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005Z8zO1\u0002C)\u0011+FOI\u0002\u0014'O\u00171q5\n$gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0012DG\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015('\u0016\u001buJ\u0014#TO1\u0002C/[7fgR\fW\u000e]\u00143aEJT&\r\u0019.aE\u0002\u0003\u0007\r\u001e1ai\u0002\u0014G\f\u00191aA\u0002\u0014gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AEr\u0003\u0007\r\u00191aER\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n3bsN<C\u0006I5oi\u0016\u0014h/\u00197!c\u0001JX-\u0019:!cA\u0002Sn\u001c8uQN\u0004S\u0007\t3bsNL3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001b\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u001aXmY8oIN<C\u0006I5oi\u0016\u0014h/\u00197!k\u0001Bw.\u001e:tAM\u0002\u0004e]3d_:$7\u000fI\u0019![&dG.[:fG>tGm\u001d\u00112A5L7M]8tK\u000e|g\u000eZ:*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a\u0004G\f\u00191cA\u0002\u0014G\u0003\u0011!\u0003\u0011qw\u000e^3\"\u0005\u0005u\u0015a\u0019\u0006!A\u0001\u0002C\u000b[3!?\u001a+fjQ0!MVt7\r^5p]\u0002J7\u000fI3rk&4\u0018\r\\3oi\u0002\"x\u000e\t;iK\u0002\u001a\u0016\u000bT\u0017ti\u0006tG-\u0019:eA\u0019,hn\u0019;j_:\u0004\u0003-\u0012-U%\u0006\u001bE\u000b\u000b4jK2$\u0007E\u0012*P\u001b\u0002\u001ax.\u001e:dK&\u0002'\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005\r\u0016A\u00043bi\u0016$\u0018.\\3`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003S\u000bQa\r\u00181]ABQAW\u0003A\u0002uBQAT\u0003A\u0002uBQ\u0001\\\u0003A\u0002u\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u00026\u0006\u0005\u0007#B\u0019\u00028\u0006m\u0016bAA]e\t1q\n\u001d;j_:\u0004b!MA_{uj\u0014bAA`e\t1A+\u001e9mKNB\u0001\"a1\u0007\u0003\u0003\u0005\rAX\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!3\u0011\t\u0005\u0005\u00131Z\u0005\u0005\u0003\u001b\f\u0019E\u0001\u0004PE*,7\r\u001e")
public class DatePart
extends UnaryExpression
implements RuntimeReplaceable,
Serializable {
    private final Expression field;
    private final Expression source;
    private final Expression child;
    private Expression canonicalized;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(DatePart datePart) {
        return DatePart$.MODULE$.unapply(datePart);
    }

    public static Expression toEquivalentExpr(Expression expression, Expression expression2) {
        return DatePart$.MODULE$.toEquivalentExpr(expression, expression2);
    }

    public static Expression parseExtractField(String string, Expression expression, Function0<Nothing$> function0) {
        return DatePart$.MODULE$.parseExtractField(string, expression, function0);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public String sql() {
        return RuntimeReplaceable.sql$(this);
    }

    @Override
    public String mkString(Seq<String> childrenString) {
        return RuntimeReplaceable.mkString$(this, childrenString);
    }

    @Override
    public final boolean foldable() {
        return Unevaluable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    private Expression canonicalized$lzycompute() {
        DatePart datePart = this;
        synchronized (datePart) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return !this.bitmap$0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    public Expression field() {
        return this.field;
    }

    public Expression source() {
        return this.source;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.field(), this.source()}));
    }

    @Override
    public Seq<Expression> exprsReplaced() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.field(), this.source()}));
    }

    @Override
    public String prettyName() {
        return "date_part";
    }

    public DatePart copy(Expression field, Expression source, Expression child) {
        return new DatePart(field, source, child);
    }

    public Expression copy$default$1() {
        return this.field();
    }

    public Expression copy$default$2() {
        return this.source();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "DatePart";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.field();
                break;
            }
            case 1: {
                expression = this.source();
                break;
            }
            case 2: {
                expression = this.child();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DatePart;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DatePart)) return false;
        boolean bl = true;
        if (!bl) return false;
        DatePart datePart = (DatePart)x$1;
        Expression expression = this.field();
        Expression expression2 = datePart.field();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.source();
        Expression expression4 = datePart.source();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.child();
        Expression expression6 = datePart.child();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!datePart.canEqual(this)) return false;
        return true;
    }

    public DatePart(Expression field, Expression source, Expression child) {
        this.field = field;
        this.source = source;
        this.child = child;
        Unevaluable.$init$(this);
        RuntimeReplaceable.$init$(this);
    }

    public DatePart(Expression field, Expression source) {
        this(field, source, DatePart$.MODULE$.toEquivalentExpr(field, source));
    }
}

