/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Size$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(expr) - Returns the size of an array or a map.\n    The function returns null for null input if spark.sql.legacy.sizeOfNull is set to false or\n    spark.sql.ansi.enabled is set to true. Otherwise, the function returns -1 for null input.\n    With the default settings, the function returns -1 for null input.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array('b', 'd', 'c', 'a'));\n       4\n      > SELECT _FUNC_(map('a', 1, 'b', 2));\n       2\n      > SELECT _FUNC_(NULL);\n       -1\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001\u0002\u000f\u001e\u0001*B\u0001b\u000f\u0001\u0003\u0016\u0004%\t\u0001\u0010\u0005\t\u0001\u0002\u0011\t\u0012)A\u0005{!A\u0011\t\u0001BK\u0002\u0013\u0005!\t\u0003\u0005G\u0001\tE\t\u0015!\u0003D\u0011\u00159\u0005\u0001\"\u0001I\u0011\u00159\u0005\u0001\"\u0001M\u0011\u0015q\u0005\u0001\"\u0011P\u0011\u00151\u0006\u0001\"\u0011X\u0011\u00159\u0007\u0001\"\u0011C\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u0015\u0019\b\u0001\"\u0011u\u0011%\t)\u0001AA\u0001\n\u0003\t9\u0001C\u0005\u0002\u000e\u0001\t\n\u0011\"\u0001\u0002\u0010!I\u0011Q\u0005\u0001\u0012\u0002\u0013\u0005\u0011q\u0005\u0005\n\u0003W\u0001\u0011\u0011!C!\u0003[A\u0011\"a\u0010\u0001\u0003\u0003%\t!!\u0011\t\u0013\u0005%\u0003!!A\u0005\u0002\u0005-\u0003\"CA)\u0001\u0005\u0005I\u0011IA*\u0011%\t\t\u0007AA\u0001\n\u0003\t\u0019\u0007C\u0005\u0002h\u0001\t\t\u0011\"\u0011\u0002j\u001d9\u0011qQ\u000f\t\u0002\u0005%eA\u0002\u000f\u001e\u0011\u0003\tY\t\u0003\u0004H-\u0011\u0005\u00111\u0013\u0005\b\u0003+3B\u0011AAL\u0011%\t)JFA\u0001\n\u0003\u000bY\nC\u0005\u0002\"Z\t\t\u0011\"!\u0002$\"I\u0011Q\u0017\f\u0002\u0002\u0013%\u0011q\u0017\u0002\u0005'&TXM\u0003\u0002\u001f?\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0001\u0013%\u0001\u0005dCR\fG._:u\u0015\t\u00113%A\u0002tc2T!\u0001J\u0013\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0019:\u0013AB1qC\u000eDWMC\u0001)\u0003\ry'oZ\u0002\u0001'\u0015\u00011f\f\u001a9!\taS&D\u0001\u001e\u0013\tqSDA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\ta\u0003'\u0003\u00022;\t\tR\t\u001f9fGR\u001c\u0018J\u001c9viRK\b/Z:\u0011\u0005M2T\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\u000fA\u0013x\u000eZ;diB\u00111'O\u0005\u0003uQ\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fQa\u00195jY\u0012,\u0012!\u0010\t\u0003YyJ!aP\u000f\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004dQ&dG\rI\u0001\u0011Y\u0016<\u0017mY=TSj,wJ\u001a(vY2,\u0012a\u0011\t\u0003g\u0011K!!\u0012\u001b\u0003\u000f\t{w\u000e\\3b]\u0006\tB.Z4bGf\u001c\u0016N_3PM:+H\u000e\u001c\u0011\u0002\rqJg.\u001b;?)\rI%j\u0013\t\u0003Y\u0001AQaO\u0003A\u0002uBQ!Q\u0003A\u0002\r#\"!S'\t\u000bm2\u0001\u0019A\u001f\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012\u0001\u0015\t\u0003#Rk\u0011A\u0015\u0006\u0003'\u0006\nQ\u0001^=qKNL!!\u0016*\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005A\u0006cA-bI:\u0011!l\u0018\b\u00037zk\u0011\u0001\u0018\u0006\u0003;&\na\u0001\u0010:p_Rt\u0014\"A\u001b\n\u0005\u0001$\u0014a\u00029bG.\fw-Z\u0005\u0003E\u000e\u00141aU3r\u0015\t\u0001G\u0007\u0005\u0002RK&\u0011aM\u0015\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f\u0001B\\;mY\u0006\u0014G.Z\u0001\u0005KZ\fG\u000e\u0006\u0002k[B\u00111g[\u0005\u0003YR\u00121!\u00118z\u0011\u001dq'\u0002%AA\u0002=\fQ!\u001b8qkR\u0004\"\u0001]9\u000e\u0003}I!A]\u0010\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\nI><UM\\\"pI\u0016$B!^>\u0002\u0002A\u0011a/_\u0007\u0002o*\u0011\u00010H\u0001\bG>$WmZ3o\u0013\tQxO\u0001\u0005FqB\u00148i\u001c3f\u0011\u0015a8\u00021\u0001~\u0003\r\u0019G\u000f\u001f\t\u0003mzL!a`<\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"1\u00111A\u0006A\u0002U\f!!\u001a<\u0002\t\r|\u0007/\u001f\u000b\u0006\u0013\u0006%\u00111\u0002\u0005\bw1\u0001\n\u00111\u0001>\u0011\u001d\tE\u0002%AA\u0002\r\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0012)\u001aQ(a\u0005,\u0005\u0005U\u0001\u0003BA\f\u0003Ci!!!\u0007\u000b\t\u0005m\u0011QD\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\b5\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003G\tIBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002*)\u001a1)a\u0005\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\u0003\u0005\u0003\u00022\u0005mRBAA\u001a\u0015\u0011\t)$a\u000e\u0002\t1\fgn\u001a\u0006\u0003\u0003s\tAA[1wC&!\u0011QHA\u001a\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\t\t\u0004g\u0005\u0015\u0013bAA$i\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019!.!\u0014\t\u0013\u0005=\u0013#!AA\u0002\u0005\r\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002VA)\u0011qKA/U6\u0011\u0011\u0011\f\u0006\u0004\u00037\"\u0014AC2pY2,7\r^5p]&!\u0011qLA-\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007\r\u000b)\u0007\u0003\u0005\u0002PM\t\t\u00111\u0001k\u0003\u0019)\u0017/^1mgR\u00191)a\u001b\t\u0011\u0005=C#!AA\u0002)Ds\u0002AA8\u0003k\n9(a\u001f\u0002~\u0005\u0005\u00151\u0011\t\u0004Y\u0005E\u0014bAA:;\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA=\u0003\t\r%\u0002\t\u0011!A}3UKT\"`Q\u0015D\bO]\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!g&TX\rI8gA\u0005t\u0007%\u0019:sCf\u0004sN\u001d\u0011bA5\f\u0007O\f\u0006!A\u0001\u0002C\u000b[3!MVt7\r^5p]\u0002\u0012X\r^;s]N\u0004c.\u001e7mA\u0019|'\u000f\t8vY2\u0004\u0013N\u001c9vi\u0002Jg\rI:qCJ\\gf]9m]1,w-Y2z]ML'0Z(g\u001dVdG\u000eI5tAM,G\u000f\t;pA\u0019\fGn]3!_JT\u0001\u0005\t\u0011!gB\f'o\u001b\u0018tc2t\u0013M\\:j]\u0015t\u0017M\u00197fI\u0002J7\u000fI:fi\u0002\"x\u000e\t;sk\u0016t\u0003e\u0014;iKJ<\u0018n]3-AQDW\r\t4v]\u000e$\u0018n\u001c8!e\u0016$XO\u001d8tA5\n\u0004EZ8sA9,H\u000e\u001c\u0011j]B,HO\f\u0006!A\u0001\u0002s+\u001b;iAQDW\r\t3fM\u0006,H\u000e\u001e\u0011tKR$\u0018N\\4tY\u0001\"\b.\u001a\u0011gk:\u001cG/[8oAI,G/\u001e:og\u0002j\u0013\u0007\t4pe\u0002rW\u000f\u001c7!S:\u0004X\u000f\u001e\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003\u007f\n\u0011\u0011\u000b\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u0015(E\u001eb\u0003e\n3(Y\u0001:3m\n\u0017!O\u0005<\u0013&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!i)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CS.\u00199)O\u0005<C\u0006I\u0019-A\u001d\u0012w\u0005\f\u00113S%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)\u001dVcE*K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011![ER\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003\u000b\u000bQ!\r\u00186]A\nAaU5{KB\u0011AFF\n\u0005-\u00055\u0005\bE\u00024\u0003\u001fK1!!%5\u0005\u0019\te.\u001f*fMR\u0011\u0011\u0011R\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u0013\u0006e\u0005\"B\u001e\u0019\u0001\u0004iD#B%\u0002\u001e\u0006}\u0005\"B\u001e\u001a\u0001\u0004i\u0004\"B!\u001a\u0001\u0004\u0019\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003K\u000b\t\fE\u00034\u0003O\u000bY+C\u0002\u0002*R\u0012aa\u00149uS>t\u0007#B\u001a\u0002.v\u001a\u0015bAAXi\t1A+\u001e9mKJB\u0001\"a-\u001b\u0003\u0003\u0005\r!S\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!/\u0011\t\u0005E\u00121X\u0005\u0005\u0003{\u000b\u0019D\u0001\u0004PE*,7\r\u001e")
public class Size
extends UnaryExpression
implements ExpectsInputTypes,
scala.Serializable {
    private final Expression child;
    private final boolean legacySizeOfNull;

    public static Option<Tuple2<Expression, Object>> unapply(Size size) {
        return Size$.MODULE$.unapply(size);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean legacySizeOfNull() {
        return this.legacySizeOfNull;
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{ArrayType$.MODULE$, MapType$.MODULE$}))}));
    }

    @Override
    public boolean nullable() {
        return this.legacySizeOfNull() ? false : super.nullable();
    }

    @Override
    public Object eval(InternalRow input) {
        Integer n;
        Object value = this.child().eval(input);
        if (value == null) {
            n = this.legacySizeOfNull() ? BoxesRunTime.boxToInteger((int)-1) : null;
        } else {
            Integer n2;
            DataType dataType = this.child().dataType();
            if (dataType instanceof ArrayType) {
                n2 = BoxesRunTime.boxToInteger((int)((ArrayData)value).numElements());
            } else if (dataType instanceof MapType) {
                n2 = BoxesRunTime.boxToInteger((int)((MapData)value).numElements());
            } else {
                throw new UnsupportedOperationException(new StringBuilder(51).append("The size function doesn't support the operand type ").append(dataType.getClass().getCanonicalName()).toString());
            }
            n = n2;
        }
        return n;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        if (this.legacySizeOfNull()) {
            ExprCode childGen = this.child().genCode(ctx);
            exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      boolean ", " = false;\n      ", "\n      ", " ", " = ", " ? -1 :\n        (", ").numElements();"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), childGen.code(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), childGen.isNull(), childGen.value()})), FalseLiteral$.MODULE$, ev.copy$default$3());
        } else {
            exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(16).append("(").append((String)c).append(").numElements()").toString());
        }
        return exprCode;
    }

    public Size copy(Expression child, boolean legacySizeOfNull) {
        return new Size(child, legacySizeOfNull);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.legacySizeOfNull();
    }

    @Override
    public String productPrefix() {
        return "Size";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.legacySizeOfNull());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Size;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Size)) return false;
        boolean bl = true;
        if (!bl) return false;
        Size size = (Size)x$1;
        Expression expression = this.child();
        Expression expression2 = size.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.legacySizeOfNull() != size.legacySizeOfNull()) return false;
        if (!size.canEqual(this)) return false;
        return true;
    }

    public Size(Expression child, boolean legacySizeOfNull) {
        this.child = child;
        this.legacySizeOfNull = legacySizeOfNull;
        ExpectsInputTypes.$init$(this);
    }

    public Size(Expression child) {
        this(child, SQLConf$.MODULE$.get().legacySizeOfNull());
    }
}

