/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringReplace$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, search[, replace]) - Replaces all occurrences of `search` with `replace`.", arguments="\n    Arguments:\n      * str - a string expression\n      * search - a string expression. If `search` is not found in `str`, `str` is returned unchanged.\n      * replace - a string expression. If `replace` is not specified or is an empty string, nothing replaces\n          the string that is removed from `str`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('ABCabc', 'abc', 'DEF');\n       ABCDEF\n  ", since="2.3.0")
@ScalaSignature(bytes="\u0006\u0001\u0005]h\u0001\u0002\u0011\"\u0001:B\u0001B\u0012\u0001\u0003\u0016\u0004%\ta\u0012\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005\u0011\"AA\n\u0001BK\u0002\u0013\u0005q\t\u0003\u0005N\u0001\tE\t\u0015!\u0003I\u0011!q\u0005A!f\u0001\n\u00039\u0005\u0002C(\u0001\u0005#\u0005\u000b\u0011\u0002%\t\u000bA\u0003A\u0011A)\t\u000bA\u0003A\u0011\u0001,\t\u000be\u0003A\u0011\t.\t\u000b\u0011\u0004A\u0011I3\t\u000bM\u0004A\u0011\t;\t\u000bm\u0004A\u0011\t?\t\u000f\u0005E\u0001\u0001\"\u0011\u0002\u0014!9\u0011q\u0003\u0001\u0005B\u0005e\u0001\"CA\u0016\u0001\u0005\u0005I\u0011AA\u0017\u0011%\t)\u0004AI\u0001\n\u0003\t9\u0004C\u0005\u0002N\u0001\t\n\u0011\"\u0001\u00028!I\u0011q\n\u0001\u0012\u0002\u0013\u0005\u0011q\u0007\u0005\n\u0003#\u0002\u0011\u0011!C!\u0003'B\u0011\"a\u0019\u0001\u0003\u0003%\t!!\u001a\t\u0013\u00055\u0004!!A\u0005\u0002\u0005=\u0004\"CA;\u0001\u0005\u0005I\u0011IA<\u0011%\t)\tAA\u0001\n\u0003\t9\tC\u0005\u0002\u0012\u0002\t\t\u0011\"\u0011\u0002\u0014\u001eI\u0011qW\u0011\u0002\u0002#\u0005\u0011\u0011\u0018\u0004\tA\u0005\n\t\u0011#\u0001\u0002<\"1\u0001K\u0007C\u0001\u0003\u0013D\u0011\"a3\u001b\u0003\u0003%)%!4\t\u0013\u0005='$!A\u0005\u0002\u0006E\u0007\"CAm5\u0005\u0005I\u0011QAn\u0011%\tiOGA\u0001\n\u0013\tyOA\u0007TiJLgn\u001a*fa2\f7-\u001a\u0006\u0003E\r\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011A%J\u0001\tG\u0006$\u0018\r\\=ti*\u0011aeJ\u0001\u0004gFd'B\u0001\u0015*\u0003\u0015\u0019\b/\u0019:l\u0015\tQ3&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Y\u0005\u0019qN]4\u0004\u0001M1\u0001aL\u001a7{\r\u0003\"\u0001M\u0019\u000e\u0003\u0005J!AM\u0011\u0003#Q+'O\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00021i%\u0011Q'\t\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011qG\u000f\b\u0003aaJ!!O\u0011\u0002\u000fA\f7m[1hK&\u00111\b\u0010\u0002\u000f\u001dVdG.\u00138u_2,'/\u00198u\u0015\tI\u0014\u0005\u0005\u0002?\u00036\tqHC\u0001A\u0003\u0015\u00198-\u00197b\u0013\t\u0011uHA\u0004Qe>$Wo\u0019;\u0011\u0005y\"\u0015BA#@\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u001d\u0019(oY#yaJ,\u0012\u0001\u0013\t\u0003a%K!AS\u0011\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0005te\u000e,\u0005\u0010\u001d:!\u0003)\u0019X-\u0019:dQ\u0016C\bO]\u0001\fg\u0016\f'o\u00195FqB\u0014\b%A\u0006sKBd\u0017mY3FqB\u0014\u0018\u0001\u0004:fa2\f7-Z#yaJ\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003S'R+\u0006C\u0001\u0019\u0001\u0011\u00151u\u00011\u0001I\u0011\u0015au\u00011\u0001I\u0011\u0015qu\u00011\u0001I)\r\u0011v\u000b\u0017\u0005\u0006\r\"\u0001\r\u0001\u0013\u0005\u0006\u0019\"\u0001\r\u0001S\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u00057z\u0003'\r\u0005\u0002?9&\u0011Ql\u0010\u0002\u0004\u0003:L\b\"B0\n\u0001\u0004Y\u0016aB:sG\u00163\u0018\r\u001c\u0005\u0006C&\u0001\raW\u0001\u000bg\u0016\f'o\u00195Fm\u0006d\u0007\"B2\n\u0001\u0004Y\u0016a\u0003:fa2\f7-Z#wC2\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u0007\u0019d\u0017\u000f\u0005\u0002hU6\t\u0001N\u0003\u0002jC\u000591m\u001c3fO\u0016t\u0017BA6i\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"B7\u000b\u0001\u0004q\u0017aA2uqB\u0011qm\\\u0005\u0003a\"\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0003s\u0015\u0001\u0007a-\u0001\u0002fm\u0006AA-\u0019;b)f\u0004X-F\u0001v!\t1\u00180D\u0001x\u0015\tAX%A\u0003usB,7/\u0003\u0002{o\nAA)\u0019;b)f\u0004X-\u0001\u0006j]B,H\u000fV=qKN,\u0012! \t\u0005}\u0006-QOD\u0002\u0000\u0003\u0013qA!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000bi\u0013A\u0002\u001fs_>$h(C\u0001A\u0013\tIt(\u0003\u0003\u0002\u000e\u0005=!aA*fc*\u0011\u0011hP\u0001\tG\"LG\u000e\u001a:f]V\u0011\u0011Q\u0003\t\u0005}\u0006-\u0001*\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!a\u0007\u0011\t\u0005u\u0011Q\u0005\b\u0005\u0003?\t\t\u0003E\u0002\u0002\u0002}J1!a\t@\u0003\u0019\u0001&/\u001a3fM&!\u0011qEA\u0015\u0005\u0019\u0019FO]5oO*\u0019\u00111E \u0002\t\r|\u0007/\u001f\u000b\b%\u0006=\u0012\u0011GA\u001a\u0011\u001d1u\u0002%AA\u0002!Cq\u0001T\b\u0011\u0002\u0003\u0007\u0001\nC\u0004O\u001fA\u0005\t\u0019\u0001%\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\b\u0016\u0004\u0011\u0006m2FAA\u001f!\u0011\ty$!\u0013\u000e\u0005\u0005\u0005#\u0002BA\"\u0003\u000b\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001ds(\u0001\u0006b]:|G/\u0019;j_:LA!a\u0013\u0002B\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002VA!\u0011qKA1\u001b\t\tIF\u0003\u0003\u0002\\\u0005u\u0013\u0001\u00027b]\u001eT!!a\u0018\u0002\t)\fg/Y\u0005\u0005\u0003O\tI&\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002hA\u0019a(!\u001b\n\u0007\u0005-tHA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002\\\u0003cB\u0011\"a\u001d\u0016\u0003\u0003\u0005\r!a\u001a\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\bE\u0003\u0002|\u0005\u00055,\u0004\u0002\u0002~)\u0019\u0011qP \u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0004\u0006u$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!#\u0002\u0010B\u0019a(a#\n\u0007\u00055uHA\u0004C_>dW-\u00198\t\u0011\u0005Mt#!AA\u0002m\u000ba!Z9vC2\u001cH\u0003BAE\u0003+C\u0001\"a\u001d\u0019\u0003\u0003\u0005\ra\u0017\u0015\u0014\u0001\u0005e\u0015qTAQ\u0003K\u000b9+a+\u0002.\u0006E\u00161\u0017\t\u0004a\u0005m\u0015bAAOC\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAR\u0003U{f)\u0016(D?\"\u001aHO\u001d\u0017!g\u0016\f'o\u00195\\Y\u0001\u0012X\r\u001d7bG\u0016l\u0016\u0006I\u0017!%\u0016\u0004H.Y2fg\u0002\nG\u000e\u001c\u0011pG\u000e,(O]3oG\u0016\u001c\be\u001c4!AN,\u0017M]2iA\u0002:\u0018\u000e\u001e5!AJ,\u0007\u000f\\1dK\u0002t\u0013!C1sOVlWM\u001c;tC\t\tI+\u0001B9\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u00023\u000f\u001e:![\u0001\n\u0007e\u001d;sS:<\u0007%\u001a=qe\u0016\u001c8/[8o\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u001aX-\u0019:dQ\u0002j\u0003%\u0019\u0011tiJLgn\u001a\u0011fqB\u0014Xm]:j_:t\u0003%\u00134!AN,\u0017M]2iA\u0002J7\u000f\t8pi\u00022w.\u001e8eA%t\u0007\u0005Y:ue\u0002d\u0003\u0005Y:ue\u0002\u0004\u0013n\u001d\u0011sKR,(O\\3eAUt7\r[1oO\u0016$gF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011sKBd\u0017mY3![\u0001\n\u0007e\u001d;sS:<\u0007%\u001a=qe\u0016\u001c8/[8o]\u0001Je\r\t1sKBd\u0017mY3aA%\u001c\bE\\8uAM\u0004XmY5gS\u0016$\u0007e\u001c:!SN\u0004\u0013M\u001c\u0011f[B$\u0018\u0010I:ue&tw\r\f\u0011o_RD\u0017N\\4!e\u0016\u0004H.Y2fg*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t;iK\u0002\u001aHO]5oO\u0002\"\b.\u0019;!SN\u0004#/Z7pm\u0016$\u0007E\u001a:p[\u0002\u00027\u000f\u001e:a])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ty+\u0001(\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n%iQ1cG\u001eb\u0003eJ1cG\u001eb\u0003e\n#F\r\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I!C\u0007\u0012+eI\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t),A\u00033]Mr\u0003'A\u0007TiJLgn\u001a*fa2\f7-\u001a\t\u0003ai\u0019BAGA_\u0007BA\u0011qXAc\u0011\"C%+\u0004\u0002\u0002B*\u0019\u00111Y \u0002\u000fI,h\u000e^5nK&!\u0011qYAa\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0003s\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003+\nQ!\u00199qYf$rAUAj\u0003+\f9\u000eC\u0003G;\u0001\u0007\u0001\nC\u0003M;\u0001\u0007\u0001\nC\u0003O;\u0001\u0007\u0001*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005u\u0017\u0011\u001e\t\u0006}\u0005}\u00171]\u0005\u0004\u0003C|$AB(qi&|g\u000e\u0005\u0004?\u0003KD\u0005\nS\u0005\u0004\u0003O|$A\u0002+va2,7\u0007\u0003\u0005\u0002lz\t\t\u00111\u0001S\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002rB!\u0011qKAz\u0013\u0011\t)0!\u0017\u0003\r=\u0013'.Z2u\u0001")
public class StringReplace
extends TernaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression srcExpr;
    private final Expression searchExpr;
    private final Expression replaceExpr;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringReplace stringReplace) {
        return StringReplace$.MODULE$.unapply(stringReplace);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringReplace> tupled() {
        return StringReplace$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringReplace>>> curried() {
        return StringReplace$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression srcExpr() {
        return this.srcExpr;
    }

    public Expression searchExpr() {
        return this.searchExpr;
    }

    public Expression replaceExpr() {
        return this.replaceExpr;
    }

    @Override
    public Object nullSafeEval(Object srcEval, Object searchEval, Object replaceEval) {
        return ((UTF8String)srcEval).replace((UTF8String)searchEval, (UTF8String)replaceEval);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(src, search, replace) -> new StringBuilder(16).append(ev.value()).append(" = ").append((String)src).append(".replace(").append((String)search).append(", ").append((String)replace).append(");").toString());
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.srcExpr();
        Expression expression2 = this.searchExpr();
        Expression expression3 = this.replaceExpr();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public String prettyName() {
        return "replace";
    }

    public StringReplace copy(Expression srcExpr, Expression searchExpr, Expression replaceExpr) {
        return new StringReplace(srcExpr, searchExpr, replaceExpr);
    }

    public Expression copy$default$1() {
        return this.srcExpr();
    }

    public Expression copy$default$2() {
        return this.searchExpr();
    }

    public Expression copy$default$3() {
        return this.replaceExpr();
    }

    @Override
    public String productPrefix() {
        return "StringReplace";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.srcExpr();
                break;
            }
            case 1: {
                expression = this.searchExpr();
                break;
            }
            case 2: {
                expression = this.replaceExpr();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringReplace;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringReplace)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringReplace stringReplace = (StringReplace)x$1;
        Expression expression = this.srcExpr();
        Expression expression2 = stringReplace.srcExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.searchExpr();
        Expression expression4 = stringReplace.searchExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.replaceExpr();
        Expression expression6 = stringReplace.replaceExpr();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringReplace.canEqual(this)) return false;
        return true;
    }

    public StringReplace(Expression srcExpr, Expression searchExpr, Expression replaceExpr) {
        this.srcExpr = srcExpr;
        this.searchExpr = searchExpr;
        this.replaceExpr = replaceExpr;
        ExpectsInputTypes.$init$(this);
    }

    public StringReplace(Expression srcExpr, Expression searchExpr) {
        this(srcExpr, searchExpr, Literal$.MODULE$.apply(""));
    }
}

