/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringSplit$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, regex, limit) - Splits `str` around occurrences that match `regex` and returns an array with a length of at most `limit`", arguments="\n    Arguments:\n      * str - a string expression to split.\n      * regex - a string representing a regular expression. The regex string should be a\n        Java regular expression.\n      * limit - an integer expression which controls the number of times the regex is applied.\n          * limit > 0: The resulting array's length will not be more than `limit`,\n            and the resulting array's last entry will contain all input\n            beyond the last matched regex.\n          * limit <= 0: `regex` will be applied as many times as possible, and\n            the resulting array can be of any size.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('oneAtwoBthreeC', '[ABC]');\n       [\"one\",\"two\",\"three\",\"\"]\n      > SELECT _FUNC_('oneAtwoBthreeC', '[ABC]', -1);\n       [\"one\",\"two\",\"three\",\"\"]\n      > SELECT _FUNC_('oneAtwoBthreeC', '[ABC]', 2);\n       [\"one\",\"twoBthreeC\"]\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Uh\u0001\u0002\u0011\"\u0001:B\u0001B\u0012\u0001\u0003\u0016\u0004%\ta\u0012\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005\u0011\"AA\n\u0001BK\u0002\u0013\u0005q\t\u0003\u0005N\u0001\tE\t\u0015!\u0003I\u0011!q\u0005A!f\u0001\n\u00039\u0005\u0002C(\u0001\u0005#\u0005\u000b\u0011\u0002%\t\u000bA\u0003A\u0011A)\t\u000bY\u0003A\u0011I,\t\u000by\u0003A\u0011I0\t\u000b-\u0004A\u0011\t7\t\u000bA\u0003A\u0011\u00018\t\u000bI\u0004A\u0011I:\t\u000bm\u0004A\u0011\t?\t\u000f\u0005U\u0001\u0001\"\u0011\u0002\u0018!I\u0011\u0011\u0006\u0001\u0002\u0002\u0013\u0005\u00111\u0006\u0005\n\u0003g\u0001\u0011\u0013!C\u0001\u0003kA\u0011\"a\u0013\u0001#\u0003%\t!!\u000e\t\u0013\u00055\u0003!%A\u0005\u0002\u0005U\u0002\"CA(\u0001\u0005\u0005I\u0011IA)\u0011%\t\t\u0007AA\u0001\n\u0003\t\u0019\u0007C\u0005\u0002l\u0001\t\t\u0011\"\u0001\u0002n!I\u00111\u000f\u0001\u0002\u0002\u0013\u0005\u0013Q\u000f\u0005\n\u0003\u0007\u0003\u0011\u0011!C\u0001\u0003\u000bC\u0011\"a$\u0001\u0003\u0003%\t%!%\b\u0013\u0005U\u0016%!A\t\u0002\u0005]f\u0001\u0003\u0011\"\u0003\u0003E\t!!/\t\rASB\u0011AAd\u0011%\tIMGA\u0001\n\u000b\nY\rC\u0005\u0002Nj\t\t\u0011\"!\u0002P\"I\u0011q\u001b\u000e\u0002\u0002\u0013\u0005\u0015\u0011\u001c\u0005\n\u0003WT\u0012\u0011!C\u0005\u0003[\u00141b\u0015;sS:<7\u000b\u001d7ji*\u0011!eI\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002%K\u0005A1-\u0019;bYf\u001cHO\u0003\u0002'O\u0005\u00191/\u001d7\u000b\u0005!J\u0013!B:qCJ\\'B\u0001\u0016,\u0003\u0019\t\u0007/Y2iK*\tA&A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001_M2Th\u0011\t\u0003aEj\u0011!I\u0005\u0003e\u0005\u0012\u0011\u0003V3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\u0001D'\u0003\u00026C\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u00028u9\u0011\u0001\u0007O\u0005\u0003s\u0005\nq\u0001]1dW\u0006<W-\u0003\u0002<y\tqa*\u001e7m\u0013:$x\u000e\\3sC:$(BA\u001d\"!\tq\u0014)D\u0001@\u0015\u0005\u0001\u0015!B:dC2\f\u0017B\u0001\"@\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u0010#\n\u0005\u0015{$\u0001D*fe&\fG.\u001b>bE2,\u0017aA:ueV\t\u0001\n\u0005\u00021\u0013&\u0011!*\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017\u0001B:ue\u0002\nQA]3hKb\faA]3hKb\u0004\u0013!\u00027j[&$\u0018A\u00027j[&$\b%\u0001\u0004=S:LGO\u0010\u000b\u0005%N#V\u000b\u0005\u00021\u0001!)ai\u0002a\u0001\u0011\")Aj\u0002a\u0001\u0011\")aj\u0002a\u0001\u0011\u0006AA-\u0019;b)f\u0004X-F\u0001Y!\tIF,D\u0001[\u0015\tYV%A\u0003usB,7/\u0003\u0002^5\nAA)\u0019;b)f\u0004X-\u0001\u0006j]B,H\u000fV=qKN,\u0012\u0001\u0019\t\u0004C\"DfB\u00012h\u001d\t\u0019g-D\u0001e\u0015\t)W&\u0001\u0004=e>|GOP\u0005\u0002\u0001&\u0011\u0011hP\u0005\u0003S*\u00141aU3r\u0015\tIt(\u0001\u0005dQ&dGM]3o+\u0005i\u0007cA1i\u0011R\u0019!k\\9\t\u000bA\\\u0001\u0019\u0001%\u0002\u0007\u0015D\b\u000fC\u0003M\u0017\u0001\u0007\u0001*\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0003uofT\bC\u0001 v\u0013\t1xHA\u0002B]fDQ\u0001\u001f\u0007A\u0002Q\faa\u001d;sS:<\u0007\"\u0002'\r\u0001\u0004!\b\"\u0002(\r\u0001\u0004!\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0015i\u0018qAA\t!\rq\u00181A\u0007\u0002\u007f*\u0019\u0011\u0011A\u0011\u0002\u000f\r|G-Z4f]&\u0019\u0011QA@\u0003\u0011\u0015C\bO]\"pI\u0016Dq!!\u0003\u000e\u0001\u0004\tY!A\u0002dib\u00042A`A\u0007\u0013\r\tya \u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0019\t\u0019\"\u0004a\u0001{\u0006\u0011QM^\u0001\u000baJ,G\u000f^=OC6,WCAA\r!\u0011\tY\"a\t\u000f\t\u0005u\u0011q\u0004\t\u0003G~J1!!\t@\u0003\u0019\u0001&/\u001a3fM&!\u0011QEA\u0014\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011E \u0002\t\r|\u0007/\u001f\u000b\b%\u00065\u0012qFA\u0019\u0011\u001d1u\u0002%AA\u0002!Cq\u0001T\b\u0011\u0002\u0003\u0007\u0001\nC\u0004O\u001fA\u0005\t\u0019\u0001%\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0007\u0016\u0004\u0011\u0006e2FAA\u001e!\u0011\ti$a\u0012\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015s(\u0001\u0006b]:|G/\u0019;j_:LA!!\u0013\u0002@\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002TA!\u0011QKA0\u001b\t\t9F\u0003\u0003\u0002Z\u0005m\u0013\u0001\u00027b]\u001eT!!!\u0018\u0002\t)\fg/Y\u0005\u0005\u0003K\t9&\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002fA\u0019a(a\u001a\n\u0007\u0005%tHA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002u\u0003_B\u0011\"!\u001d\u0016\u0003\u0003\u0005\r!!\u001a\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t9\bE\u0003\u0002z\u0005}D/\u0004\u0002\u0002|)\u0019\u0011QP \u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0002\u0006m$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\"\u0002\u000eB\u0019a(!#\n\u0007\u0005-uHA\u0004C_>dW-\u00198\t\u0011\u0005Et#!AA\u0002Q\fa!Z9vC2\u001cH\u0003BAD\u0003'C\u0001\"!\u001d\u0019\u0003\u0003\u0005\r\u0001\u001e\u0015\u0014\u0001\u0005]\u0015QTAP\u0003G\u000b)+!+\u0002,\u0006=\u0016\u0011\u0017\t\u0004a\u0005e\u0015bAANC\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAQ\u0003\u0005%qLR+O\u0007~C3\u000f\u001e:-AI,w-\u001a=-A1LW.\u001b;*A5\u00023\u000b\u001d7jiN\u0004\u0003m\u001d;sA\u0002\n'o\\;oI\u0002z7mY;se\u0016t7-Z:!i\"\fG\u000fI7bi\u000eD\u0007\u0005\u0019:fO\u0016D\b\rI1oI\u0002\u0012X\r^;s]N\u0004\u0013M\u001c\u0011beJ\f\u0017\u0010I<ji\"\u0004\u0013\r\t7f]\u001e$\b\u000eI8gA\u0005$\b%\\8ti\u0002\u0002G.[7ji\u0002\f\u0011\"\u0019:hk6,g\u000e^:\"\u0005\u0005\u001d\u0016\u0001\"1\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u001aHO\u001d\u0011.A\u0005\u00043\u000f\u001e:j]\u001e\u0004S\r\u001f9sKN\u001c\u0018n\u001c8!i>\u00043\u000f\u001d7ji:R\u0001\u0005\t\u0011!A\u0001R\u0003E]3hKb\u0004S\u0006I1!gR\u0014\u0018N\\4!e\u0016\u0004(/Z:f]RLgn\u001a\u0011bAI,w-\u001e7be\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0018!)\",\u0007E]3hKb\u00043\u000f\u001e:j]\u001e\u00043\u000f[8vY\u0012\u0004#-\u001a\u0011b\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001R\u0015M^1!e\u0016<W\u000f\\1sA\u0015D\bO]3tg&|gN\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!Y&l\u0017\u000e\u001e\u0011.A\u0005t\u0007%\u001b8uK\u001e,'\u000fI3yaJ,7o]5p]\u0002:\b.[2iA\r|g\u000e\u001e:pYN\u0004C\u000f[3!]Vl'-\u001a:!_\u001a\u0004C/[7fg\u0002\"\b.\u001a\u0011sK\u001e,\u0007\u0010I5tA\u0005\u0004\b\u000f\\5fI:R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011+A1LW.\u001b;!}\u0001\u0002$\b\t+iK\u0002\u0012Xm];mi&tw\rI1se\u0006Lxe\u001d\u0011mK:<G\u000f\u001b\u0011xS2d\u0007E\\8uA\t,\u0007%\\8sK\u0002\"\b.\u00198!A2LW.\u001b;aY)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!C:$\u0007\u0005\u001e5fAI,7/\u001e7uS:<\u0007%\u0019:sCf<3\u000f\t7bgR\u0004SM\u001c;ss\u0002:\u0018\u000e\u001c7!G>tG/Y5oA\u0005dG\u000eI5oaV$(\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0012W-_8oI\u0002\"\b.\u001a\u0011mCN$\b%\\1uG\",G\r\t:fO\u0016DhF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A)\u0002C.[7ji\u0002bT\b\t\u0019;A\u0001\u0014XmZ3yA\u0002:\u0018\u000e\u001c7!E\u0016\u0004\u0013\r\u001d9mS\u0016$\u0007%Y:![\u0006t\u0017\u0010\t;j[\u0016\u001c\b%Y:!a>\u001c8/\u001b2mK2\u0002\u0013M\u001c3\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t;iK\u0002\u0012Xm];mi&tw\rI1se\u0006L\beY1oA\t,\u0007e\u001c4!C:L\be]5{K:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011QV\u0001\u0003\u0016)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cse\u001c8f\u0003R<xN\u0011;ie\u0016,7i\n\u0017!Om\u000b%iQ/(SmR\u0001\u0005\t\u0011!A\u0001\u00023LI8oK\nb#\u0005^<pE1\u0012C\u000f\u001b:fK\nb#EI/\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dzg.Z!uo>\u0014E\u000f\u001b:fK\u000e;C\u0006I\u0014\\\u0003\n\u001bUl\n\u0017![EJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.#_:,'\u0005\f\u0012uo>\u0014CF\t;ie\u0016,'\u0005\f\u0012#;*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cse\u001c8f\u0003R<xN\u0011;ie\u0016,7i\n\u0017!Om\u000b%iQ/(Y\u0001\u0012\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\E=tWM\t\u0017#i^|'\t\u001e5sK\u0016\u001c%%\u0018\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u00111W\u0001\u0006c9*d\u0006M\u0001\f'R\u0014\u0018N\\4Ta2LG\u000f\u0005\u000215M!!$a/D!!\ti,a1I\u0011\"\u0013VBAA`\u0015\r\t\tmP\u0001\beVtG/[7f\u0013\u0011\t)-a0\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0006\u0002\u00028\u0006AAo\\*ue&tw\r\u0006\u0002\u0002T\u0005)\u0011\r\u001d9msR9!+!5\u0002T\u0006U\u0007\"\u0002$\u001e\u0001\u0004A\u0005\"\u0002'\u001e\u0001\u0004A\u0005\"\u0002(\u001e\u0001\u0004A\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u00037\f9\u000fE\u0003?\u0003;\f\t/C\u0002\u0002`~\u0012aa\u00149uS>t\u0007C\u0002 \u0002d\"C\u0005*C\u0002\u0002f~\u0012a\u0001V;qY\u0016\u001c\u0004\u0002CAu=\u0005\u0005\t\u0019\u0001*\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAAx!\u0011\t)&!=\n\t\u0005M\u0018q\u000b\u0002\u0007\u001f\nTWm\u0019;")
public class StringSplit
extends TernaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression str;
    private final Expression regex;
    private final Expression limit;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringSplit stringSplit) {
        return StringSplit$.MODULE$.unapply(stringSplit);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringSplit> tupled() {
        return StringSplit$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringSplit>>> curried() {
        return StringSplit$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression regex() {
        return this.regex;
    }

    public Expression limit() {
        return this.limit;
    }

    @Override
    public DataType dataType() {
        return ArrayType$.MODULE$.apply(StringType$.MODULE$);
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, StringType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.str();
        Expression expression2 = this.regex();
        Expression expression3 = this.limit();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public Object nullSafeEval(Object string, Object regex, Object limit) {
        UTF8String[] strings = ((UTF8String)string).split((UTF8String)regex, BoxesRunTime.unboxToInt((Object)limit));
        return new GenericArrayData(strings);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String arrayClass = GenericArrayData.class.getName();
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(str, regex, limit) -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(19).append(ev.value()).append(" = new ").append(arrayClass).append("(").append((String)str).append(".split(").append((String)regex).append(",").append((String)limit).append("));").toString())).stripMargin());
    }

    @Override
    public String prettyName() {
        return "split";
    }

    public StringSplit copy(Expression str, Expression regex, Expression limit) {
        return new StringSplit(str, regex, limit);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.regex();
    }

    public Expression copy$default$3() {
        return this.limit();
    }

    @Override
    public String productPrefix() {
        return "StringSplit";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.str();
                break;
            }
            case 1: {
                expression = this.regex();
                break;
            }
            case 2: {
                expression = this.limit();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringSplit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringSplit)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringSplit stringSplit = (StringSplit)x$1;
        Expression expression = this.str();
        Expression expression2 = stringSplit.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regex();
        Expression expression4 = stringSplit.regex();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.limit();
        Expression expression6 = stringSplit.limit();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringSplit.canEqual(this)) return false;
        return true;
    }

    public StringSplit(Expression str, Expression regex, Expression limit) {
        this.str = str;
        this.regex = regex;
        this.limit = limit;
        ExpectsInputTypes.$init$(this);
    }

    public StringSplit(Expression exp, Expression regex) {
        this(exp, regex, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)-1)));
    }
}

