/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Substring$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.ByteArray;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, pos[, len]) - Returns the substring of `str` that starts at `pos` and is of length `len`, or the slice of byte array that starts at `pos` and is of length `len`.\n\n    _FUNC_(str FROM pos[ FOR len]]) - Returns the substring of `str` that starts at `pos` and is of length `len`, or the slice of byte array that starts at `pos` and is of length `len`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL', 5);\n       k SQL\n      > SELECT _FUNC_('Spark SQL', -3);\n       SQL\n      > SELECT _FUNC_('Spark SQL', 5, 1);\n       k\n      > SELECT _FUNC_('Spark SQL' FROM 5);\n       k SQL\n      > SELECT _FUNC_('Spark SQL' FROM -3);\n       SQL\n      > SELECT _FUNC_('Spark SQL' FROM 5 FOR 1);\n       k\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005}g\u0001B\u0010!\u00016B\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u000f\"A1\n\u0001BK\u0002\u0013\u0005a\t\u0003\u0005M\u0001\tE\t\u0015!\u0003H\u0011!i\u0005A!f\u0001\n\u00031\u0005\u0002\u0003(\u0001\u0005#\u0005\u000b\u0011B$\t\u000b=\u0003A\u0011\u0001)\t\u000b=\u0003A\u0011A+\t\u000ba\u0003A\u0011I-\t\u000b\u0001\u0004A\u0011I1\t\u000bA\u0004A\u0011I9\t\u000bM\u0004A\u0011\t;\t\u000bq\u0004A\u0011I?\t\u0013\u0005]\u0001!!A\u0005\u0002\u0005e\u0001\"CA\u0011\u0001E\u0005I\u0011AA\u0012\u0011%\tI\u0004AI\u0001\n\u0003\t\u0019\u0003C\u0005\u0002<\u0001\t\n\u0011\"\u0001\u0002$!I\u0011Q\b\u0001\u0002\u0002\u0013\u0005\u0013q\b\u0005\n\u0003#\u0002\u0011\u0011!C\u0001\u0003'B\u0011\"a\u0017\u0001\u0003\u0003%\t!!\u0018\t\u0013\u0005\r\u0004!!A\u0005B\u0005\u0015\u0004\"CA:\u0001\u0005\u0005I\u0011AA;\u0011%\ty\bAA\u0001\n\u0003\n\tiB\u0005\u0002 \u0002\n\t\u0011#\u0001\u0002\"\u001aAq\u0004IA\u0001\u0012\u0003\t\u0019\u000b\u0003\u0004P3\u0011\u0005\u0011\u0011\u0017\u0005\n\u0003gK\u0012\u0011!C#\u0003kC\u0011\"a.\u001a\u0003\u0003%\t)!/\t\u0013\u0005\u0005\u0017$!A\u0005\u0002\u0006\r\u0007\"CAk3\u0005\u0005I\u0011BAl\u0005%\u0019VOY:ue&twM\u0003\u0002\"E\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0019C%\u0001\u0005dCR\fG._:u\u0015\t)c%A\u0002tc2T!a\n\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005%R\u0013AB1qC\u000eDWMC\u0001,\u0003\ry'oZ\u0002\u0001'\u0019\u0001aFM\u001b=\u0005B\u0011q\u0006M\u0007\u0002A%\u0011\u0011\u0007\t\u0002\u0012)\u0016\u0014h.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u00184\u0013\t!\u0004E\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\t1\u0014H\u0004\u00020o%\u0011\u0001\bI\u0001\ba\u0006\u001c7.Y4f\u0013\tQ4H\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005a\u0002\u0003CA\u001fA\u001b\u0005q$\"A \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005s$a\u0002)s_\u0012,8\r\u001e\t\u0003{\rK!\u0001\u0012 \u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0007M$(/F\u0001H!\ty\u0003*\u0003\u0002JA\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\tM$(\u000fI\u0001\u0004a>\u001c\u0018\u0001\u00029pg\u0002\n1\u0001\\3o\u0003\u0011aWM\u001c\u0011\u0002\rqJg.\u001b;?)\u0011\t&k\u0015+\u0011\u0005=\u0002\u0001\"B#\b\u0001\u00049\u0005\"B&\b\u0001\u00049\u0005\"B'\b\u0001\u00049EcA)W/\")Q\t\u0003a\u0001\u000f\")1\n\u0003a\u0001\u000f\u0006AA-\u0019;b)f\u0004X-F\u0001[!\tYf,D\u0001]\u0015\tiF%A\u0003usB,7/\u0003\u0002`9\nAA)\u0019;b)f\u0004X-\u0001\u0006j]B,H\u000fV=qKN,\u0012A\u0019\t\u0004G*lgB\u00013j\u001d\t)\u0007.D\u0001g\u0015\t9G&\u0001\u0004=e>|GOP\u0005\u0002\u007f%\u0011\u0001HP\u0005\u0003W2\u00141aU3r\u0015\tAd\b\u0005\u0002\\]&\u0011q\u000e\u0018\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0002eB\u00191M[$\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\tUD(p\u001f\t\u0003{YL!a\u001e \u0003\u0007\u0005s\u0017\u0010C\u0003z\u0019\u0001\u0007Q/\u0001\u0004tiJLgn\u001a\u0005\u0006\u00172\u0001\r!\u001e\u0005\u0006\u001b2\u0001\r!^\u0001\nI><UM\\\"pI\u0016$RA`A\u0005\u0003'\u00012a`A\u0003\u001b\t\t\tAC\u0002\u0002\u0004\u0001\nqaY8eK\u001e,g.\u0003\u0003\u0002\b\u0005\u0005!\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005-Q\u00021\u0001\u0002\u000e\u0005\u00191\r\u001e=\u0011\u0007}\fy!\u0003\u0003\u0002\u0012\u0005\u0005!AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003+i\u0001\u0019\u0001@\u0002\u0005\u00154\u0018\u0001B2paf$r!UA\u000e\u0003;\ty\u0002C\u0004F\u001dA\u0005\t\u0019A$\t\u000f-s\u0001\u0013!a\u0001\u000f\"9QJ\u0004I\u0001\u0002\u00049\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003KQ3aRA\u0014W\t\tI\u0003\u0005\u0003\u0002,\u0005URBAA\u0017\u0015\u0011\ty#!\r\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001a}\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0012Q\u0006\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\t\t\u0005\u0003\u0007\ni%\u0004\u0002\u0002F)!\u0011qIA%\u0003\u0011a\u0017M\\4\u000b\u0005\u0005-\u0013\u0001\u00026bm\u0006LA!a\u0014\u0002F\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0016\u0011\u0007u\n9&C\u0002\u0002Zy\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2!^A0\u0011%\t\t\u0007FA\u0001\u0002\u0004\t)&A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003O\u0002R!!\u001b\u0002pUl!!a\u001b\u000b\u0007\u00055d(\u0001\u0006d_2dWm\u0019;j_:LA!!\u001d\u0002l\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t9(! \u0011\u0007u\nI(C\u0002\u0002|y\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002bY\t\t\u00111\u0001v\u0003\u0019)\u0017/^1mgR!\u0011qOAB\u0011!\t\tgFA\u0001\u0002\u0004)\bf\u0004\u0001\u0002\b\u00065\u0015qRAJ\u0003+\u000bI*a'\u0011\u0007=\nI)C\u0002\u0002\f\u0002\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u0012\u0006\u0011\tO\u0003\u0011!A\u0001zf)\u0016(D?\"\u001aHO\u001d\u0017!a>\u001c8\f\f\u0011mK:l\u0016\u0006I\u0017!%\u0016$XO\u001d8tAQDW\rI:vEN$(/\u001b8hA=4\u0007\u0005Y:ue\u0002\u0004C\u000f[1uAM$\u0018M\u001d;tA\u0005$\b\u0005\u00199pg\u0002\u0004\u0013M\u001c3!SN\u0004sN\u001a\u0011mK:<G\u000f\u001b\u0011aY\u0016t\u0007\r\f\u0011pe\u0002\"\b.\u001a\u0011tY&\u001cW\rI8gA\tLH/\u001a\u0011beJ\f\u0017\u0010\t;iCR\u00043\u000f^1siN\u0004\u0013\r\u001e\u0011aa>\u001c\b\rI1oI\u0002J7\u000fI8gA1,gn\u001a;iA\u0001dWM\u001c1/\u0015)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015tiJ\u0004cIU(NAA|7o\u0017\u0011G\u001fJ\u0003C.\u001a8^;&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u00043/\u001e2tiJLgn\u001a\u0011pM\u0002\u00027\u000f\u001e:aAQD\u0017\r\u001e\u0011ti\u0006\u0014Ho\u001d\u0011bi\u0002\u0002\u0007o\\:aA\u0005tG\rI5tA=4\u0007\u0005\\3oORD\u0007\u0005\u00197f]\u0002d\u0003e\u001c:!i\",\u0007e\u001d7jG\u0016\u0004sN\u001a\u0011csR,\u0007%\u0019:sCf\u0004C\u000f[1uAM$\u0018M\u001d;tA\u0005$\b\u0005\u00199pg\u0002\u0004\u0013M\u001c3!SN\u0004sN\u001a\u0011mK:<G\u000f\u001b\u0011aY\u0016t\u0007M\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002\u0018\u0006\u0011IK\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015('B\f'o\u001b\u0011T#2;C\u0006I\u001b*w)\u0001\u0003\u0005\t\u0011!A\u0001Z\u0007eU)M\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":3\u000b]1sW\u0002\u001a\u0016\u000bT\u0014-A5\u001a\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011T#2S\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ*qCJ\\\u0007eU)MO1\u0002S\u0007\f\u00112SmR\u0001\u0005\t\u0011!A\u0001\u00023N\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015('B\f'o\u001b\u0011T#2;\u0003E\u0012*P\u001b\u0002*\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011lAM\u000bFJ\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015('B\f'o\u001b\u0011T#2;\u0003E\u0012*P\u001b\u0002j3'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!'Fc%\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014Ta\u0006\u00148\u000eI*R\u0019\u001e\u0002cIU(NAU\u0002ci\u0014*!c%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u001b\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011QT\u0001\u0006c9*d\u0006M\u0001\n'V\u00147\u000f\u001e:j]\u001e\u0004\"aL\r\u0014\te\t)K\u0011\t\t\u0003O\u000bikR$H#6\u0011\u0011\u0011\u0016\u0006\u0004\u0003Ws\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003_\u000bIKA\tBEN$(/Y2u\rVt7\r^5p]N\"\"!!)\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fE\u000bY,!0\u0002@\")Q\t\ba\u0001\u000f\")1\n\ba\u0001\u000f\")Q\n\ba\u0001\u000f\u00069QO\\1qa2LH\u0003BAc\u0003#\u0004R!PAd\u0003\u0017L1!!3?\u0005\u0019y\u0005\u000f^5p]B1Q(!4H\u000f\u001eK1!a4?\u0005\u0019!V\u000f\u001d7fg!A\u00111[\u000f\u0002\u0002\u0003\u0007\u0011+A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u001c\t\u0005\u0003\u0007\nY.\u0003\u0003\u0002^\u0006\u0015#AB(cU\u0016\u001cG\u000f")
public class Substring
extends TernaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression str;
    private final Expression pos;
    private final Expression len;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(Substring substring) {
        return Substring$.MODULE$.unapply(substring);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, Substring> tupled() {
        return Substring$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Substring>>> curried() {
        return Substring$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression pos() {
        return this.pos;
    }

    public Expression len() {
        return this.len;
    }

    @Override
    public DataType dataType() {
        return this.str().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringType$.MODULE$, BinaryType$.MODULE$})), IntegerType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.str();
        Expression expression2 = this.pos();
        Expression expression3 = this.len();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public Object nullSafeEval(Object string, Object pos, Object len) {
        Object object;
        DataType dataType = this.str().dataType();
        if (StringType$.MODULE$.equals(dataType)) {
            object = ((UTF8String)string).substringSQL(BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)len));
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            object = ByteArray.subStringSQL((byte[])((byte[])string), (int)BoxesRunTime.unboxToInt((Object)pos), (int)BoxesRunTime.unboxToInt((Object)len));
        } else {
            throw new MatchError((Object)dataType);
        }
        return object;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(string, pos, len) -> {
            String string2;
            DataType dataType = this.str().dataType();
            if (StringType$.MODULE$.equals(dataType)) {
                string2 = new StringBuilder(17).append((String)string).append(".substringSQL(").append((String)pos).append(", ").append((String)len).append(")").toString();
            } else if (BinaryType$.MODULE$.equals(dataType)) {
                string2 = new StringBuilder(19).append(ByteArray.class.getName()).append(".subStringSQL(").append((String)string).append(", ").append((String)pos).append(", ").append((String)len).append(")").toString();
            } else {
                throw new MatchError((Object)dataType);
            }
            return string2;
        });
    }

    public Substring copy(Expression str, Expression pos, Expression len) {
        return new Substring(str, pos, len);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.pos();
    }

    public Expression copy$default$3() {
        return this.len();
    }

    @Override
    public String productPrefix() {
        return "Substring";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.str();
                break;
            }
            case 1: {
                expression = this.pos();
                break;
            }
            case 2: {
                expression = this.len();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Substring;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Substring)) return false;
        boolean bl = true;
        if (!bl) return false;
        Substring substring = (Substring)x$1;
        Expression expression = this.str();
        Expression expression2 = substring.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.pos();
        Expression expression4 = substring.pos();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.len();
        Expression expression6 = substring.len();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!substring.canEqual(this)) return false;
        return true;
    }

    public Substring(Expression str, Expression pos, Expression len) {
        this.str = str;
        this.pos = pos;
        this.len = len;
        ExpectsInputTypes.$init$(this);
    }

    public Substring(Expression str, Expression pos) {
        this(str, pos, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)));
    }
}

