/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the negated value of `expr`.", examples="\n    Examples:\n      > SELECT _FUNC_(1);\n       -1\n  ", since="1.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005=h\u0001\u0002\u0011\"\u0001:B\u0001B\u0012\u0001\u0003\u0016\u0004%\ta\u0012\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005\u0011\"AA\n\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005R\u0001\tE\t\u0015!\u0003O\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u0015\u0011\u0006\u0001\"\u0001X\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u0015a\u0007\u0001\"\u0011n\u0011\u0015\t\b\u0001\"\u0011s\u0011!Y\b\u0001#b\u0001\n\u0013a\bbBA\u0004\u0001\u0011\u0005\u0013\u0011\u0002\u0005\b\u0003K\u0001A\u0011KA\u0014\u0011\u00191\u0003\u0001\"\u0011\u0002.!I\u0011q\u0006\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0007\u0005\n\u0003o\u0001\u0011\u0013!C\u0001\u0003sA\u0011\"a\u0014\u0001#\u0003%\t!!\u0015\t\u0013\u0005U\u0003!!A\u0005B\u0005]\u0003\"CA4\u0001\u0005\u0005I\u0011AA5\u0011%\t\t\bAA\u0001\n\u0003\t\u0019\bC\u0005\u0002z\u0001\t\t\u0011\"\u0011\u0002|!I\u0011\u0011\u0012\u0001\u0002\u0002\u0013\u0005\u00111\u0012\u0005\n\u0003\u001f\u0003\u0011\u0011!C!\u0003#;\u0011\"a,\"\u0003\u0003E\t!!-\u0007\u0011\u0001\n\u0013\u0011!E\u0001\u0003gCaA\u0015\r\u0005\u0002\u0005\u0005\u0007\u0002C9\u0019\u0003\u0003%)%a1\t\u0013\u0005\u0015\u0007$!A\u0005\u0002\u0006\u001d\u0007\"CAg1E\u0005I\u0011AA)\u0011%\ty\rGA\u0001\n\u0003\u000b\t\u000eC\u0005\u0002db\t\n\u0011\"\u0001\u0002R!I\u0011Q\u001d\r\u0002\u0002\u0013%\u0011q\u001d\u0002\u000b+:\f'/_'j]V\u001c(B\u0001\u0012$\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0011*\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0019:\u0013aA:rY*\u0011\u0001&K\u0001\u0006gB\f'o\u001b\u0006\u0003U-\na!\u00199bG\",'\"\u0001\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001y3GN\u001fD!\t\u0001\u0014'D\u0001\"\u0013\t\u0011\u0014EA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\u0001D'\u0003\u00026C\t\tR\t\u001f9fGR\u001c\u0018J\u001c9viRK\b/Z:\u0011\u0005]RdB\u0001\u00199\u0013\tI\u0014%A\u0004qC\u000e\\\u0017mZ3\n\u0005mb$A\u0004(vY2Le\u000e^8mKJ\fg\u000e\u001e\u0006\u0003s\u0005\u0002\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002?\t&\u0011Qi\u0010\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0006G\"LG\u000eZ\u000b\u0002\u0011B\u0011\u0001'S\u0005\u0003\u0015\u0006\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019\u0019\u0007.\u001b7eA\u0005Ya-Y5m\u001f:,%O]8s+\u0005q\u0005C\u0001 P\u0013\t\u0001vHA\u0004C_>dW-\u00198\u0002\u0019\u0019\f\u0017\u000e\\(o\u000bJ\u0014xN\u001d\u0011\u0002\rqJg.\u001b;?)\r!VK\u0016\t\u0003a\u0001AQAR\u0003A\u0002!Cq\u0001T\u0003\u0011\u0002\u0003\u0007a\n\u0006\u0002U1\")aI\u0002a\u0001\u0011\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003m\u00032\u0001X2g\u001d\ti&M\u0004\u0002_C6\tqL\u0003\u0002a[\u00051AH]8pizJ\u0011\u0001Q\u0005\u0003s}J!\u0001Z3\u0003\u0007M+\u0017O\u0003\u0002:\u007fA\u0011qM[\u0007\u0002Q*\u0011\u0011.J\u0001\u0006if\u0004Xm]\u0005\u0003W\"\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012A\u001c\t\u0003O>L!\u0001\u001d5\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002gB\u0011A\u000f\u001f\b\u0003kZ\u0004\"AX \n\u0005]|\u0014A\u0002)sK\u0012,g-\u0003\u0002zu\n11\u000b\u001e:j]\u001eT!a^ \u0002\u000f9,X.\u001a:jGV\tQ\u0010\u0005\u0003]}\u0006\u0005\u0011BA@f\u0005\u001dqU/\\3sS\u000e\u00042APA\u0002\u0013\r\t)a\u0010\u0002\u0004\u0003:L\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0019\tY!a\u0006\u0002\"A!\u0011QBA\n\u001b\t\tyAC\u0002\u0002\u0012\u0005\nqaY8eK\u001e,g.\u0003\u0003\u0002\u0016\u0005=!\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005e1\u00021\u0001\u0002\u001c\u0005\u00191\r\u001e=\u0011\t\u00055\u0011QD\u0005\u0005\u0003?\tyA\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005\r2\u00021\u0001\u0002\f\u0005\u0011QM^\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0005\u0003\u0003\tI\u0003C\u0004\u0002,1\u0001\r!!\u0001\u0002\u000b%t\u0007/\u001e;\u0016\u0003M\fAaY8qsR)A+a\r\u00026!9aI\u0004I\u0001\u0002\u0004A\u0005b\u0002'\u000f!\u0003\u0005\rAT\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tYDK\u0002I\u0003{Y#!a\u0010\u0011\t\u0005\u0005\u00131J\u0007\u0003\u0003\u0007RA!!\u0012\u0002H\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0013z\u0014AC1o]>$\u0018\r^5p]&!\u0011QJA\"\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t\u0019FK\u0002O\u0003{\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA-!\u0011\tY&!\u001a\u000e\u0005\u0005u#\u0002BA0\u0003C\nA\u0001\\1oO*\u0011\u00111M\u0001\u0005U\u00064\u0018-C\u0002z\u0003;\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u001b\u0011\u0007y\ni'C\u0002\u0002p}\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0001\u0002v!I\u0011qO\n\u0002\u0002\u0003\u0007\u00111N\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005u\u0004CBA@\u0003\u000b\u000b\t!\u0004\u0002\u0002\u0002*\u0019\u00111Q \u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\b\u0006\u0005%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2ATAG\u0011%\t9(FA\u0001\u0002\u0004\t\t!\u0001\u0004fcV\fGn\u001d\u000b\u0004\u001d\u0006M\u0005\"CA<-\u0005\u0005\t\u0019AA\u0001Q=\u0001\u0011qSAO\u0003?\u000b\u0019+!*\u0002*\u0006-\u0006c\u0001\u0019\u0002\u001a&\u0019\u00111T\u0011\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011U\u00014?\u001a+fjQ0)Kb\u0004(/\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011oK\u001e\fG/\u001a3!m\u0006dW/\u001a\u0011pM\u0002\u0002W\r\u001f9sA:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003O\u000bQG\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00152SmR\u0001\u0005\t\u0011!A\u0001\u0002S&\r\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011QV\u0001\u0006c9\u0002d\u0006M\u0001\u000b+:\f'/_'j]V\u001c\bC\u0001\u0019\u0019'\u0011A\u0012QW\"\u0011\u000f\u0005]\u0016Q\u0018%O)6\u0011\u0011\u0011\u0018\u0006\u0004\u0003w{\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003\u007f\u000bILA\tBEN$(/Y2u\rVt7\r^5p]J\"\"!!-\u0015\u0005\u0005e\u0013!B1qa2LH#\u0002+\u0002J\u0006-\u0007\"\u0002$\u001c\u0001\u0004A\u0005b\u0002'\u001c!\u0003\u0005\rAT\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u00059QO\\1qa2LH\u0003BAj\u0003?\u0004RAPAk\u00033L1!a6@\u0005\u0019y\u0005\u000f^5p]B)a(a7I\u001d&\u0019\u0011Q\\ \u0003\rQ+\b\u000f\\33\u0011!\t\t/HA\u0001\u0002\u0004!\u0016a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\n1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u001e\t\u0005\u00037\nY/\u0003\u0003\u0002n\u0006u#AB(cU\u0016\u001cG\u000f")
public class UnaryMinus
extends UnaryExpression
implements ExpectsInputTypes,
package.NullIntolerant,
scala.Serializable {
    private Numeric<Object> numeric;
    private final Expression child;
    private final boolean failOnError;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return UnaryMinus$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(UnaryMinus unaryMinus) {
        return UnaryMinus$.MODULE$.unapply(unaryMinus);
    }

    public static boolean apply$default$2() {
        return UnaryMinus$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Object>, UnaryMinus> tupled() {
        return UnaryMinus$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, UnaryMinus>> curried() {
        return UnaryMinus$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.NumericAndInterval()}));
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    @Override
    public String toString() {
        return new StringBuilder(1).append("-").append(this.child()).toString();
    }

    private Numeric<Object> numeric$lzycompute() {
        UnaryMinus unaryMinus = this;
        synchronized (unaryMinus) {
            if (!this.bitmap$0) {
                this.numeric = TypeUtils$.MODULE$.getNumeric(this.dataType(), this.failOnError());
                this.bitmap$0 = true;
            }
        }
        return this.numeric;
    }

    private Numeric<Object> numeric() {
        return !this.bitmap$0 ? this.numeric$lzycompute() : this.numeric;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        DataType dataType = this.dataType();
        if (dataType instanceof DecimalType) {
            exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(15).append((String)c).append(".unary_$minus()").toString());
        } else {
            boolean bl = ByteType$.MODULE$.equals(dataType) ? true : ShortType$.MODULE$.equals(dataType);
            if (bl && this.failOnError()) {
                exprCode = this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)eval -> {
                    String javaBoxedType = CodeGenerator$.MODULE$.boxedType(this.dataType());
                    String javaType = CodeGenerator$.MODULE$.javaType(this.dataType());
                    String originValue = ctx.freshName("origin");
                    return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(182).append("\n           |").append(javaType).append(" ").append(originValue).append(" = (").append(javaType).append(")(").append((String)eval).append(");\n           |if (").append(originValue).append(" == ").append(javaBoxedType).append(".MIN_VALUE) {\n           |  throw new ArithmeticException(\"- \" + ").append(originValue).append(" + \" caused overflow.\");\n           |}\n           |").append(ev.value()).append(" = (").append(javaType).append(")(-(").append(originValue).append("));\n           ").toString())).stripMargin();
                });
            } else {
                boolean bl2 = IntegerType$.MODULE$.equals(dataType) ? true : LongType$.MODULE$.equals(dataType);
                if (bl2 && this.failOnError()) {
                    exprCode = this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)eval -> {
                        String mathClass = Math.class.getName();
                        return new StringBuilder(18).append(ev.value()).append(" = ").append(mathClass).append(".negateExact(").append((String)eval).append(");").toString();
                    });
                } else if (dataType instanceof NumericType) {
                    NumericType numericType = (NumericType)dataType;
                    exprCode = this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)eval -> {
                        String originValue = ctx.freshName("origin");
                        return new StringBuilder(45).append("\n        ").append(CodeGenerator$.MODULE$.javaType(numericType)).append(" ").append(originValue).append(" = (").append(CodeGenerator$.MODULE$.javaType(numericType)).append(")(").append((String)eval).append(");\n        ").append(ev.value()).append(" = (").append(CodeGenerator$.MODULE$.javaType(numericType)).append(")(-(").append(originValue).append("));\n      ").toString();
                    });
                } else if (dataType instanceof CalendarIntervalType) {
                    String iu = new StringOps(Predef$.MODULE$.augmentString(IntervalUtils$.MODULE$.getClass().getCanonicalName())).stripSuffix("$");
                    String method = this.failOnError() ? "negateExact" : "negate";
                    exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(3).append(iu).append(".").append(method).append("(").append((String)c).append(")").toString());
                } else {
                    throw new MatchError((Object)dataType);
                }
            }
        }
        return exprCode;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public Object nullSafeEval(Object input) {
        void var2_8;
        boolean bl = false;
        DataType dataType = null;
        DataType dataType2 = this.dataType();
        if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
            bl = true;
            dataType = dataType2;
            if (this.failOnError()) {
                CalendarInterval calendarInterval = IntervalUtils$.MODULE$.negateExact((CalendarInterval)input);
                return var2_8;
            }
        }
        if (bl) {
            CalendarInterval calendarInterval = IntervalUtils$.MODULE$.negate((CalendarInterval)input);
            return var2_8;
        }
        Object object = this.numeric().negate(input);
        return var2_8;
    }

    @Override
    public String sql() {
        String string = (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "-");
        String string2 = "-".equals(string) ? new StringBuilder(4).append("(- ").append(this.child().sql()).append(")").toString() : new StringBuilder(2).append(string).append("(").append(this.child().sql()).append(")").toString();
        return string2;
    }

    public UnaryMinus copy(Expression child, boolean failOnError) {
        return new UnaryMinus(child, failOnError);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "UnaryMinus";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof UnaryMinus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof UnaryMinus)) return false;
        boolean bl = true;
        if (!bl) return false;
        UnaryMinus unaryMinus = (UnaryMinus)x$1;
        Expression expression = this.child();
        Expression expression2 = unaryMinus.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.failOnError() != unaryMinus.failOnError()) return false;
        if (!unaryMinus.canEqual(this)) return false;
        return true;
    }

    public UnaryMinus(Expression child, boolean failOnError) {
        this.child = child;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public UnaryMinus(Expression child) {
        this(child, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

