/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.MapOutputTracker$$anonfun$org$apache$spark$MapOutputTracker$;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.shuffle.MetadataFetchFailedException;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.TraitSetter;

public final class MapOutputTracker$
implements Logging {
    public static final MapOutputTracker$ MODULE$;
    private final String ENDPOINT_NAME;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new MapOutputTracker$();
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public String ENDPOINT_NAME() {
        return this.ENDPOINT_NAME;
    }

    public byte[] serializeMapStatuses(MapStatus[] statuses) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream objOut = new ObjectOutputStream(new GZIPOutputStream(out));
        Utils$.MODULE$.tryWithSafeFinally(new Serializable(statuses, objOut){
            public static final long serialVersionUID = 0L;
            private final MapStatus[] statuses$1;
            private final ObjectOutputStream objOut$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MapStatus[] mapStatusArray = this.statuses$1;
                synchronized (this.statuses$1) {
                    this.objOut$1.writeObject(this.statuses$1);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
            {
                this.statuses$1 = statuses$1;
                this.objOut$1 = objOut$1;
            }
        }, (Function0<BoxedUnit>)new Serializable(objOut){
            public static final long serialVersionUID = 0L;
            private final ObjectOutputStream objOut$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.objOut$1.close();
            }
            {
                this.objOut$1 = objOut$1;
            }
        });
        return out.toByteArray();
    }

    public MapStatus[] deserializeMapStatuses(byte[] bytes) {
        ObjectInputStream objIn = new ObjectInputStream(new GZIPInputStream(new ByteArrayInputStream(bytes)));
        return (MapStatus[])Utils$.MODULE$.tryWithSafeFinally(new Serializable(objIn){
            public static final long serialVersionUID = 0L;
            private final ObjectInputStream objIn$1;

            public final MapStatus[] apply() {
                return (MapStatus[])this.objIn$1.readObject();
            }
            {
                this.objIn$1 = objIn$1;
            }
        }, (Function0<BoxedUnit>)new Serializable(objIn){
            public static final long serialVersionUID = 0L;
            private final ObjectInputStream objIn$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.objIn$1.close();
            }
            {
                this.objIn$1 = objIn$1;
            }
        });
    }

    public Seq<Tuple2<BlockManagerId, Seq<Tuple2<BlockId, Object>>>> org$apache$spark$MapOutputTracker$$convertMapStatuses(int shuffleId, int startPartition, int endPartition, MapStatus[] statuses) {
        Predef$.MODULE$.assert(statuses != null);
        HashMap splitsByAddress = new HashMap();
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])statuses).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<MapStatus, Object> check$ifrefutable$1) {
                Tuple2<MapStatus, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(shuffleId, startPartition, endPartition, splitsByAddress){
            public static final long serialVersionUID = 0L;
            public final int shuffleId$4;
            private final int startPartition$2;
            private final int endPartition$2;
            public final HashMap splitsByAddress$1;

            public final void apply(Tuple2<MapStatus, Object> x$2) {
                Tuple2<MapStatus, Object> tuple2 = x$2;
                if (tuple2 != null) {
                    MapStatus status = (MapStatus)tuple2._1();
                    int mapId = tuple2._2$mcI$sp();
                    if (status == null) {
                        String errorMessage = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing an output location for shuffle ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.shuffleId$4)}));
                        MapOutputTracker$.MODULE$.logError((Function0<String>)new Serializable(this, errorMessage){
                            public static final long serialVersionUID = 0L;
                            private final String errorMessage$1;

                            public final String apply() {
                                return this.errorMessage$1;
                            }
                            {
                                this.errorMessage$1 = errorMessage$1;
                            }
                        });
                        throw new MetadataFetchFailedException(this.shuffleId$4, this.startPartition$2, errorMessage);
                    }
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.startPartition$2), this.endPartition$2).foreach((Function1)new Serializable(this, status, mapId){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun$org$apache$spark$MapOutputTracker$$convertMapStatuses$2 $outer;
                        private final MapStatus status$1;
                        private final int mapId$1;

                        public final ArrayBuffer<Tuple2<BlockId, Object>> apply(int part) {
                            return ((ArrayBuffer)this.$outer.splitsByAddress$1.getOrElseUpdate((Object)this.status$1.location(), (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final ArrayBuffer<Tuple2<BlockId, Object>> apply() {
                                    return (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                                }
                            })).$plus$eq((Object)new Tuple2((Object)new ShuffleBlockId(this.$outer.shuffleId$4, this.mapId$1, part), (Object)BoxesRunTime.boxToLong((long)this.status$1.getSizeForBlock(part))));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.status$1 = status$1;
                            this.mapId$1 = mapId$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.shuffleId$4 = shuffleId$4;
                this.startPartition$2 = startPartition$2;
                this.endPartition$2 = endPartition$2;
                this.splitsByAddress$1 = splitsByAddress$1;
            }
        });
        return splitsByAddress.toSeq();
    }

    private MapOutputTracker$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.ENDPOINT_NAME = "MapOutputTracker";
    }
}

