/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.mesos.MesosNativeLibrary;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkMasterRegex$;
import org.apache.spark.WritableConverter;
import org.apache.spark.WritableConverter$;
import org.apache.spark.WritableFactory;
import org.apache.spark.deploy.LocalSparkCluster;
import org.apache.spark.rdd.AsyncRDDActions;
import org.apache.spark.rdd.DoubleRDDFunctions;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.PairRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.rdd.SequenceFileRDDFunctions;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.SplitInfo;
import org.apache.spark.scheduler.TaskScheduler;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.SimrSchedulerBackend;
import org.apache.spark.scheduler.cluster.SparkDeploySchedulerBackend;
import org.apache.spark.scheduler.cluster.mesos.CoarseMesosSchedulerBackend;
import org.apache.spark.scheduler.cluster.mesos.MesosSchedulerBackend;
import org.apache.spark.scheduler.local.LocalBackend;
import org.apache.spark.util.CallSite;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.TraitSetter;

public final class SparkContext$
implements Logging {
    public static final SparkContext$ MODULE$;
    private final Object SPARK_CONTEXT_CONSTRUCTOR_LOCK;
    private final AtomicReference<SparkContext> org$apache$spark$SparkContext$$activeContext;
    private Option<SparkContext> contextBeingConstructed;
    private final String SPARK_JOB_DESCRIPTION;
    private final String SPARK_JOB_GROUP_ID;
    private final String SPARK_JOB_INTERRUPT_ON_CANCEL;
    private final String RDD_SCOPE_KEY;
    private final String RDD_SCOPE_NO_OVERRIDE_KEY;
    private final String DRIVER_IDENTIFIER;
    private final String LEGACY_DRIVER_IDENTIFIER;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new SparkContext$();
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    private Object SPARK_CONTEXT_CONSTRUCTOR_LOCK() {
        return this.SPARK_CONTEXT_CONSTRUCTOR_LOCK;
    }

    public AtomicReference<SparkContext> org$apache$spark$SparkContext$$activeContext() {
        return this.org$apache$spark$SparkContext$$activeContext;
    }

    private Option<SparkContext> contextBeingConstructed() {
        return this.contextBeingConstructed;
    }

    private void contextBeingConstructed_$eq(Option<SparkContext> x$1) {
        this.contextBeingConstructed = x$1;
    }

    private void assertNoOtherContextIsRunning(SparkContext sc, boolean allowMultipleContexts) {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            this.contextBeingConstructed().foreach((Function1)new Serializable(sc, allowMultipleContexts){
                public static final long serialVersionUID = 0L;
                private final SparkContext sc$1;
                private final boolean allowMultipleContexts$1;

                public final void apply(SparkContext otherContext) {
                    SparkException exception2;
                    block5: {
                        block4: {
                            if (otherContext != this.sc$1) {
                                String otherContextCreationSite = (String)Option$.MODULE$.apply((Object)otherContext.org$apache$spark$SparkContext$$creationSite()).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(CallSite x$35) {
                                        return x$35.longForm();
                                    }
                                }).getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "unknown location";
                                    }
                                });
                                String warnMsg = new StringBuilder().append((Object)"Another SparkContext is being constructed (or threw an exception in its constructor).  This may indicate an error, since only one SparkContext may be running in this JVM (see SPARK-2243).").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" The other SparkContext was created at:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{otherContextCreationSite}))).toString();
                                SparkContext$.MODULE$.logWarning((Function0<String>)new Serializable(this, warnMsg){
                                    public static final long serialVersionUID = 0L;
                                    private final String warnMsg$1;

                                    public final String apply() {
                                        return this.warnMsg$1;
                                    }
                                    {
                                        this.warnMsg$1 = warnMsg$1;
                                    }
                                });
                            }
                            if (SparkContext$.MODULE$.org$apache$spark$SparkContext$$activeContext().get() == null) break block4;
                            SparkContext ctx = SparkContext$.MODULE$.org$apache$spark$SparkContext$$activeContext().get();
                            String errMsg = new StringBuilder().append((Object)"Only one SparkContext may be running in this JVM (see SPARK-2243). To ignore this error, set spark.driver.allowMultipleContexts = true. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The currently running SparkContext was created at:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ctx.org$apache$spark$SparkContext$$creationSite().longForm()}))).toString();
                            exception2 = new SparkException(errMsg);
                            if (!this.allowMultipleContexts$1) break block5;
                            SparkContext$.MODULE$.logWarning((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Multiple running SparkContexts detected in the same JVM!";
                                }
                            }, exception2);
                        }
                        return;
                    }
                    throw exception2;
                }
                {
                    this.sc$1 = sc$1;
                    this.allowMultipleContexts$1 = allowMultipleContexts$1;
                }
            });
            return;
        }
    }

    public SparkContext getOrCreate(SparkConf config) {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            if (this.org$apache$spark$SparkContext$$activeContext().get() == null) {
                this.setActiveContext(new SparkContext(config), false);
            }
            SparkContext sparkContext = this.org$apache$spark$SparkContext$$activeContext().get();
            return sparkContext;
        }
    }

    public SparkContext getOrCreate() {
        return this.getOrCreate(new SparkConf());
    }

    public void markPartiallyConstructed(SparkContext sc, boolean allowMultipleContexts) {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            this.assertNoOtherContextIsRunning(sc, allowMultipleContexts);
            this.contextBeingConstructed_$eq((Option<SparkContext>)new Some((Object)sc));
            return;
        }
    }

    public void setActiveContext(SparkContext sc, boolean allowMultipleContexts) {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            this.assertNoOtherContextIsRunning(sc, allowMultipleContexts);
            this.contextBeingConstructed_$eq((Option<SparkContext>)None$.MODULE$);
            this.org$apache$spark$SparkContext$$activeContext().set(sc);
            return;
        }
    }

    public void clearActiveContext() {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            this.org$apache$spark$SparkContext$$activeContext().set(null);
            return;
        }
    }

    public String SPARK_JOB_DESCRIPTION() {
        return this.SPARK_JOB_DESCRIPTION;
    }

    public String SPARK_JOB_GROUP_ID() {
        return this.SPARK_JOB_GROUP_ID;
    }

    public String SPARK_JOB_INTERRUPT_ON_CANCEL() {
        return this.SPARK_JOB_INTERRUPT_ON_CANCEL;
    }

    public String RDD_SCOPE_KEY() {
        return this.RDD_SCOPE_KEY;
    }

    public String RDD_SCOPE_NO_OVERRIDE_KEY() {
        return this.RDD_SCOPE_NO_OVERRIDE_KEY;
    }

    public String DRIVER_IDENTIFIER() {
        return this.DRIVER_IDENTIFIER;
    }

    public String LEGACY_DRIVER_IDENTIFIER() {
        return this.LEGACY_DRIVER_IDENTIFIER;
    }

    public <K, V> PairRDDFunctions<K, V> rddToPairRDDFunctions(RDD<Tuple2<K, V>> rdd, ClassTag<K> kt, ClassTag<V> vt, Ordering<K> ord) {
        return RDD$.MODULE$.rddToPairRDDFunctions(rdd, kt, vt, ord);
    }

    public <K, V> Null$ rddToPairRDDFunctions$default$4(RDD<Tuple2<K, V>> rdd) {
        return null;
    }

    public <T> AsyncRDDActions<T> rddToAsyncRDDActions(RDD<T> rdd, ClassTag<T> evidence$22) {
        return RDD$.MODULE$.rddToAsyncRDDActions(rdd, evidence$22);
    }

    public <K, V> SequenceFileRDDFunctions<K, V> rddToSequenceFileRDDFunctions(RDD<Tuple2<K, V>> rdd, Function1<K, Writable> evidence$23, ClassTag<K> evidence$24, Function1<V, Writable> evidence$25, ClassTag<V> evidence$26) {
        Function1 kf = (Function1)Predef$.MODULE$.implicitly(evidence$23);
        Function1 vf = (Function1)Predef$.MODULE$.implicitly(evidence$25);
        WritableFactory keyWritableFactory = new WritableFactory(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply(ClassTag<K> x$36) {
                return null;
            }
        }, kf);
        WritableFactory valueWritableFactory = new WritableFactory(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply(ClassTag<V> x$37) {
                return null;
            }
        }, vf);
        return RDD$.MODULE$.rddToSequenceFileRDDFunctions(rdd, evidence$24, evidence$26, keyWritableFactory, valueWritableFactory);
    }

    public <K, V> OrderedRDDFunctions<K, V, Tuple2<K, V>> rddToOrderedRDDFunctions(RDD<Tuple2<K, V>> rdd, Ordering<K> evidence$27, ClassTag<K> evidence$28, ClassTag<V> evidence$29) {
        return RDD$.MODULE$.rddToOrderedRDDFunctions(rdd, evidence$27, evidence$28, evidence$29);
    }

    public DoubleRDDFunctions doubleRDDToDoubleRDDFunctions(RDD<Object> rdd) {
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(rdd);
    }

    public <T> DoubleRDDFunctions numericRDDToDoubleRDDFunctions(RDD<T> rdd, Numeric<T> num) {
        return RDD$.MODULE$.numericRDDToDoubleRDDFunctions(rdd, num);
    }

    public IntWritable intToIntWritable(int i) {
        return new IntWritable(i);
    }

    public LongWritable longToLongWritable(long l) {
        return new LongWritable(l);
    }

    public FloatWritable floatToFloatWritable(float f) {
        return new FloatWritable(f);
    }

    public DoubleWritable doubleToDoubleWritable(double d) {
        return new DoubleWritable(d);
    }

    public BooleanWritable boolToBoolWritable(boolean b) {
        return new BooleanWritable(b);
    }

    public BytesWritable bytesToBytesWritable(byte[] aob) {
        return new BytesWritable(aob);
    }

    public Text stringToText(String s) {
        return new Text(s);
    }

    private <T> ArrayWritable arrayToArrayWritable(Traversable<T> arr, Function1<T, Writable> evidence$30, ClassTag<T> evidence$31) {
        return new ArrayWritable(package$.MODULE$.classTag(evidence$31).runtimeClass(), (Writable[])((TraversableOnce)arr.map((Function1)new Serializable(evidence$30){
            public static final long serialVersionUID = 0L;
            private final Function1 evidence$30$1;

            public final Writable apply(T x) {
                return SparkContext$.MODULE$.org$apache$spark$SparkContext$$anyToWritable$1(x, this.evidence$30$1);
            }
            {
                this.evidence$30$1 = evidence$30$1;
            }
        }, Traversable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Writable.class)));
    }

    public WritableConverter<Object> intWritableConverter() {
        return WritableConverter$.MODULE$.intWritableConverter();
    }

    public WritableConverter<Object> longWritableConverter() {
        return WritableConverter$.MODULE$.longWritableConverter();
    }

    public WritableConverter<Object> doubleWritableConverter() {
        return WritableConverter$.MODULE$.doubleWritableConverter();
    }

    public WritableConverter<Object> floatWritableConverter() {
        return WritableConverter$.MODULE$.floatWritableConverter();
    }

    public WritableConverter<Object> booleanWritableConverter() {
        return WritableConverter$.MODULE$.booleanWritableConverter();
    }

    public WritableConverter<byte[]> bytesWritableConverter() {
        return WritableConverter$.MODULE$.bytesWritableConverter();
    }

    public WritableConverter<String> stringWritableConverter() {
        return WritableConverter$.MODULE$.stringWritableConverter();
    }

    public <T extends Writable> WritableConverter<T> writableWritableConverter() {
        return WritableConverter$.MODULE$.writableWritableConverter();
    }

    public Option<String> jarOfClass(Class<?> cls) {
        String uriStr;
        URL uri = cls.getResource(new StringBuilder().append((Object)"/").append((Object)cls.getName().replace('.', '/')).append((Object)".class").toString());
        return uri == null ? None$.MODULE$ : ((uriStr = uri.toString()).startsWith("jar:file:") ? new Some((Object)uriStr.substring("jar:file:".length(), uriStr.indexOf(33))) : None$.MODULE$);
    }

    public Option<String> jarOfObject(Object obj) {
        return this.jarOfClass(obj.getClass());
    }

    public SparkConf updatedConf(SparkConf conf, String master, String appName, String sparkHome, Seq<String> jars, Map<String, String> environment) {
        SparkConf res = conf.clone();
        res.setMaster(master);
        res.setAppName(appName);
        Object object = sparkHome == null ? BoxedUnit.UNIT : res.setSparkHome(sparkHome);
        Object object2 = jars == null || jars.isEmpty() ? BoxedUnit.UNIT : res.setJars(jars);
        res.setExecutorEnv((Seq<Tuple2<String, String>>)environment.toSeq());
        return res;
    }

    public String updatedConf$default$4() {
        return null;
    }

    public Seq<String> updatedConf$default$5() {
        return Nil$.MODULE$;
    }

    public Map<String, String> updatedConf$default$6() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public int numDriverCores(String master) {
        int n;
        String string;
        String string2 = string = master;
        if (!("local" != null ? !"local".equals(string2) : string2 != null)) {
            n = 1;
        } else {
            Option option = SparkMasterRegex$.MODULE$.LOCAL_N_REGEX().unapplySeq((Object)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                String threads = (String)((LinearSeqOptimized)option.get()).apply(0);
                n = this.convertToInt$1(threads);
            } else {
                Option option2 = SparkMasterRegex$.MODULE$.LOCAL_N_FAILURES_REGEX().unapplySeq((Object)string);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                    String threads = (String)((LinearSeqOptimized)option2.get()).apply(0);
                    n = this.convertToInt$1(threads);
                } else {
                    n = 0;
                }
            }
        }
        return n;
    }

    /*
     * Loose catch block
     */
    public Tuple2<SchedulerBackend, TaskScheduler> org$apache$spark$SparkContext$$createTaskScheduler(SparkContext sc, String master) {
        while (true) {
            String string;
            block26: {
                Tuple2 tuple2;
                block18: {
                    block25: {
                        block24: {
                            block23: {
                                boolean bl;
                                block22: {
                                    block21: {
                                        block20: {
                                            block19: {
                                                int threadCount;
                                                String threads;
                                                int MAX_LOCAL_TASK_FAILURES;
                                                block17: {
                                                    MAX_LOCAL_TASK_FAILURES = 1;
                                                    String string2 = string = master;
                                                    if ("local" != null ? !"local".equals(string2) : string2 != null) break block17;
                                                    TaskSchedulerImpl scheduler2 = new TaskSchedulerImpl(sc, MAX_LOCAL_TASK_FAILURES, true);
                                                    LocalBackend backend = new LocalBackend(sc.getConf(), scheduler2, 1);
                                                    scheduler2.initialize(backend);
                                                    tuple2 = new Tuple2((Object)backend, (Object)scheduler2);
                                                    break block18;
                                                }
                                                Option option = SparkMasterRegex$.MODULE$.LOCAL_N_REGEX().unapplySeq((Object)string);
                                                if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) break block19;
                                                String string3 = threads = (String)((LinearSeqOptimized)option.get()).apply(0);
                                                String string4 = "*";
                                                int n = !(string3 != null ? !string3.equals(string4) : string4 != null) ? this.localCpuCount$1() : (threadCount = new StringOps(Predef$.MODULE$.augmentString(threads)).toInt());
                                                if (threadCount <= 0) {
                                                    throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Asked to run locally with ", " threads"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)threadCount)})));
                                                }
                                                TaskSchedulerImpl scheduler3 = new TaskSchedulerImpl(sc, MAX_LOCAL_TASK_FAILURES, true);
                                                LocalBackend backend = new LocalBackend(sc.getConf(), scheduler3, threadCount);
                                                scheduler3.initialize(backend);
                                                tuple2 = new Tuple2((Object)backend, (Object)scheduler3);
                                                break block18;
                                            }
                                            Option option = SparkMasterRegex$.MODULE$.LOCAL_N_FAILURES_REGEX().unapplySeq((Object)string);
                                            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) break block20;
                                            String threads = (String)((LinearSeqOptimized)option.get()).apply(0);
                                            String maxFailures = (String)((LinearSeqOptimized)option.get()).apply(1);
                                            String string5 = threads;
                                            String string6 = "*";
                                            int threadCount = !(string5 != null ? !string5.equals(string6) : string6 != null) ? this.localCpuCount$2() : new StringOps(Predef$.MODULE$.augmentString(threads)).toInt();
                                            TaskSchedulerImpl scheduler4 = new TaskSchedulerImpl(sc, new StringOps(Predef$.MODULE$.augmentString(maxFailures)).toInt(), true);
                                            LocalBackend backend = new LocalBackend(sc.getConf(), scheduler4, threadCount);
                                            scheduler4.initialize(backend);
                                            tuple2 = new Tuple2((Object)backend, (Object)scheduler4);
                                            break block18;
                                        }
                                        Option option = SparkMasterRegex$.MODULE$.SPARK_REGEX().unapplySeq((Object)string);
                                        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) break block21;
                                        String sparkUrl = (String)((LinearSeqOptimized)option.get()).apply(0);
                                        TaskSchedulerImpl scheduler5 = new TaskSchedulerImpl(sc);
                                        String[] masterUrls = (String[])Predef$.MODULE$.refArrayOps((Object[])sparkUrl.split(",")).map((Function1)new Serializable(){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply(String x$38) {
                                                return new StringBuilder().append((Object)"spark://").append((Object)x$38).toString();
                                            }
                                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                                        SparkDeploySchedulerBackend backend = new SparkDeploySchedulerBackend(scheduler5, sc, masterUrls);
                                        scheduler5.initialize(backend);
                                        tuple2 = new Tuple2((Object)backend, (Object)scheduler5);
                                        break block18;
                                    }
                                    Option option = SparkMasterRegex$.MODULE$.LOCAL_CLUSTER_REGEX().unapplySeq((Object)string);
                                    if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(3) != 0) break block22;
                                    String numSlaves = (String)((LinearSeqOptimized)option.get()).apply(0);
                                    String coresPerSlave = (String)((LinearSeqOptimized)option.get()).apply(1);
                                    String memoryPerSlave = (String)((LinearSeqOptimized)option.get()).apply(2);
                                    int memoryPerSlaveInt = new StringOps(Predef$.MODULE$.augmentString(memoryPerSlave)).toInt();
                                    if (sc.executorMemory() > memoryPerSlaveInt) {
                                        throw new SparkException(new StringOps(Predef$.MODULE$.augmentString("Asked to launch cluster with %d MB RAM / worker but requested %d MB/worker")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)memoryPerSlaveInt), BoxesRunTime.boxToInteger((int)sc.executorMemory())})));
                                    }
                                    TaskSchedulerImpl scheduler6 = new TaskSchedulerImpl(sc);
                                    LocalSparkCluster localCluster = new LocalSparkCluster(new StringOps(Predef$.MODULE$.augmentString(numSlaves)).toInt(), new StringOps(Predef$.MODULE$.augmentString(coresPerSlave)).toInt(), memoryPerSlaveInt, sc.conf());
                                    String[] masterUrls = localCluster.start();
                                    SparkDeploySchedulerBackend backend = new SparkDeploySchedulerBackend(scheduler6, sc, masterUrls);
                                    scheduler6.initialize(backend);
                                    backend.shutdownCallback_$eq((Function1<SparkDeploySchedulerBackend, BoxedUnit>)new Serializable(localCluster){
                                        public static final long serialVersionUID = 0L;
                                        private final LocalSparkCluster localCluster$1;

                                        public final void apply(SparkDeploySchedulerBackend backend) {
                                            this.localCluster$1.stop();
                                        }
                                        {
                                            this.localCluster$1 = localCluster$1;
                                        }
                                    });
                                    tuple2 = new Tuple2((Object)backend, (Object)scheduler6);
                                    break block18;
                                }
                                String string7 = string;
                                if (!("yarn-standalone" != null ? !"yarn-standalone".equals(string7) : string7 != null)) {
                                    bl = true;
                                } else {
                                    String string8 = string;
                                    bl = !("yarn-cluster" != null ? !"yarn-cluster".equals(string8) : string8 != null);
                                }
                                if (!bl) break block23;
                                String string9 = master;
                                String string10 = "yarn-standalone";
                                if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                                    this.logWarning((Function0<String>)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "\"yarn-standalone\" is deprecated as of Spark 1.0. Use \"yarn-cluster\" instead.";
                                        }
                                    });
                                }
                                Class<?> clazz = Utils$.MODULE$.classForName("org.apache.spark.scheduler.cluster.YarnClusterScheduler");
                                Constructor<?> cons = clazz.getConstructor(SparkContext.class);
                                TaskSchedulerImpl scheduler7 = (TaskSchedulerImpl)cons.newInstance(sc);
                                Class<?> clazz2 = Utils$.MODULE$.classForName("org.apache.spark.scheduler.cluster.YarnClusterSchedulerBackend");
                                Constructor<?> cons2 = clazz2.getConstructor(TaskSchedulerImpl.class, SparkContext.class);
                                CoarseGrainedSchedulerBackend backend = (CoarseGrainedSchedulerBackend)cons2.newInstance(scheduler7, sc);
                                scheduler7.initialize(backend);
                                tuple2 = new Tuple2((Object)backend, (Object)scheduler7);
                                break block18;
                            }
                            String string11 = string;
                            if ("yarn-client" != null ? !"yarn-client".equals(string11) : string11 != null) break block24;
                            Class<?> clazz = Utils$.MODULE$.classForName("org.apache.spark.scheduler.cluster.YarnScheduler");
                            Constructor<?> cons = clazz.getConstructor(SparkContext.class);
                            TaskSchedulerImpl scheduler = (TaskSchedulerImpl)cons.newInstance(sc);
                            Class<?> clazz3 = Utils$.MODULE$.classForName("org.apache.spark.scheduler.cluster.YarnClientSchedulerBackend");
                            Constructor<?> cons3 = clazz3.getConstructor(TaskSchedulerImpl.class, SparkContext.class);
                            CoarseGrainedSchedulerBackend backend = (CoarseGrainedSchedulerBackend)cons3.newInstance(scheduler, sc);
                            scheduler.initialize(backend);
                            tuple2 = new Tuple2((Object)backend, (Object)scheduler);
                            break block18;
                        }
                        Option option = SparkMasterRegex$.MODULE$.MESOS_REGEX().unapplySeq((Object)string);
                        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) break block25;
                        String mesosUrl = (String)((LinearSeqOptimized)option.get()).apply(0);
                        MesosNativeLibrary.load();
                        TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc);
                        boolean coarseGrained = sc.conf().getBoolean("spark.mesos.coarse", true);
                        SchedulerBackend backend = coarseGrained ? new CoarseMesosSchedulerBackend(scheduler, sc, mesosUrl, sc.env().securityManager()) : new MesosSchedulerBackend(scheduler, sc, mesosUrl);
                        scheduler.initialize(backend);
                        tuple2 = new Tuple2((Object)backend, (Object)scheduler);
                        break block18;
                    }
                    Option option = SparkMasterRegex$.MODULE$.SIMR_REGEX().unapplySeq((Object)string);
                    if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) break block26;
                    String simrUrl = (String)((LinearSeqOptimized)option.get()).apply(0);
                    TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc);
                    SimrSchedulerBackend backend = new SimrSchedulerBackend(scheduler, sc, simrUrl);
                    scheduler.initialize(backend);
                    tuple2 = new Tuple2((Object)backend, (Object)scheduler);
                }
                return tuple2;
            }
            if (!string.startsWith("zk://")) break;
            this.logWarning((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Master URL for a multi-master Mesos cluster managed by ZooKeeper should be in the form mesos://zk://host:port. Current Master URL will stop working in Spark 2.0.";
                }
            });
            master = new StringBuilder().append((Object)"mesos://").append((Object)string).toString();
        }
        throw new SparkException(new StringBuilder().append((Object)"Could not parse Master URL: '").append((Object)master).append((Object)"'").toString());
        catch (Exception exception2) {
            throw new SparkException("YARN mode not available ?", exception2);
        }
        catch (Exception exception3) {
            throw new SparkException("YARN mode not available ?", exception3);
        }
        catch (Exception exception4) {
            throw new SparkException("YARN mode not available ?", exception4);
        }
        catch (Exception exception5) {
            throw new SparkException("YARN mode not available ?", exception5);
        }
    }

    public String $lessinit$greater$default$3() {
        return null;
    }

    public Seq<String> $lessinit$greater$default$4() {
        return Nil$.MODULE$;
    }

    public Map<String, String> $lessinit$greater$default$5() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public Map<String, Set<SplitInfo>> $lessinit$greater$default$6() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public final Writable org$apache$spark$SparkContext$$anyToWritable$1(Object u, Function1 evidence$32) {
        return (Writable)evidence$32.apply(u);
    }

    private final int convertToInt$1(String threads) {
        String string = threads;
        String string2 = "*";
        return !(string != null ? !string.equals(string2) : string2 != null) ? Runtime.getRuntime().availableProcessors() : new StringOps(Predef$.MODULE$.augmentString(threads)).toInt();
    }

    private final int localCpuCount$1() {
        return Runtime.getRuntime().availableProcessors();
    }

    private final int localCpuCount$2() {
        return Runtime.getRuntime().availableProcessors();
    }

    private SparkContext$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.SPARK_CONTEXT_CONSTRUCTOR_LOCK = new Object();
        this.org$apache$spark$SparkContext$$activeContext = new AtomicReference<Object>(null);
        this.contextBeingConstructed = None$.MODULE$;
        this.SPARK_JOB_DESCRIPTION = "spark.job.description";
        this.SPARK_JOB_GROUP_ID = "spark.jobGroup.id";
        this.SPARK_JOB_INTERRUPT_ON_CANCEL = "spark.job.interruptOnCancel";
        this.RDD_SCOPE_KEY = "spark.rdd.scope";
        this.RDD_SCOPE_NO_OVERRIDE_KEY = "spark.rdd.scope.noOverride";
        this.DRIVER_IDENTIFIER = "driver";
        this.LEGACY_DRIVER_IDENTIFIER = "<driver>";
    }
}

