/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.memory.MemoryPool;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.MemoryStore;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005=a!B\u0001\u0003\u0001\tQ!!E*u_J\fw-Z'f[>\u0014\u0018\u0010U8pY*\u00111\u0001B\u0001\u0007[\u0016lwN]=\u000b\u0005\u00151\u0011!B:qCJ\\'BA\u0004\t\u0003\u0019\t\u0007/Y2iK*\t\u0011\"A\u0002pe\u001e\u001c2\u0001A\u0006\u0010!\taQ\"D\u0001\u0003\u0013\tq!A\u0001\u0006NK6|'/\u001f)p_2\u0004\"\u0001E\t\u000e\u0003\u0011I!A\u0005\u0003\u0003\u000f1{wmZ5oO\"AA\u0003\u0001B\u0001B\u0003%a#\u0001\u0003m_\u000e\\7\u0001\u0001\t\u0003/qi\u0011\u0001\u0007\u0006\u00033i\tA\u0001\\1oO*\t1$\u0001\u0003kCZ\f\u0017BA\u000f\u0019\u0005\u0019y%M[3di\")q\u0004\u0001C\u0001A\u00051A(\u001b8jiz\"\"!\t\u0012\u0011\u00051\u0001\u0001\"\u0002\u000b\u001f\u0001\u00041\u0002B\u0002\u0013\u0001A\u0003&Q%A\u0006`[\u0016lwN]=Vg\u0016$\u0007C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#\u0001\u0002'p]\u001eDCa\t\u00177oA\u0011Q\u0006N\u0007\u0002])\u0011q\u0006M\u0001\u000bG>t7-\u001e:sK:$(BA\u00193\u0003)\tgN\\8uCRLwN\u001c\u0006\u0002g\u0005)!.\u0019<bq&\u0011QG\f\u0002\n\u000fV\f'\u000fZ3e\u0005f\fQA^1mk\u0016\f\u0013\u0001\u0006\u0005\u0006s\u0001!\tEO\u0001\u000b[\u0016lwN]=Vg\u0016$W#A\u0013\t\u0013q\u0002\u0001\u0019!a\u0001\n\u0013i\u0014\u0001D0nK6|'/_*u_J,W#\u0001 \u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005#\u0011aB:u_J\fw-Z\u0005\u0003\u0007\u0002\u00131\"T3n_JL8\u000b^8sK\"IQ\t\u0001a\u0001\u0002\u0004%IAR\u0001\u0011?6,Wn\u001c:z'R|'/Z0%KF$\"a\u0012&\u0011\u0005\u0019B\u0015BA%(\u0005\u0011)f.\u001b;\t\u000f-#\u0015\u0011!a\u0001}\u0005\u0019\u0001\u0010J\u0019\t\r5\u0003\u0001\u0015)\u0003?\u00035yV.Z7pef\u001cFo\u001c:fA!)q\n\u0001C\u0001{\u0005YQ.Z7pef\u001cFo\u001c:f\u0011\u0015\t\u0006\u0001\"\u0002S\u00039\u0019X\r^'f[>\u0014\u0018p\u0015;pe\u0016$\"aR*\t\u000bQ\u0003\u0006\u0019\u0001 \u0002\u000bM$xN]3\t\u000bY\u0003A\u0011A,\u0002\u001b\u0005\u001c\u0017/^5sK6+Wn\u001c:z)\u0011A6\f\u00192\u0011\u0005\u0019J\u0016B\u0001.(\u0005\u001d\u0011un\u001c7fC:DQ\u0001X+A\u0002u\u000bqA\u00197pG.LE\r\u0005\u0002@=&\u0011q\f\u0011\u0002\b\u00052|7m[%e\u0011\u0015\tW\u000b1\u0001&\u0003!qW/\u001c\"zi\u0016\u001c\b\"B2V\u0001\u0004!\u0017!D3wS\u000e$X\r\u001a\"m_\u000e\\7\u000fE\u0002fU2l\u0011A\u001a\u0006\u0003O\"\fq!\\;uC\ndWM\u0003\u0002jO\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005-4'A\u0002\"vM\u001a,'\u000f\u0005\u0003'[v{\u0017B\u00018(\u0005\u0019!V\u000f\u001d7feA\u0011q\b]\u0005\u0003c\u0002\u00131B\u00117pG.\u001cF/\u0019;vg\")a\u000b\u0001C\u0001gR)\u0001\f^;xs\")AL\u001da\u0001;\")aO\u001da\u0001K\u0005\tb.^7CsR,7\u000fV8BGF,\u0018N]3\t\u000ba\u0014\b\u0019A\u0013\u0002\u001d9,XNQ=uKN$vN\u0012:fK\")1M\u001da\u0001I\")1\u0010\u0001C\u0001y\u0006i!/\u001a7fCN,W*Z7pef$\"aR?\t\u000byT\b\u0019A\u0013\u0002\tML'0\u001a\u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u0003A\u0011X\r\\3bg\u0016\fE\u000e\\'f[>\u0014\u0018\u0010F\u0001H\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013\tQC\u001a:fKN\u0003\u0018mY3U_NC'/\u001b8l!>|G\u000eF\u0002&\u0003\u0017Aq!!\u0004\u0002\u0006\u0001\u0007Q%A\u0006ta\u0006\u001cW\rV8Ge\u0016,\u0007")
public class StorageMemoryPool
extends MemoryPool
implements Logging {
    private final Object lock;
    @GuardedBy(value="lock")
    public long org$apache$spark$memory$StorageMemoryPool$$_memoryUsed;
    private MemoryStore _memoryStore;
    private transient Logger org$apache$spark$Logging$$log_;

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public long memoryUsed() {
        Object object = this.lock;
        synchronized (object) {
            Long l = BoxesRunTime.boxToLong((long)this.org$apache$spark$memory$StorageMemoryPool$$_memoryUsed);
            return BoxesRunTime.unboxToLong((Object)l);
        }
    }

    private MemoryStore _memoryStore() {
        return this._memoryStore;
    }

    private void _memoryStore_$eq(MemoryStore x$1) {
        this._memoryStore = x$1;
    }

    public MemoryStore memoryStore() {
        if (this._memoryStore() == null) {
            throw new IllegalStateException("memory store not initialized yet");
        }
        return this._memoryStore();
    }

    public final void setMemoryStore(MemoryStore store) {
        this._memoryStore_$eq(store);
    }

    public boolean acquireMemory(BlockId blockId, long numBytes, Buffer<Tuple2<BlockId, BlockStatus>> evictedBlocks) {
        Object object = this.lock;
        synchronized (object) {
            long numBytesToFree = package$.MODULE$.max(0L, numBytes - this.memoryFree());
            Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.acquireMemory(blockId, numBytes, numBytesToFree, evictedBlocks));
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }

    public boolean acquireMemory(BlockId blockId, long numBytesToAcquire, long numBytesToFree, Buffer<Tuple2<BlockId, BlockStatus>> evictedBlocks) {
        Object object = this.lock;
        synchronized (object) {
            boolean enoughMemory;
            Predef$.MODULE$.assert(numBytesToAcquire >= 0L);
            Predef$.MODULE$.assert(numBytesToFree >= 0L);
            Predef$.MODULE$.assert(this.memoryUsed() <= this.poolSize());
            if (numBytesToFree > 0L) {
                this.memoryStore().evictBlocksToFreeSpace((Option<BlockId>)new Some((Object)blockId), numBytesToFree, evictedBlocks);
                Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1)new Serializable(this, evictedBlocks){
                    public static final long serialVersionUID = 0L;
                    private final Buffer evictedBlocks$1;

                    public final void apply(TaskContext tc) {
                        TaskMetrics metrics = tc.taskMetrics();
                        Seq lastUpdatedBlocks = (Seq)metrics.updatedBlocks().getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Seq<Tuple2<BlockId, BlockStatus>> apply() {
                                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                            }
                        });
                        metrics.updatedBlocks_$eq((Option<Seq<Tuple2<BlockId, BlockStatus>>>)new Some(lastUpdatedBlocks.$plus$plus((GenTraversableOnce)this.evictedBlocks$1.toSeq(), Seq$.MODULE$.canBuildFrom())));
                    }
                    {
                        this.evictedBlocks$1 = evictedBlocks$1;
                    }
                });
            }
            boolean bl = enoughMemory = numBytesToAcquire <= this.memoryFree();
            if (enoughMemory) {
                this.org$apache$spark$memory$StorageMemoryPool$$_memoryUsed += numBytesToAcquire;
            }
            Boolean bl2 = BoxesRunTime.boxToBoolean((boolean)enoughMemory);
            return BoxesRunTime.unboxToBoolean((Object)bl2);
        }
    }

    public void releaseMemory(long size) {
        Object object = this.lock;
        synchronized (object) {
            BoxedUnit boxedUnit;
            if (size > this.org$apache$spark$memory$StorageMemoryPool$$_memoryUsed) {
                this.logWarning((Function0<String>)new Serializable(this, size){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ StorageMemoryPool $outer;
                    private final long size$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempted to release ", " bytes of storage "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.size$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"memory when we only have ", " bytes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$memory$StorageMemoryPool$$_memoryUsed)}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.size$1 = size$1;
                    }
                });
                this.org$apache$spark$memory$StorageMemoryPool$$_memoryUsed = 0L;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.org$apache$spark$memory$StorageMemoryPool$$_memoryUsed -= size;
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void releaseAllMemory() {
        Object object = this.lock;
        synchronized (object) {
            this.org$apache$spark$memory$StorageMemoryPool$$_memoryUsed = 0L;
            return;
        }
    }

    public long freeSpaceToShrinkPool(long spaceToFree) {
        Object object = this.lock;
        synchronized (object) {
            Long l;
            long spaceFreedByReleasingUnusedMemory = package$.MODULE$.min(spaceToFree, this.memoryFree());
            long remainingSpaceToFree = spaceToFree - spaceFreedByReleasingUnusedMemory;
            if (remainingSpaceToFree > 0L) {
                ArrayBuffer evictedBlocks = new ArrayBuffer();
                this.memoryStore().evictBlocksToFreeSpace((Option<BlockId>)None$.MODULE$, remainingSpaceToFree, (Buffer<Tuple2<BlockId, BlockStatus>>)evictedBlocks);
                long spaceFreedByEviction = BoxesRunTime.unboxToLong((Object)((TraversableOnce)evictedBlocks.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(Tuple2<BlockId, BlockStatus> x$1) {
                        return ((BlockStatus)x$1._2()).memSize();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                l = BoxesRunTime.boxToLong((long)(spaceFreedByReleasingUnusedMemory + spaceFreedByEviction));
            } else {
                l = BoxesRunTime.boxToLong((long)spaceFreedByReleasingUnusedMemory);
            }
            Long l2 = l;
            return BoxesRunTime.unboxToLong((Object)l2);
        }
    }

    public StorageMemoryPool(Object lock) {
        this.lock = lock;
        super(lock);
        Logging$class.$init$(this);
        this.org$apache$spark$memory$StorageMemoryPool$$_memoryUsed = 0L;
    }
}

