/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.metrics.MetricsConfig;
import org.apache.spark.metrics.MetricsSystem$;
import org.apache.spark.metrics.sink.MetricsServlet;
import org.apache.spark.metrics.sink.Sink;
import org.apache.spark.metrics.source.Source;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.spark-project.jetty.servlet.ServletContextHandler;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.TraitSetter;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h!B\u0001\u0003\u0001\u0011Q!!D'fiJL7m]*zgR,WN\u0003\u0002\u0004\t\u00059Q.\u001a;sS\u000e\u001c(BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0014\u0007\u0001Y\u0011\u0003\u0005\u0002\r\u001f5\tQBC\u0001\u000f\u0003\u0015\u00198-\u00197b\u0013\t\u0001RB\u0001\u0004B]f\u0014VM\u001a\t\u0003%Mi\u0011\u0001B\u0005\u0003)\u0011\u0011q\u0001T8hO&tw\r\u0003\u0005\u0017\u0001\t\u0015\r\u0011\"\u0001\u0019\u0003!Ign\u001d;b]\u000e,7\u0001A\u000b\u00023A\u0011!$\b\b\u0003\u0019mI!\u0001H\u0007\u0002\rA\u0013X\rZ3g\u0013\tqrD\u0001\u0004TiJLgn\u001a\u0006\u000395A\u0001\"\t\u0001\u0003\u0002\u0003\u0006I!G\u0001\nS:\u001cH/\u00198dK\u0002B\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\u0005G>tg\r\u0005\u0002\u0013K%\u0011a\u0005\u0002\u0002\n'B\f'o[\"p]\u001aD\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!K\u0001\fg\u0016\u001cWO]5us6;'\u000f\u0005\u0002\u0013U%\u00111\u0006\u0002\u0002\u0010'\u0016\u001cWO]5us6\u000bg.Y4fe\")Q\u0006\u0001C\u0005]\u00051A(\u001b8jiz\"BaL\u00193gA\u0011\u0001\u0007A\u0007\u0002\u0005!)a\u0003\fa\u00013!)1\u0005\fa\u0001I!)\u0001\u0006\fa\u0001S!1Q\u0007\u0001Q\u0001\nY\nQ\"\\3ue&\u001c7oQ8oM&<\u0007C\u0001\u00198\u0013\tA$AA\u0007NKR\u0014\u0018nY:D_:4\u0017n\u001a\u0005\bu\u0001\u0011\r\u0011\"\u0003<\u0003\u0015\u0019\u0018N\\6t+\u0005a\u0004cA\u001fC\t6\taH\u0003\u0002@\u0001\u00069Q.\u001e;bE2,'BA!\u000e\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u0007z\u00121\"\u0011:sCf\u0014UO\u001a4feB\u0011Q\tS\u0007\u0002\r*\u0011qIA\u0001\u0005g&t7.\u0003\u0002J\r\n!1+\u001b8l\u0011\u0019Y\u0005\u0001)A\u0005y\u000511/\u001b8lg\u0002Bq!\u0014\u0001C\u0002\u0013%a*A\u0004t_V\u00148-Z:\u0016\u0003=\u00032!\u0010\"Q!\t\tF+D\u0001S\u0015\t\u0019&!\u0001\u0004t_V\u00148-Z\u0005\u0003+J\u0013aaU8ve\u000e,\u0007BB,\u0001A\u0003%q*\u0001\u0005t_V\u00148-Z:!\u0011\u001dI\u0006A1A\u0005\ni\u000b\u0001B]3hSN$(/_\u000b\u00027B\u0011ALY\u0007\u0002;*\u00111A\u0018\u0006\u0003?\u0002\f\u0001bY8eC\"\fG.\u001a\u0006\u0002C\u0006\u00191m\\7\n\u0005\rl&AD'fiJL7MU3hSN$(/\u001f\u0005\u0007K\u0002\u0001\u000b\u0011B.\u0002\u0013I,w-[:uef\u0004\u0003bB4\u0001\u0001\u0004%I\u0001[\u0001\beVtg.\u001b8h+\u0005I\u0007C\u0001\u0007k\u0013\tYWBA\u0004C_>dW-\u00198\t\u000f5\u0004\u0001\u0019!C\u0005]\u0006Y!/\u001e8oS:<w\fJ3r)\ty'\u000f\u0005\u0002\ra&\u0011\u0011/\u0004\u0002\u0005+:LG\u000fC\u0004tY\u0006\u0005\t\u0019A5\u0002\u0007a$\u0013\u0007\u0003\u0004v\u0001\u0001\u0006K![\u0001\teVtg.\u001b8hA!9q\u000f\u0001a\u0001\n\u0013A\u0018AD7fiJL7m]*feZdW\r^\u000b\u0002sB\u0019AB\u001f?\n\u0005ml!AB(qi&|g\u000e\u0005\u0002F{&\u0011aP\u0012\u0002\u000f\u001b\u0016$(/[2t'\u0016\u0014h\u000f\\3u\u0011%\t\t\u0001\u0001a\u0001\n\u0013\t\u0019!\u0001\nnKR\u0014\u0018nY:TKJ4H.\u001a;`I\u0015\fHcA8\u0002\u0006!91o`A\u0001\u0002\u0004I\bbBA\u0005\u0001\u0001\u0006K!_\u0001\u0010[\u0016$(/[2t'\u0016\u0014h\u000f\\3uA!9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0011AE4fiN+'O\u001e7fi\"\u000bg\u000e\u001a7feN,\"!!\u0005\u0011\u000b1\t\u0019\"a\u0006\n\u0007\u0005UQBA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002\u001a\u0005\u001dRBAA\u000e\u0015\u0011\ti\"a\b\u0002\u000fM,'O\u001e7fi*!\u0011\u0011EA\u0012\u0003\u0015QW\r\u001e;z\u0015\r\t)\u0003C\u0001\bK\u000ed\u0017\u000e]:f\u0013\u0011\tI#a\u0007\u0003+M+'O\u001e7fi\u000e{g\u000e^3yi\"\u000bg\u000e\u001a7fe\"9\u0011Q\u0006\u0001\u0005\u0002\u0005=\u0012!B:uCJ$H#A8\t\u000f\u0005M\u0002\u0001\"\u0001\u00020\u0005!1\u000f^8q\u0011\u001d\t9\u0004\u0001C\u0001\u0003_\taA]3q_J$\b\u0002CA\u001e\u0001\u0011\u0005A!!\u0010\u0002#\t,\u0018\u000e\u001c3SK\u001eL7\u000f\u001e:z\u001d\u0006lW\rF\u0002\u001a\u0003\u007fAaaUA\u001d\u0001\u0004\u0001\u0006bBA\"\u0001\u0011\u0005\u0011QI\u0001\u0011O\u0016$8k\\;sG\u0016\u001c()\u001f(b[\u0016$B!a\u0012\u0002`A)\u0011\u0011JA-!:!\u00111JA+\u001d\u0011\ti%a\u0015\u000e\u0005\u0005=#bAA)/\u00051AH]8pizJ\u0011AD\u0005\u0004\u0003/j\u0011a\u00029bG.\fw-Z\u0005\u0005\u00037\niFA\u0002TKFT1!a\u0016\u000e\u0011\u001d\t\t'!\u0011A\u0002e\t!b]8ve\u000e,g*Y7f\u0011\u001d\t)\u0007\u0001C\u0001\u0003O\naB]3hSN$XM]*pkJ\u001cW\rF\u0002p\u0003SBaaUA2\u0001\u0004\u0001\u0006bBA7\u0001\u0011\u0005\u0011qN\u0001\re\u0016lwN^3T_V\u00148-\u001a\u000b\u0004_\u0006E\u0004BB*\u0002l\u0001\u0007\u0001\u000bC\u0004\u0002v\u0001!I!a\f\u0002\u001fI,w-[:uKJ\u001cv.\u001e:dKNDq!!\u001f\u0001\t\u0013\ty#A\u0007sK\u001eL7\u000f^3s'&t7n]\u0004\t\u0003{\u0012\u0001\u0012\u0001\u0003\u0002\u0000\u0005iQ*\u001a;sS\u000e\u001c8+_:uK6\u00042\u0001MAA\r\u001d\t!\u0001#\u0001\u0005\u0003\u0007\u001b2!!!\f\u0011\u001di\u0013\u0011\u0011C\u0001\u0003\u000f#\"!a \t\u0015\u0005-\u0015\u0011\u0011b\u0001\n\u0003\ti)\u0001\u0006T\u0013:[uLU#H\u000bb+\"!a$\u0011\t\u0005E\u00151T\u0007\u0003\u0003'SA!!&\u0002\u0018\u0006AQ.\u0019;dQ&twMC\u0002\u0002\u001a6\tA!\u001e;jY&!\u0011QTAJ\u0005\u0015\u0011VmZ3y\u0011%\t\t+!!!\u0002\u0013\ty)A\u0006T\u0013:[uLU#H\u000bb\u0003\u0003BCAS\u0003\u0003\u0013\r\u0011\"\u0001\u0002\u000e\u0006a1kT+S\u0007\u0016{&+R$F1\"I\u0011\u0011VAAA\u0003%\u0011qR\u0001\u000e'>+&kQ#`%\u0016;U\t\u0017\u0011\t\u0013\u00055\u0016\u0011\u0011Q\u0001\n\u0005=\u0016!E'J\u001d&k\u0015\tT0Q\u001f2cu,\u0016(J)B!\u0011\u0011WA_\u001b\t\t\u0019L\u0003\u0003\u00026\u0006]\u0016AC2p]\u000e,(O]3oi*!\u0011\u0011TA]\u0015\t\tY,\u0001\u0003kCZ\f\u0017\u0002BA`\u0003g\u0013\u0001\u0002V5nKVs\u0017\u000e\u001e\u0005\n\u0003\u0007\f\t\t)A\u0005\u0003\u000b\f1#T%O\u00136\u000bEj\u0018)P\u00192{\u0006+\u0012*J\u001f\u0012\u00032\u0001DAd\u0013\r\tI-\u0004\u0002\u0004\u0013:$\b\u0002CAg\u0003\u0003#\t!a4\u00023\rDWmY6NS:LW.\u00197Q_2d\u0017N\\4QKJLw\u000e\u001a\u000b\u0006_\u0006E\u0017Q\u001b\u0005\t\u0003'\fY\r1\u0001\u00020\u0006A\u0001o\u001c7m+:LG\u000f\u0003\u0005\u0002X\u0006-\u0007\u0019AAc\u0003)\u0001x\u000e\u001c7QKJLw\u000e\u001a\u0005\t\u00037\f\t\t\"\u0001\u0002^\u0006\u00192M]3bi\u0016lU\r\u001e:jGN\u001c\u0016p\u001d;f[R9q&a8\u0002b\u0006\r\bB\u0002\f\u0002Z\u0002\u0007\u0011\u0004\u0003\u0004$\u00033\u0004\r\u0001\n\u0005\u0007Q\u0005e\u0007\u0019A\u0015")
public class MetricsSystem
implements Logging {
    private final String instance;
    public final SparkConf org$apache$spark$metrics$MetricsSystem$$conf;
    public final SecurityManager org$apache$spark$metrics$MetricsSystem$$securityMgr;
    private final MetricsConfig metricsConfig;
    private final ArrayBuffer<Sink> org$apache$spark$metrics$MetricsSystem$$sinks;
    private final ArrayBuffer<Source> sources;
    private final MetricRegistry org$apache$spark$metrics$MetricsSystem$$registry;
    private boolean running;
    private Option<MetricsServlet> org$apache$spark$metrics$MetricsSystem$$metricsServlet;
    private transient Logger org$apache$spark$Logging$$log_;

    public static MetricsSystem createMetricsSystem(String string, SparkConf sparkConf, SecurityManager securityManager) {
        return MetricsSystem$.MODULE$.createMetricsSystem(string, sparkConf, securityManager);
    }

    public static void checkMinimalPollingPeriod(TimeUnit timeUnit, int n) {
        MetricsSystem$.MODULE$.checkMinimalPollingPeriod(timeUnit, n);
    }

    public static Regex SOURCE_REGEX() {
        return MetricsSystem$.MODULE$.SOURCE_REGEX();
    }

    public static Regex SINK_REGEX() {
        return MetricsSystem$.MODULE$.SINK_REGEX();
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public String instance() {
        return this.instance;
    }

    public ArrayBuffer<Sink> org$apache$spark$metrics$MetricsSystem$$sinks() {
        return this.org$apache$spark$metrics$MetricsSystem$$sinks;
    }

    private ArrayBuffer<Source> sources() {
        return this.sources;
    }

    public MetricRegistry org$apache$spark$metrics$MetricsSystem$$registry() {
        return this.org$apache$spark$metrics$MetricsSystem$$registry;
    }

    private boolean running() {
        return this.running;
    }

    private void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    private Option<MetricsServlet> org$apache$spark$metrics$MetricsSystem$$metricsServlet() {
        return this.org$apache$spark$metrics$MetricsSystem$$metricsServlet;
    }

    public void org$apache$spark$metrics$MetricsSystem$$metricsServlet_$eq(Option<MetricsServlet> x$1) {
        this.org$apache$spark$metrics$MetricsSystem$$metricsServlet = x$1;
    }

    public ServletContextHandler[] getServletHandlers() {
        Predef$.MODULE$.require(this.running(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Can only call getServletHandlers on a running MetricsSystem";
            }
        });
        return (ServletContextHandler[])this.org$apache$spark$metrics$MetricsSystem$$metricsServlet().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetricsSystem $outer;

            public final ServletContextHandler[] apply(MetricsServlet x$1) {
                return x$1.getHandlers(this.$outer.org$apache$spark$metrics$MetricsSystem$$conf);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ServletContextHandler[] apply() {
                return (ServletContextHandler[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ServletContextHandler.class));
            }
        });
    }

    public void start() {
        Predef$.MODULE$.require(!this.running(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Attempting to start a MetricsSystem that is already running";
            }
        });
        this.running_$eq(true);
        this.registerSources();
        this.registerSinks();
        this.org$apache$spark$metrics$MetricsSystem$$sinks().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Sink x$2) {
                x$2.start();
            }
        });
    }

    public void stop() {
        if (this.running()) {
            this.org$apache$spark$metrics$MetricsSystem$$sinks().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Sink x$3) {
                    x$3.stop();
                }
            });
        } else {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Stopping a MetricsSystem that is not running";
                }
            });
        }
        this.running_$eq(false);
    }

    public void report() {
        this.org$apache$spark$metrics$MetricsSystem$$sinks().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Sink x$4) {
                x$4.report();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    public String buildRegistryName(Source source) {
        String string;
        String defaultName;
        block7: {
            Option<String> executorId;
            Option<String> appId;
            block6: {
                appId = this.org$apache$spark$metrics$MetricsSystem$$conf.getOption("spark.app.id");
                executorId = this.org$apache$spark$metrics$MetricsSystem$$conf.getOption("spark.executor.id");
                defaultName = MetricRegistry.name((String)source.sourceName(), (String[])new String[0]);
                String string2 = this.instance();
                String string3 = "driver";
                if (!(string2 == null ? string3 != null : !string2.equals(string3))) break block6;
                String string4 = this.instance();
                String string5 = "executor";
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block7;
            }
            if (appId.isDefined() && executorId.isDefined()) {
                string = MetricRegistry.name((String)((String)appId.get()), (String[])new String[]{(String)executorId.get(), source.sourceName()});
                return string;
            }
            String warningMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using default name ", " for source because %s is not set."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defaultName}));
            if (appId.isEmpty()) {
                this.logWarning((Function0<String>)new Serializable(this, warningMsg){
                    public static final long serialVersionUID = 0L;
                    private final String warningMsg$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString(this.warningMsg$1)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"spark.app.id"}));
                    }
                    {
                        this.warningMsg$1 = warningMsg$1;
                    }
                });
            }
            if (executorId.isEmpty()) {
                this.logWarning((Function0<String>)new Serializable(this, warningMsg){
                    public static final long serialVersionUID = 0L;
                    private final String warningMsg$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString(this.warningMsg$1)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"spark.executor.id"}));
                    }
                    {
                        this.warningMsg$1 = warningMsg$1;
                    }
                });
            }
            string = defaultName;
            return string;
        }
        string = defaultName;
        return string;
    }

    public Seq<Source> getSourcesByName(String sourceName) {
        return (Seq)this.sources().filter((Function1)new Serializable(this, sourceName){
            public static final long serialVersionUID = 0L;
            private final String sourceName$1;

            public final boolean apply(Source x$5) {
                String string = x$5.sourceName();
                String string2 = this.sourceName$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.sourceName$1 = sourceName$1;
            }
        });
    }

    public void registerSource(Source source) {
        this.sources().$plus$eq((Object)source);
        try {
            String regName = this.buildRegistryName(source);
            this.org$apache$spark$metrics$MetricsSystem$$registry().register(regName, (Metric)source.metricRegistry());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Metrics already registered";
                }
            }, illegalArgumentException);
        }
    }

    public void removeSource(Source source) {
        this.sources().$minus$eq((Object)source);
        String regName = this.buildRegistryName(source);
        this.org$apache$spark$metrics$MetricsSystem$$registry().removeMatching(new MetricFilter(this, regName){
            private final String regName$1;

            public boolean matches(String name, Metric metric) {
                return name.startsWith(this.regName$1);
            }
            {
                this.regName$1 = regName$1;
            }
        });
    }

    private void registerSources() {
        Properties instConfig = this.metricsConfig.getInstance(this.instance());
        HashMap<String, Properties> sourceConfigs = this.metricsConfig.subProperties(instConfig, MetricsSystem$.MODULE$.SOURCE_REGEX());
        sourceConfigs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetricsSystem $outer;

            public final void apply(Tuple2<String, Properties> kv) {
                String classPath = ((Properties)kv._2()).getProperty("class");
                try {
                    ? source = Utils$.MODULE$.classForName(classPath).newInstance();
                    this.$outer.registerSource((Source)source);
                }
                catch (Exception exception2) {
                    this.$outer.logError((Function0<String>)new Serializable(this, classPath){
                        public static final long serialVersionUID = 0L;
                        private final String classPath$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Source class ").append((Object)this.classPath$1).append((Object)" cannot be instantiated").toString();
                        }
                        {
                            this.classPath$1 = classPath$1;
                        }
                    }, exception2);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    private void registerSinks() {
        Properties instConfig = this.metricsConfig.getInstance(this.instance());
        HashMap<String, Properties> sinkConfigs = this.metricsConfig.subProperties(instConfig, MetricsSystem$.MODULE$.SINK_REGEX());
        sinkConfigs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetricsSystem $outer;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object apply(Tuple2<String, Properties> kv) {
                BoxedUnit boxedUnit;
                String classPath = ((Properties)kv._2()).getProperty("class");
                if (classPath == null) {
                    boxedUnit = BoxedUnit.UNIT;
                    return boxedUnit;
                }
                try {
                    ? sink = Utils$.MODULE$.classForName(classPath).getConstructor(Properties.class, MetricRegistry.class, SecurityManager.class).newInstance(kv._2(), this.$outer.org$apache$spark$metrics$MetricsSystem$$registry(), this.$outer.org$apache$spark$metrics$MetricsSystem$$securityMgr);
                    Object object = kv._1();
                    String string = "servlet";
                    if (!(object != null ? !object.equals(string) : string != null)) {
                        this.$outer.org$apache$spark$metrics$MetricsSystem$$metricsServlet_$eq((Option<MetricsServlet>)new Some((Object)((MetricsServlet)sink)));
                        boxedUnit = BoxedUnit.UNIT;
                        return boxedUnit;
                    } else {
                        boxedUnit = this.$outer.org$apache$spark$metrics$MetricsSystem$$sinks().$plus$eq((Object)((Sink)sink));
                    }
                    return boxedUnit;
                }
                catch (Exception exception2) {
                    this.$outer.logError((Function0<String>)new Serializable(this, classPath){
                        public static final long serialVersionUID = 0L;
                        private final String classPath$2;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Sink class ").append((Object)this.classPath$2).append((Object)" cannot be instantiated").toString();
                        }
                        {
                            this.classPath$2 = classPath$2;
                        }
                    });
                    throw exception2;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public MetricsSystem(String instance, SparkConf conf, SecurityManager securityMgr) {
        this.instance = instance;
        this.org$apache$spark$metrics$MetricsSystem$$conf = conf;
        this.org$apache$spark$metrics$MetricsSystem$$securityMgr = securityMgr;
        Logging$class.$init$(this);
        this.metricsConfig = new MetricsConfig(conf);
        this.org$apache$spark$metrics$MetricsSystem$$sinks = new ArrayBuffer();
        this.sources = new ArrayBuffer();
        this.org$apache$spark$metrics$MetricsSystem$$registry = new MetricRegistry();
        this.running = false;
        this.org$apache$spark$metrics$MetricsSystem$$metricsServlet = None$.MODULE$;
        this.metricsConfig.initialize();
    }
}

