/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.nio.ByteBuffer;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SparkEnv;
import org.apache.spark.TaskEndReason;
import org.apache.spark.TaskResultLost$;
import org.apache.spark.TaskState$;
import org.apache.spark.UnknownReason$;
import org.apache.spark.scheduler.DirectTaskResult;
import org.apache.spark.scheduler.IndirectTaskResult;
import org.apache.spark.scheduler.TaskResult;
import org.apache.spark.scheduler.TaskResultGetter$;
import org.apache.spark.scheduler.TaskResultGetter$$anon$2$$anonfun$run$1$;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.TaskSetManager;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.storage.BlockId;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.TraitSetter;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a!B\u0001\u0003\u0001\u0011Q!\u0001\u0005+bg.\u0014Vm];mi\u001e+G\u000f^3s\u0015\t\u0019A!A\u0005tG\",G-\u001e7fe*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xmE\u0002\u0001\u0017E\u0001\"\u0001D\b\u000e\u00035Q\u0011AD\u0001\u0006g\u000e\fG.Y\u0005\u0003!5\u0011a!\u00118z%\u00164\u0007C\u0001\n\u0014\u001b\u0005!\u0011B\u0001\u000b\u0005\u0005\u001daunZ4j]\u001eD\u0001B\u0006\u0001\u0003\u0002\u0003\u0006I\u0001G\u0001\tgB\f'o[#om\u000e\u0001\u0001C\u0001\n\u001a\u0013\tQBA\u0001\u0005Ta\u0006\u00148.\u00128w\u0011!\u0019\u0001A!A!\u0002\u0013a\u0002CA\u000f\u001f\u001b\u0005\u0011\u0011BA\u0010\u0003\u0005E!\u0016m]6TG\",G-\u001e7fe&k\u0007\u000f\u001c\u0005\u0006C\u0001!\tAI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\r\"S\u0005\u0005\u0002\u001e\u0001!)a\u0003\ta\u00011!)1\u0001\ta\u00019!9q\u0005\u0001b\u0001\n\u0013A\u0013a\u0002+I%\u0016\u000bEiU\u000b\u0002SA\u0011ABK\u0005\u0003W5\u00111!\u00138u\u0011\u0019i\u0003\u0001)A\u0005S\u0005AA\u000b\u0013*F\u0003\u0012\u001b\u0006\u0005C\u00040\u0001\t\u0007I\u0011\u0002\u0019\u0002+\u001d,G\u000fV1tWJ+7/\u001e7u\u000bb,7-\u001e;peV\t\u0011\u0007\u0005\u00023s5\t1G\u0003\u00025k\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005Y:\u0014\u0001B;uS2T\u0011\u0001O\u0001\u0005U\u00064\u0018-\u0003\u0002;g\t\u0011B\u000b\u001b:fC\u0012\u0004vn\u001c7Fq\u0016\u001cW\u000f^8s\u0011\u0019a\u0004\u0001)A\u0005c\u00051r-\u001a;UCN\\'+Z:vYR,\u00050Z2vi>\u0014\b\u0005C\u0004?\u0001\t\u0007I\u0011C \u0002\u0015M,'/[1mSj,'/F\u0001A!\r\tEIR\u0007\u0002\u0005*\u00111iN\u0001\u0005Y\u0006tw-\u0003\u0002F\u0005\nYA\u000b\u001b:fC\u0012dunY1m!\t9\u0015*D\u0001I\u0015\tqD!\u0003\u0002K\u0011\n\u00112+\u001a:jC2L'0\u001a:J]N$\u0018M\\2f\u0011\u0019a\u0005\u0001)A\u0005\u0001\u0006Y1/\u001a:jC2L'0\u001a:!\u0011\u0015q\u0005\u0001\"\u0001P\u0003U)g.];fk\u0016\u001cVoY2fgN4W\u000f\u001c+bg.$B\u0001U*Y;B\u0011A\"U\u0005\u0003%6\u0011A!\u00168ji\")A+\u0014a\u0001+\u0006qA/Y:l'\u0016$X*\u00198bO\u0016\u0014\bCA\u000fW\u0013\t9&A\u0001\bUCN\\7+\u001a;NC:\fw-\u001a:\t\u000bek\u0005\u0019\u0001.\u0002\u0007QLG\r\u0005\u0002\r7&\u0011A,\u0004\u0002\u0005\u0019>tw\rC\u0003_\u001b\u0002\u0007q,\u0001\btKJL\u0017\r\\5{K\u0012$\u0015\r^1\u0011\u0005\u0001\u001cW\"A1\u000b\u0005\t<\u0014a\u00018j_&\u0011A-\u0019\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\"\u00024\u0001\t\u00039\u0017!E3ocV,W/\u001a$bS2,G\rV1tWR)\u0001\u000b[5ky\")A+\u001aa\u0001+\")\u0011,\u001aa\u00015\")1.\u001aa\u0001Y\u0006IA/Y:l'R\fG/\u001a\t\u0003[ft!A\\<\u000f\u0005=4hB\u00019v\u001d\t\tH/D\u0001s\u0015\t\u0019x#\u0001\u0004=e>|GOP\u0005\u0002\u0013%\u0011q\u0001C\u0005\u0003\u000b\u0019I!\u0001\u001f\u0003\u0002\u0013Q\u000b7o[*uCR,\u0017B\u0001>|\u0005%!\u0016m]6Ti\u0006$XM\u0003\u0002y\t!)a,\u001aa\u0001?\")a\u0010\u0001C\u0001\u007f\u0006!1\u000f^8q)\u0005\u0001\u0006")
public class TaskResultGetter
implements Logging {
    public final SparkEnv org$apache$spark$scheduler$TaskResultGetter$$sparkEnv;
    public final TaskSchedulerImpl org$apache$spark$scheduler$TaskResultGetter$$scheduler;
    private final int THREADS;
    private final ThreadPoolExecutor getTaskResultExecutor;
    private final ThreadLocal<SerializerInstance> serializer;
    private transient Logger org$apache$spark$Logging$$log_;

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    private int THREADS() {
        return this.THREADS;
    }

    private ThreadPoolExecutor getTaskResultExecutor() {
        return this.getTaskResultExecutor;
    }

    public ThreadLocal<SerializerInstance> serializer() {
        return this.serializer;
    }

    public void enqueueSuccessfulTask(TaskSetManager taskSetManager, long tid, ByteBuffer serializedData) {
        this.getTaskResultExecutor().execute(new Runnable(this, taskSetManager, tid, serializedData){
            private final /* synthetic */ TaskResultGetter $outer;
            public final TaskSetManager taskSetManager$1;
            public final long tid$1;
            public final ByteBuffer serializedData$1;

            public void run() {
                NonLocalReturnControl nonLocalReturnControl2;
                block2: {
                    Object object = new Object();
                    try {
                        Utils$.MODULE$.logUncaughtExceptions(new Serializable(this, object){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$2 $outer;
                            private final Object nonLocalReturnKey1$1;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            /*
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            public void apply$mcV$sp() {
                                try {
                                    Tuple2 tuple2;
                                    Tuple2 tuple22;
                                    TaskResult taskResult = (TaskResult)this.$outer.org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer().serializer().get().deserialize(this.$outer.serializedData$1, ClassTag$.MODULE$.apply(TaskResult.class));
                                    if (taskResult instanceof DirectTaskResult) {
                                        DirectTaskResult directTaskResult = (DirectTaskResult)taskResult;
                                        if (!this.$outer.taskSetManager$1.canFetchMoreResults(this.$outer.serializedData$1.limit())) throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                                        directTaskResult.value();
                                        tuple22 = new Tuple2((Object)directTaskResult, (Object)BoxesRunTime.boxToInteger((int)this.$outer.serializedData$1.limit()));
                                    } else {
                                        if (!(taskResult instanceof IndirectTaskResult)) throw new MatchError((Object)taskResult);
                                        IndirectTaskResult indirectTaskResult = (IndirectTaskResult)taskResult;
                                        BlockId blockId = indirectTaskResult.blockId();
                                        int size = indirectTaskResult.size();
                                        if (!this.$outer.taskSetManager$1.canFetchMoreResults(size)) {
                                            this.$outer.org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer().org$apache$spark$scheduler$TaskResultGetter$$sparkEnv.blockManager().master().removeBlock(blockId);
                                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                                        }
                                        this.$outer.org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer().logDebug((Function0<String>)new $anon$2$$anonfun$run$1$$anonfun$1(this));
                                        this.$outer.org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer().org$apache$spark$scheduler$TaskResultGetter$$scheduler.handleTaskGettingResult(this.$outer.taskSetManager$1, this.$outer.tid$1);
                                        Option<ByteBuffer> serializedTaskResult = this.$outer.org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer().org$apache$spark$scheduler$TaskResultGetter$$sparkEnv.blockManager().getRemoteBytes(blockId);
                                        if (!serializedTaskResult.isDefined()) {
                                            this.$outer.org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer().org$apache$spark$scheduler$TaskResultGetter$$scheduler.handleFailedTask(this.$outer.taskSetManager$1, this.$outer.tid$1, TaskState$.MODULE$.FINISHED(), TaskResultLost$.MODULE$);
                                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                                        }
                                        DirectTaskResult deserializedResult = (DirectTaskResult)this.$outer.org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer().serializer().get().deserialize((ByteBuffer)serializedTaskResult.get(), ClassTag$.MODULE$.apply(DirectTaskResult.class));
                                        this.$outer.org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer().org$apache$spark$scheduler$TaskResultGetter$$sparkEnv.blockManager().master().removeBlock(blockId);
                                        tuple22 = new Tuple2((Object)deserializedResult, (Object)BoxesRunTime.boxToInteger((int)size));
                                    }
                                    Tuple2 tuple23 = tuple22;
                                    if (tuple23 == null) throw new MatchError((Object)tuple23);
                                    DirectTaskResult result = (DirectTaskResult)tuple23._1();
                                    int size = tuple23._2$mcI$sp();
                                    Tuple2 tuple24 = tuple2 = new Tuple2((Object)result, (Object)BoxesRunTime.boxToInteger((int)size));
                                    DirectTaskResult result2 = (DirectTaskResult)tuple24._1();
                                    int size2 = tuple24._2$mcI$sp();
                                    result2.metrics().setResultSize(size2);
                                    this.$outer.org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer().org$apache$spark$scheduler$TaskResultGetter$$scheduler.handleSuccessfulTask(this.$outer.taskSetManager$1, this.$outer.tid$1, result2);
                                    return;
                                }
                                catch (Throwable throwable) {
                                    Throwable throwable2 = throwable;
                                    if (throwable2 instanceof ClassNotFoundException) {
                                        ClassLoader loader = Thread.currentThread().getContextClassLoader();
                                        this.$outer.taskSetManager$1.abort(new StringBuilder().append((Object)"ClassNotFound with classloader: ").append((Object)loader).toString(), this.$outer.taskSetManager$1.abort$default$2());
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        return;
                                    }
                                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                                    if (option.isEmpty()) {
                                        throw throwable;
                                    }
                                    Throwable ex = (Throwable)option.get();
                                    this.$outer.org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer().logError((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "Exception while getting task result";
                                        }
                                    }, ex);
                                    this.$outer.taskSetManager$1.abort(new StringOps(Predef$.MODULE$.augmentString("Exception while getting task result: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ex})), this.$outer.taskSetManager$1.abort$default$2());
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                }
                            }

                            public /* synthetic */ $anon$2 org$apache$spark$scheduler$TaskResultGetter$$anon$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                            }
                        });
                    }
                    catch (NonLocalReturnControl nonLocalReturnControl2) {
                        if (nonLocalReturnControl2.key() != object) break block2;
                        nonLocalReturnControl2.value$mcV$sp();
                    }
                    return;
                }
                throw nonLocalReturnControl2;
            }

            public /* synthetic */ TaskResultGetter org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.taskSetManager$1 = taskSetManager$1;
                this.tid$1 = tid$1;
                this.serializedData$1 = serializedData$1;
            }
        });
    }

    public void enqueueFailedTask(TaskSetManager taskSetManager, long tid, Enumeration.Value taskState, ByteBuffer serializedData) {
        Throwable throwable2;
        block2: {
            ObjectRef reason = new ObjectRef((Object)UnknownReason$.MODULE$);
            try {
                this.getTaskResultExecutor().execute(new Runnable(this, taskSetManager, tid, taskState, serializedData, reason){
                    private final /* synthetic */ TaskResultGetter $outer;
                    public final TaskSetManager taskSetManager$2;
                    public final long tid$2;
                    public final Enumeration.Value taskState$1;
                    public final ByteBuffer serializedData$2;
                    public final ObjectRef reason$1;

                    public void run() {
                        Utils$.MODULE$.logUncaughtExceptions(new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$3 $outer;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                ClassLoader loader = Utils$.MODULE$.getContextOrSparkClassLoader();
                                try {
                                    if (this.$outer.serializedData$2 != null && this.$outer.serializedData$2.limit() > 0) {
                                        this.$outer.reason$1.elem = (TaskEndReason)this.$outer.org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer().serializer().get().deserialize(this.$outer.serializedData$2, loader, ClassTag$.MODULE$.apply(TaskEndReason.class));
                                    }
                                }
                                catch (Exception exception2) {
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    this.$outer.org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer().logError((Function0<String>)new Serializable(this, loader){
                                        public static final long serialVersionUID = 0L;
                                        private final ClassLoader loader$1;

                                        public final String apply() {
                                            return new StringBuilder().append((Object)"Could not deserialize TaskEndReason: ClassNotFound with classloader ").append((Object)this.loader$1).toString();
                                        }
                                        {
                                            this.loader$1 = loader$1;
                                        }
                                    });
                                }
                                this.$outer.org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer().org$apache$spark$scheduler$TaskResultGetter$$scheduler.handleFailedTask(this.$outer.taskSetManager$2, this.$outer.tid$2, this.$outer.taskState$1, (TaskEndReason)this.$outer.reason$1.elem);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ TaskResultGetter org$apache$spark$scheduler$TaskResultGetter$$anon$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.taskSetManager$2 = taskSetManager$2;
                        this.tid$2 = tid$2;
                        this.taskState$1 = taskState$1;
                        this.serializedData$2 = serializedData$2;
                        this.reason$1 = reason$1;
                    }
                });
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                if (!(throwable3 instanceof RejectedExecutionException) || !this.org$apache$spark$scheduler$TaskResultGetter$$sparkEnv.isStopped()) break block2;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw throwable2;
    }

    public void stop() {
        this.getTaskResultExecutor().shutdownNow();
    }

    public TaskResultGetter(SparkEnv sparkEnv, TaskSchedulerImpl scheduler) {
        this.org$apache$spark$scheduler$TaskResultGetter$$sparkEnv = sparkEnv;
        this.org$apache$spark$scheduler$TaskResultGetter$$scheduler = scheduler;
        Logging$class.$init$(this);
        this.THREADS = sparkEnv.conf().getInt("spark.resultGetter.threads", 4);
        this.getTaskResultExecutor = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(this.THREADS(), "task-result-getter");
        this.serializer = new $anon$1(this);
    }
}

